/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.validation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Path;
import jakarta.validation.Payload;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.ws.rs.QueryParam;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.jaxrs.validation.JAXRSBeanValidationInInterceptor;
import org.apache.cxf.logging.FaultListener;
import org.apache.cxf.logging.NoOpFaultListener;
import org.apache.cxf.message.Message;
import org.hibernate.validator.internal.engine.ConstraintViolationImpl;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.util.annotation.ConstraintAnnotationDescriptor;
import org.ligoj.bootstrap.core.validation.ValidatorBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class JAXRSBeanValidationImplicitInInterceptor
extends JAXRSBeanValidationInInterceptor {
    @Value(value="#{'${validation.excludes:jakarta.ws.rs,org.apache.cxf.jaxrs.ext.multipart.Multipart}'.split(',')}")
    private final Collection<String> excludes = Collections.singleton(QueryParam.class.getPackage().getName());
    @Autowired
    private ValidatorBean validator;
    private static final ConstraintDescriptor<NotNull> NOT_NULL_DESCRIPTOR = new ConstraintDescriptorImpl(ConstraintHelper.forAllBuiltinConstraints(), null, new ConstraintAnnotationDescriptor((Annotation)new NotNull(){

        public Class<? extends Annotation> annotationType() {
            return NotNull.class;
        }

        public String message() {
            return "NotNull";
        }

        public Class<?>[] groups() {
            return new Class[0];
        }

        public Class<? extends Payload>[] payload() {
            return new Class[0];
        }
    }), ConstraintLocation.ConstraintLocationKind.PARAMETER);

    protected void handleValidation(Message message, Object resourceInstance, Method method, List<Object> arguments) {
        super.handleValidation(message, resourceInstance, method, arguments);
        HashSet validationErrors = new HashSet();
        for (int index = 0; index < arguments.size(); ++index) {
            Parameter parameter = method.getParameters()[index];
            if (!this.hasToBeValidated(parameter)) continue;
            this.validate(arguments.get(index), method, parameter, index, validationErrors);
        }
        if (!validationErrors.isEmpty()) {
            message.put((Object)FaultListener.class.getName(), (Object)new NoOpFaultListener());
            throw new ConstraintViolationException(validationErrors);
        }
    }

    private void validate(Object bean, Method method, Parameter parameter, int index, Set<ConstraintViolation<?>> validationErrors) {
        if (bean == null) {
            PathImpl propertyPath = PathImpl.createPathFromString((String)method.getName());
            propertyPath.addParameterNode(parameter.getName(), index);
            validationErrors.add(ConstraintViolationImpl.forParameterValidation((String)NotNull.class.getName(), null, null, (String)"interpolated", null, null, null, null, (Path)propertyPath, NOT_NULL_DESCRIPTOR, null, null));
            return;
        }
        Class<?> clazz = bean.getClass();
        if (Collection.class.isAssignableFrom(clazz)) {
            this.validate((Collection)bean, validationErrors);
        } else if (clazz.isArray()) {
            this.validate((Object[])bean, validationErrors);
        } else {
            this.validateSimpleBean(bean, validationErrors);
        }
    }

    private void validate(Object[] beans, Set<ConstraintViolation<?>> validationErrors) {
        validationErrors.addAll(this.validator.validate(beans, new Class[0]));
    }

    private void validate(Collection<?> beans, Set<ConstraintViolation<?>> validationErrors) {
        validationErrors.addAll(this.validator.validate(beans, new Class[0]));
    }

    private void validateSimpleBean(Object bean, Set<ConstraintViolation<?>> validationErrors) {
        validationErrors.addAll(this.validator.validate(bean, new Class[0]));
    }

    private boolean hasToBeValidated(Annotation annotation) {
        return this.excludes.stream().noneMatch(annotation.annotationType().getName()::startsWith);
    }

    private boolean hasToBeValidated(Parameter parameter) {
        return Arrays.stream(parameter.getAnnotations()).allMatch(this::hasToBeValidated);
    }
}

