/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.validation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ValidatorBean {
    private final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        return this.validator.validate(object, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validate(Collection<T> objects, Class<?> ... groups) {
        HashSet<ConstraintViolation<T>> errors = new HashSet<ConstraintViolation<T>>();
        for (T object : objects) {
            errors.addAll(this.validate(object, groups));
        }
        return errors;
    }

    public <T> void validateCheck(T object, Class<?> ... groups) {
        this.validateCheck((Collection<T>)Collections.singleton(object), groups);
    }

    public <T> void validateCheck(T[] objects, Class<?> ... groups) {
        this.validateCheck((Collection<T>)Arrays.asList(objects), groups);
    }

    public <T> void validateCheck(Collection<T> objects, Class<?> ... groups) {
        HashSet<ConstraintViolation<T>> errors = new HashSet<ConstraintViolation<T>>(this.validate(objects, groups));
        if (!errors.isEmpty()) {
            throw new ConstraintViolationException(StringUtils.join(errors, (char)','), errors);
        }
    }

    @Generated
    public Validator getValidator() {
        return this.validator;
    }
}

