/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system.cache;

import com.hazelcast.cache.HazelcastCacheManager;
import com.hazelcast.cache.HazelcastCachingProvider;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ModifiedExpiryPolicy;
import lombok.Generated;
import org.ligoj.bootstrap.resource.system.cache.CacheManagerAware;
import org.ligoj.bootstrap.resource.system.configuration.ConfigurationResource;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;

public class MergedHazelCastManagerFactoryBean
implements FactoryBean<CacheManager>,
InitializingBean,
DisposableBean {
    protected CacheManager cacheManager;
    private String location;
    @Autowired
    protected ApplicationContext context;
    @Autowired
    protected ConfigurationResource configuration;
    @Value(value="${hazelcast.statistics.enable:false}")
    private boolean statisticsEnabled = false;

    public void afterPropertiesSet() throws URISyntaxException {
        System.setProperty("hazelcast.jcache.provider.type", "member");
        Properties properties = HazelcastCachingProvider.propertiesByLocation((String)this.location);
        HazelcastCachingProvider provider = (HazelcastCachingProvider)Caching.getCachingProvider();
        HazelcastCacheManager manager = (HazelcastCacheManager)provider.getCacheManager(new URI("bootstrap-cache-manager"), null, properties);
        this.context.getBeansOfType(CacheManagerAware.class).forEach((n, a) -> a.onCreate(manager, this::newCacheConfig));
        this.cacheManager = manager;
    }

    protected void postConfigure(CacheConfig<?, ?> mapConfig) {
        if (this.statisticsEnabled) {
            mapConfig.setStatisticsEnabled(true);
        }
    }

    protected CacheConfig<?, ?> newCacheConfig(String name) {
        CacheConfig config = new CacheConfig(name);
        config.setEvictionConfig(new EvictionConfig().setEvictionPolicy(EvictionPolicy.LRU));
        this.postConfigure(config);
        int ttlDuration = this.configuration.get("cache." + name + ".ttl", -1);
        if (ttlDuration == -1) {
            config.setExpiryPolicyFactory(ModifiedExpiryPolicy.factoryOf((Duration)Duration.ETERNAL));
        } else {
            config.setExpiryPolicyFactory(ModifiedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.SECONDS, (long)ttlDuration)));
        }
        return config;
    }

    public CacheManager getObject() {
        return this.cacheManager;
    }

    public Class<? extends CacheManager> getObjectType() {
        return this.cacheManager == null ? CacheManager.class : this.cacheManager.getClass();
    }

    public void destroy() {
        this.cacheManager.close();
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }
}

