/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system.file;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.ligoj.bootstrap.resource.system.configuration.ConfigurationResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Path(value="/system/file")
@Service
@Transactional
@Produces(value={"application/json"})
public class FileResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileResource.class);
    @Autowired
    private ConfigurationResource configurationResource;

    @GET
    public InputStream download(@QueryParam(value="path") String path) throws IOException {
        this.checkPath(path);
        return new FileInputStream(path);
    }

    private boolean isAllowedPath(String path) {
        return Arrays.stream(this.configurationResource.get("ligoj.file.path", "^$").split(",")).anyMatch(path::matches);
    }

    private void checkPath(String path) {
        if (!this.isAllowedPath(path)) {
            throw new ForbiddenException("Path location is not within one of allowed ${ligoj.file.path} value");
        }
    }

    @PUT
    @Consumes(value={"multipart/form-data"})
    public void upload(@Multipart(value="content") InputStream content, @Multipart(value="path") String path, @Multipart(value="executable") String executable) throws IOException {
        this.checkPath(path);
        log.info("Upload file {}, executable:{}", (Object)path, (Object)executable);
        File file = new File(path);
        FileUtils.createParentDirectories((File)file);
        try (FileOutputStream out = new FileOutputStream(file);){
            content.transferTo(out);
        }
        file.setExecutable(BooleanUtils.toBoolean((String)executable));
    }

    @DELETE
    public void delete(@QueryParam(value="path") String path) throws IOException {
        this.checkPath(path);
        FileUtils.delete((File)new File(path));
    }
}

