/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system.hook;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.cxf.message.Exchange;
import org.ligoj.bootstrap.model.system.SystemHook;
import org.ligoj.bootstrap.resource.system.configuration.ConfigurationResource;
import org.ligoj.bootstrap.resource.system.hook.HookResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class HookProcessRunnable
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HookProcessRunnable.class);
    static final Base64 BASE64_CODEC = new Base64(0);
    static final int DEFAULT_TIMEOUT = Integer.parseInt(System.getProperty("LIGOJ_HOOK_TIMEOUT", "30"), 10);
    private final String now;
    private final ObjectMapper objectMapper;
    private final List<? extends SystemHook> hooks;
    private final ContainerRequestContext requestContext;
    private final ContainerResponseContext responseContext;
    private final Exchange exchange;
    private final Principal principal;
    private final ConfigurationResource configuration;
    private static final Class<?>[] IGNORED_CLASSES = new Class[]{UriInfo.class, SecurityContext.class, ServletConfig.class, ServletRequest.class, ServletResponse.class, InputStream.class, ApplicationContext.class};

    @Override
    public void run() {
        this.process();
    }

    ProcessBuilder newBuilder(SystemHook hook) {
        return new ProcessBuilder((String[])ArrayUtils.addAll((Object[])hook.getCommand().split(" "), (Object[])new String[0])).directory(new File(hook.getWorkingDirectory()));
    }

    private Object convertForPayload(Object parameter) {
        if (Arrays.stream(IGNORED_CLASSES).anyMatch(c -> parameter != null && c.isAssignableFrom(parameter.getClass()))) {
            return "<" + parameter.getClass().getSimpleName() + ">";
        }
        return parameter;
    }

    void process(String path, SystemHook h, OutputStream out) {
        log.info("[Hook {} -> {}] Triggered", (Object)path, (Object)h.getName());
        if (!HookResource.isAllowedCommand(this.configuration, h.getCommand())) {
            log.info("[Hook {} -> {}] Triggered but skipped because command is not within one of allowed ${ligoj.hook.path} value ", (Object)path, (Object)h.getName());
            return;
        }
        log.info("[Hook {} -> {}] Triggered", (Object)path, (Object)h.getName());
        long start = System.currentTimeMillis();
        try {
            List<Object> params = ((List)this.exchange.getInMessage().getContent(List.class)).stream().map(this::convertForPayload).toList();
            int timeout = (Integer)ObjectUtils.defaultIfNull((Object)h.getTimeout(), (Object)0) > 0 ? h.getTimeout().intValue() : this.configuration.get("LIGOJ_HOOK_TIMEOUT", DEFAULT_TIMEOUT);
            HashMap<String, List<Object>> payload = new HashMap<String, List<Object>>(Map.of("now", this.now, "name", h.getName(), "path", this.requestContext.getUriInfo().getPath(), "method", this.requestContext.getMethod(), "api", this.exchange.get((Object)"org.apache.cxf.resource.operation.name"), "inject", CollectionUtils.emptyIfNull((Collection)h.getInject()).stream().collect(Collectors.toMap(Function.identity(), name -> this.configuration.get((String)name, ""))), "timeout", timeout, "params", params));
            payload.put("user", Optional.ofNullable(this.principal).map(Principal::getName).orElse(null));
            payload.put("result", (List<Object>)this.convertForPayload(this.responseContext.getEntity()));
            String payloadJson = this.objectMapper.writeValueAsString(payload);
            String payload64 = BASE64_CODEC.encodeToString(payloadJson.getBytes(StandardCharsets.UTF_8));
            ProcessBuilder pb = this.newBuilder(h);
            pb.environment().put("PAYLOAD", payload64);
            Process process = pb.start();
            process.getInputStream().transferTo(out);
            int code = process.waitFor(timeout, TimeUnit.SECONDS) ? process.exitValue() : -1;
            out.flush();
            log.info("[Hook {} -> {}] Succeed, code: {}, duration: {}", new Object[]{path, h.getName(), code, DurationFormatUtils.formatDurationHMS((long)(System.currentTimeMillis() - start))});
        }
        catch (Exception ex) {
            log.error("[Hook {} -> {}] Failed, duration: {}", new Object[]{path, h.getName(), DurationFormatUtils.formatDurationHMS((long)(System.currentTimeMillis() - start)), ex});
        }
    }

    private void process() {
        String path = this.requestContext.getUriInfo().getPath();
        this.hooks.forEach(h -> this.process(path, (SystemHook)h, System.out));
    }

    @Generated
    public HookProcessRunnable(String now, ObjectMapper objectMapper, List<? extends SystemHook> hooks, ContainerRequestContext requestContext, ContainerResponseContext responseContext, Exchange exchange, Principal principal, ConfigurationResource configuration) {
        this.now = now;
        this.objectMapper = objectMapper;
        this.hooks = hooks;
        this.requestContext = requestContext;
        this.responseContext = responseContext;
        this.exchange = exchange;
        this.principal = principal;
        this.configuration = configuration;
    }
}

