/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system.hook;

import com.fasterxml.jackson.core.JsonProcessingException;
import jakarta.transaction.Transactional;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.cache.annotation.CacheRemoveAll;
import org.ligoj.bootstrap.core.json.ObjectMapperTrim;
import org.ligoj.bootstrap.core.json.PaginationJson;
import org.ligoj.bootstrap.core.json.TableItem;
import org.ligoj.bootstrap.dao.system.SystemHookRepository;
import org.ligoj.bootstrap.model.system.HookMatch;
import org.ligoj.bootstrap.model.system.SystemHook;
import org.ligoj.bootstrap.resource.system.configuration.ConfigurationResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Path(value="/system/hook")
@Service
@Transactional
@Produces(value={"application/json"})
public class HookResource {
    @Autowired
    private ObjectMapperTrim objectMapper;
    @Autowired
    private PaginationJson paginationJson;
    @Autowired
    protected SystemHookRepository repository;
    @Autowired
    protected ConfigurationResource configurationResource;
    private static final Map<String, String> ORDERED_COLUMNS = new HashMap<String, String>();

    @GET
    @Path(value="{id:\\d}")
    public SystemHook findById(@PathParam(value="id") int id) {
        return (SystemHook)this.repository.findOneExpected(id);
    }

    @GET
    @Path(value="name/{name}")
    public SystemHook findByName(@PathParam(value="id") String name) {
        return (SystemHook)this.repository.findByNameExpected(name);
    }

    @GET
    public TableItem<SystemHook> findAll(@Context UriInfo uriInfo) {
        PageRequest pageRequest = this.paginationJson.getPageRequest(uriInfo, ORDERED_COLUMNS);
        Page findAll = this.repository.findAll((Pageable)pageRequest);
        return this.paginationJson.applyPagination(uriInfo, findAll, Function.identity());
    }

    static boolean isAllowedCommand(ConfigurationResource configurationResource, String command) {
        return Arrays.stream(configurationResource.get("ligoj.hook.path", "^$").split(",")).anyMatch(command::matches);
    }

    @POST
    @PUT
    @CacheRemoveAll(cacheName="hooks")
    public int create(SystemHook vo) throws JsonProcessingException {
        if (!HookResource.isAllowedCommand(this.configurationResource, vo.getCommand())) {
            throw new ForbiddenException("Hook command is not within one of allowed ${ligoj.hook.path} value");
        }
        Pattern.compile(((HookMatch)this.objectMapper.readValue(vo.getMatch(), HookMatch.class)).getPath());
        return (Integer)((SystemHook)this.repository.saveAndFlush(vo)).getId();
    }

    @DELETE
    @Path(value="{id:\\d+}")
    @CacheRemoveAll(cacheName="hooks")
    public void delete(@PathParam(value="id") int id) {
        this.repository.deleteAllExpected(List.of(Integer.valueOf(id)));
    }

    static {
        ORDERED_COLUMNS.put("id", "id");
        ORDERED_COLUMNS.put("name", "name");
    }
}

