/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system.user;

import jakarta.persistence.criteria.JoinType;
import jakarta.transaction.Transactional;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheRemove;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.bootstrap.core.NamedBean;
import org.ligoj.bootstrap.core.dao.PaginationDao;
import org.ligoj.bootstrap.core.json.PaginationJson;
import org.ligoj.bootstrap.core.json.TableItem;
import org.ligoj.bootstrap.dao.system.SystemRoleAssignmentRepository;
import org.ligoj.bootstrap.dao.system.SystemUserRepository;
import org.ligoj.bootstrap.model.system.SystemRole;
import org.ligoj.bootstrap.model.system.SystemRoleAssignment;
import org.ligoj.bootstrap.model.system.SystemUser;
import org.ligoj.bootstrap.resource.system.api.ApiTokenResource;
import org.ligoj.bootstrap.resource.system.security.SystemRoleVo;
import org.ligoj.bootstrap.resource.system.user.SystemUserEditionVo;
import org.ligoj.bootstrap.resource.system.user.SystemUserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Path(value="/system/user")
@Transactional
@Produces(value={"application/json"})
public class UserResource {
    @Autowired
    private PaginationDao pagination;
    @Autowired
    private PaginationJson paginationJson;
    @Autowired
    private ApiTokenResource apiTokenResource;
    @Autowired
    private SystemUserRepository repository;
    @Autowired
    private SystemRoleAssignmentRepository roleAssignmentRepository;
    @Autowired
    protected CacheManager cacheManager;
    private static final Map<String, String> ORDERED_COLUMNS = new HashMap<String, String>();
    private static final Map<String, JoinType> FETCHED_ASSOCIATIONS;
    private static final ToBusinessConverterRole TO_BUSINESS_ROLES;
    private static final ToBusinessConverter TO_BUSINESS;

    @GET
    @Path(value="{login}")
    public SystemUser findById(@PathParam(value="login") String login) {
        return (SystemUser)this.repository.findOneExpected(login);
    }

    @GET
    public TableItem<String> findAll(@Context UriInfo uriInfo) {
        return this.paginationJson.applyPagination(uriInfo, this.repository.findAll((Pageable)this.paginationJson.getPageRequest(uriInfo, ORDERED_COLUMNS)), TO_BUSINESS);
    }

    @GET
    @Path(value="roles")
    public TableItem<SystemUserVo> findAllWithRoles(@Context UriInfo uriInfo) {
        Page<SystemUser> findAll = this.pagination.findAll(SystemUser.class, uriInfo, ORDERED_COLUMNS, null, FETCHED_ASSOCIATIONS);
        return this.paginationJson.applyPagination(uriInfo, findAll, TO_BUSINESS_ROLES);
    }

    @POST
    public NamedBean<String> create(SystemUserEditionVo userVo) throws GeneralSecurityException {
        String targetUser = userVo.getLogin();
        SystemUser user = Objects.requireNonNullElseGet((SystemUser)this.repository.findOne(targetUser), () -> {
            SystemUser newUser = new SystemUser();
            newUser.setLogin(targetUser);
            newUser.setRoles(new HashSet());
            return newUser;
        });
        user = (SystemUser)this.repository.save(user);
        this.createRoleAssignment(userVo.getRoles(), user);
        if (StringUtils.isNotBlank((CharSequence)userVo.getApiToken()) && !this.apiTokenResource.hasToken(targetUser, userVo.getApiToken())) {
            return this.apiTokenResource.create(targetUser, userVo.getApiToken());
        }
        return null;
    }

    @PUT
    public void update(SystemUserEditionVo userVo) {
        SystemUser user = (SystemUser)this.repository.findOneExpected(userVo.getLogin());
        this.createRoleAssignment(userVo.getRoles(), user);
    }

    private void createRoleAssignment(Set<Integer> targetRoles, SystemUser user) {
        HashSet<Integer> deletedRoles = new HashSet<Integer>(user.getRoles().stream().map(r -> (Integer)r.getRole().getId()).toList());
        deletedRoles.removeAll(targetRoles);
        HashSet<Integer> newRoles = new HashSet<Integer>(targetRoles);
        user.getRoles().stream().map(r -> (Integer)r.getRole().getId()).forEach(newRoles::remove);
        deletedRoles.forEach(r -> this.roleAssignmentRepository.deleteAllBy("user.id", user.getLogin(), new String[]{"role.id"}, r));
        newRoles.forEach(r -> {
            SystemRoleAssignment roleAssignment = new SystemRoleAssignment();
            SystemRole role = new SystemRole();
            role.setId((Serializable)r);
            roleAssignment.setRole(role);
            roleAssignment.setUser(user);
            this.roleAssignmentRepository.save(roleAssignment);
        });
        this.cacheManager.getCache("user-details").evict((Object)user.getLogin());
    }

    @DELETE
    @Path(value="{login}")
    @CacheRemove(cacheName="user-details")
    public void delete(@PathParam(value="login") @CacheKey String login) {
        this.apiTokenResource.removeAll(login);
        this.roleAssignmentRepository.deleteAllBy("user.id", login);
        this.repository.deleteById(login);
    }

    static {
        ORDERED_COLUMNS.put("login", "login");
        ORDERED_COLUMNS.put("role", "roles.role.name");
        FETCHED_ASSOCIATIONS = new HashMap<String, JoinType>();
        FETCHED_ASSOCIATIONS.put("roles", JoinType.LEFT);
        TO_BUSINESS_ROLES = new ToBusinessConverterRole();
        TO_BUSINESS = new ToBusinessConverter();
    }

    private static class ToBusinessConverter
    implements Function<SystemUser, String> {
        private ToBusinessConverter() {
        }

        @Override
        public String apply(SystemUser user) {
            return user.getLogin();
        }
    }

    private static class ToBusinessConverterRole
    implements Function<SystemUser, SystemUserVo> {
        private ToBusinessConverterRole() {
        }

        @Override
        public SystemUserVo apply(SystemUser user) {
            SystemUserVo userVo = new SystemUserVo();
            userVo.setLogin(user.getLogin());
            userVo.setRoles(new ArrayList<SystemRoleVo>());
            Set roles = user.getRoles();
            HashSet<String> uniqueRoles = new HashSet<String>();
            for (SystemRoleAssignment role : roles) {
                if (!uniqueRoles.add(role.getRole().getName())) continue;
                SystemRoleVo systemRoleVo = new SystemRoleVo();
                systemRoleVo.setId((Integer)role.getRole().getId());
                systemRoleVo.setName(role.getRole().getName());
                userVo.getRoles().add(systemRoleVo);
            }
            return userVo;
        }
    }
}

