/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static final String SETTINGS = "META-INF/jetty/jetty-dev.properties";
    private final Server server = new Server();
    private static Server lastStartedServer;

    public Main() throws Exception {
        String jettyPropertiesFile = System.getProperty("jetty.properties", SETTINGS);
        try (InputStream propertiesInput = this.configure(jettyPropertiesFile);){
            log.debug("Loading Jetty Settings from {}", (Object)SETTINGS);
        }
    }

    public Server getServer() {
        return this.server;
    }

    public static Server getLastStartedServer() {
        return lastStartedServer;
    }

    private InputStream configure(String jettyPropertiesFile) throws Exception {
        InputStream propertiesInput = Thread.currentThread().getContextClassLoader().getResourceAsStream(jettyPropertiesFile);
        if (propertiesInput == null) {
            log.error("Unable to find jetty properties file : " + jettyPropertiesFile);
        } else {
            this.copyProperties(propertiesInput);
            new XmlConfiguration(Resource.newResource((URL)Thread.currentThread().getContextClassLoader().getResource(System.getProperty("jetty.xml", "META-INF/jetty/jetty.xml")))).configure((Object)this.server);
        }
        return propertiesInput;
    }

    private void copyProperties(InputStream propertiesInput) throws IOException {
        Properties properties = new Properties();
        properties.load(propertiesInput);
        properties.putAll((Map<?, ?>)System.getProperties());
        System.setProperties(properties);
    }

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        main.server.start();
        lastStartedServer = main.server;
        try {
            main.server.join();
        }
        catch (ThreadDeath td) {
            log.error("Unexpected server shutdown", (Throwable)td);
        }
    }
}

