/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.id.dao;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import lombok.Generated;
import org.ligoj.app.api.Normalizer;
import org.ligoj.app.iam.CompanyOrg;
import org.ligoj.app.iam.GroupOrg;
import org.ligoj.app.iam.ICompanyRepository;
import org.ligoj.app.iam.IGroupRepository;
import org.ligoj.app.iam.IUserRepository;
import org.ligoj.app.iam.IamProvider;
import org.ligoj.app.iam.ResourceOrg;
import org.ligoj.app.iam.UserOrg;
import org.ligoj.app.plugin.id.dao.IdCacheDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMemCacheRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractMemCacheRepository.class);
    @Autowired
    protected IdCacheDao cache;
    @Autowired
    protected IamProvider[] iamProvider;
    protected Map<CacheDataType, Map<String, ? extends ResourceOrg>> data;

    public void addGroupToGroup(GroupOrg subGroup, GroupOrg group) {
        this.cache.addGroupToGroup(subGroup, group);
        group.getSubGroups().add((String)((Object)subGroup.getId()));
        subGroup.setParent((String)((Object)group.getId()));
    }

    public void addUserToGroup(UserOrg user, GroupOrg group) {
        this.cache.addUserToGroup(user, group);
        group.getMembers().add(user.getId());
        user.getGroups().add((String)((Object)group.getId()));
    }

    public CompanyOrg create(CompanyOrg company) {
        this.cache.create(company);
        this.getCompany().findAll().put((String)((Object)company.getId()), company);
        return company;
    }

    public GroupOrg create(GroupOrg group) {
        this.cache.create(group, Collections.emptyMap());
        this.getGroup().findAll().put((String)((Object)group.getId()), group);
        return group;
    }

    public UserOrg create(UserOrg user) {
        this.cache.create(user);
        this.getUser().findAll().put(user.getId(), user);
        return user;
    }

    public void delete(CompanyOrg company) {
        Map companiesNameToDn = this.getCompany().findAll();
        this.cache.delete(company);
        companiesNameToDn.remove(company.getId());
    }

    public void delete(GroupOrg group) {
        Map groupsNameToDn = this.getGroup().findAll();
        this.deleteMemoryAssociations(group, this.getUser().findAll());
        this.cache.delete(group);
        groupsNameToDn.remove(group.getId());
    }

    public void delete(UserOrg user) {
        Map users = this.getUser().findAll();
        this.cache.delete(user);
        users.remove(Normalizer.normalize((String)user.getId()));
    }

    private void deleteMemoryAssociations(GroupOrg group, Map<String, UserOrg> users) {
        for (String member : group.getMembers()) {
            users.get(member).getGroups().remove(group.getId());
        }
        group.getMembers().clear();
    }

    public void empty(GroupOrg group, Map<String, UserOrg> users) {
        this.deleteMemoryAssociations(group, users);
        this.cache.empty(group);
    }

    protected ICompanyRepository getCompany() {
        return this.iamProvider[0].getConfiguration().getCompanyRepository();
    }

    public abstract Map<CacheDataType, Map<String, ? extends ResourceOrg>> getData();

    protected IGroupRepository getGroup() {
        return this.iamProvider[0].getConfiguration().getGroupRepository();
    }

    protected IUserRepository getUser() {
        return this.iamProvider[0].getConfiguration().getUserRepository();
    }

    protected Map<CacheDataType, Map<String, ? extends ResourceOrg>> refreshData() {
        EnumMap<CacheDataType, Map<String, ? extends ResourceOrg>> result = new EnumMap<CacheDataType, Map<String, ? extends ResourceOrg>>(CacheDataType.class);
        log.info("Fetching origin identity data ...");
        Map groups = this.getGroup().findAllNoCache();
        result.put(CacheDataType.COMPANY, this.getCompany().findAllNoCache());
        result.put(CacheDataType.GROUP, groups);
        result.put(CacheDataType.USER, this.getUser().findAllNoCache(groups));
        this.data = result;
        return result;
    }

    public void removeGroupFromGroup(GroupOrg subGroup, GroupOrg group) {
        if (group != null) {
            this.cache.removeGroupFromGroup(subGroup, group);
            group.getSubGroups().remove(subGroup.getId());
        }
        subGroup.setParent(null);
    }

    public void removeUserFromGroup(UserOrg user, GroupOrg group) {
        this.cache.removeUserFromGroup(user, group);
        user.getGroups().remove(group.getId());
        group.getMembers().remove(user.getId());
    }

    public void update(UserOrg user) {
        this.cache.update(user);
    }

    @Generated
    public void setCache(IdCacheDao cache) {
        this.cache = cache;
    }

    @Generated
    public void setIamProvider(IamProvider[] iamProvider) {
        this.iamProvider = iamProvider;
    }

    public static enum CacheDataType {
        GROUP,
        COMPANY,
        USER;

    }
}

