/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.id.resource;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.app.api.Normalizer;
import org.ligoj.app.iam.CompanyOrg;
import org.ligoj.app.iam.GroupOrg;
import org.ligoj.app.iam.IGroupRepository;
import org.ligoj.app.iam.IUserRepository;
import org.ligoj.app.iam.SimpleUser;
import org.ligoj.app.iam.UserOrg;
import org.ligoj.app.iam.dao.CacheGroupRepository;
import org.ligoj.app.iam.model.CacheGroup;
import org.ligoj.app.model.ContainerType;
import org.ligoj.app.plugin.id.DnUtils;
import org.ligoj.app.plugin.id.model.ContainerScope;
import org.ligoj.app.plugin.id.resource.AbstractContainerResource;
import org.ligoj.app.plugin.id.resource.CompanyResource;
import org.ligoj.app.plugin.id.resource.ContainerCountVo;
import org.ligoj.app.plugin.id.resource.GroupEditionVo;
import org.ligoj.bootstrap.core.json.TableItem;
import org.ligoj.bootstrap.core.json.datatable.DataTableAttributes;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Path(value="/service/id/group")
@Service
@Produces(value={"application/json"})
@Transactional
public class GroupResource
extends AbstractContainerResource<GroupOrg, GroupEditionVo, CacheGroup> {
    public static final String GROUP_ATTRIBUTE = "group";
    @Autowired
    private CompanyResource organizationResource;
    @Autowired
    private CacheGroupRepository cacheGroupRepository;

    public GroupResource() {
        super(ContainerType.GROUP);
    }

    public IGroupRepository getRepository() {
        return this.getGroupRepository();
    }

    public CacheGroupRepository getCacheRepository() {
        return this.cacheGroupRepository;
    }

    @GET
    public TableItem<ContainerCountVo> findAll(@Context UriInfo uriInfo) {
        List<ContainerScope> types = this.containerScopeResource.findAllDescOrder(ContainerType.GROUP);
        Map companies = this.getCompanyRepository().findAll();
        Set visibleCompanies = this.organizationResource.getContainers();
        Set<String> writeGroups = this.getContainersIdForWrite();
        Set<String> adminGroups = this.getContainersIdForAdmin();
        Map users = this.getUserRepository().findAll();
        Map groups = this.getGroupRepository().findAll();
        Page page = this.getContainers(DataTableAttributes.getSearch((UriInfo)uriInfo), (Pageable)this.paginationJson.getPageRequest(uriInfo, ORDERED_COLUMNS));
        return this.paginationJson.applyPagination(uriInfo, page, rawGroup -> {
            ContainerCountVo securedGroup = new ContainerCountVo();
            this.fillContainerCountVo(rawGroup, writeGroups, adminGroups, types, securedGroup, groups);
            securedGroup.setCount(rawGroup.getMembers().size());
            securedGroup.setCountVisible((int)rawGroup.getMembers().stream().map(users::get).map(SimpleUser::getCompany).map(companies::get).map(CompanyOrg::getCompanyTree).filter(c -> CollectionUtils.containsAny((Collection)visibleCompanies, (Collection)c)).count());
            return securedGroup;
        });
    }

    @GET
    @Path(value="{group}/exists")
    public boolean exists(@PathParam(value="group") String group) {
        return this.findById(group) != null;
    }

    @Override
    protected String toDn(GroupEditionVo container, ContainerScope scope) {
        String parentDn = scope.getDn();
        container.setParent(StringUtils.trimToNull((String)Normalizer.normalize((String)container.getParent())));
        if (container.getParent() != null) {
            GroupOrg parent = (GroupOrg)this.findByIdExpected(container.getParent());
            if (!DnUtils.equalsOrParentOf(scope.getDn(), parent.getDn())) {
                throw new ValidationJsonException("parent", (Serializable)((Object)"container-parent-type-match"), new Serializable[]{"type", this.type, "provided", scope.getType()});
            }
            parentDn = parent.getDn();
        }
        return "cn=" + container.getName() + "," + parentDn;
    }

    private List<String> toDn(List<String> uids) {
        return CollectionUtils.emptyIfNull(uids).stream().map(arg_0 -> ((IUserRepository)this.getUserRepository()).findByIdExpected(arg_0)).map(UserOrg::getDn).toList();
    }

    @POST
    @Path(value="empty/{id}")
    public void empty(@PathParam(value="id") String id) {
        GroupOrg container = (GroupOrg)this.findByIdExpected(id);
        if (!this.getContainersForWrite().contains(container)) {
            throw new ValidationJsonException(this.getTypeName(), (Serializable)((Object)"unknown-id"), new Serializable[]{"0", this.getTypeName(), "1", id});
        }
        this.getRepository().empty(container, this.getUserRepository().findAll());
    }

    @Override
    protected GroupOrg create(GroupEditionVo container, ContainerScope type, String newDn) {
        List<String> assistants = this.toDn(container.getAssistants());
        List<String> owners = this.toDn(container.getOwners());
        GroupOrg group = (GroupOrg)super.create(container, type, newDn);
        if (container.getParent() != null) {
            this.getRepository().addGroup(group, Normalizer.normalize((String)container.getParent()));
        }
        this.getRepository().addAttributes(newDn, "seeAlso", assistants);
        this.getRepository().addAttributes(newDn, "owner", owners);
        this.getRepository().addAttributes(newDn, "businessCategory", CollectionUtils.emptyIfNull(container.getDepartments()));
        return group;
    }
}

