/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.id.resource;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.text.WordUtils;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.ligoj.app.api.Normalizer;
import org.ligoj.app.iam.CompanyOrg;
import org.ligoj.app.iam.GroupOrg;
import org.ligoj.app.iam.IGroupRepository;
import org.ligoj.app.iam.IPasswordGenerator;
import org.ligoj.app.iam.IUserRepository;
import org.ligoj.app.iam.SimpleUser;
import org.ligoj.app.iam.SimpleUserOrg;
import org.ligoj.app.iam.UserOrg;
import org.ligoj.app.iam.UserUpdateResult;
import org.ligoj.app.iam.dao.DelegateOrgRepository;
import org.ligoj.app.iam.model.DelegateOrg;
import org.ligoj.app.iam.model.DelegateType;
import org.ligoj.app.plugin.id.DnUtils;
import org.ligoj.app.plugin.id.dao.PasswordResetAuditRepository;
import org.ligoj.app.plugin.id.model.PasswordResetAudit;
import org.ligoj.app.plugin.id.resource.AbstractOrgResource;
import org.ligoj.app.plugin.id.resource.CompanyResource;
import org.ligoj.app.plugin.id.resource.GroupResource;
import org.ligoj.app.plugin.id.resource.GroupVo;
import org.ligoj.app.plugin.id.resource.UserOrgEditionVo;
import org.ligoj.app.plugin.id.resource.UserOrgVo;
import org.ligoj.bootstrap.core.NamedBean;
import org.ligoj.bootstrap.core.json.PaginationJson;
import org.ligoj.bootstrap.core.json.TableItem;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.ligoj.bootstrap.resource.system.configuration.ConfigurationResource;
import org.ligoj.bootstrap.resource.system.session.ISessionSettingsProvider;
import org.ligoj.bootstrap.resource.system.session.SessionSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.ResponseBody;

@Path(value="/service/id/user")
@Service
@Produces(value={"application/json"})
@Transactional
public class UserOrgResource
extends AbstractOrgResource
implements ISessionSettingsProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserOrgResource.class);
    private static final String READ_ONLY = "read-only";
    private static final String GROUP = "group";
    public static final String USER_KEY = "id";
    @Autowired
    private DelegateOrgRepository delegateRepository;
    @Autowired
    private ConfigurationResource configuration;
    @Autowired
    private PasswordResetAuditRepository passwordResetRepository;
    @Autowired
    private PaginationJson paginationJson;
    @Autowired
    protected CompanyResource companyResource;
    @Autowired
    protected GroupResource groupResource;
    @Autowired
    protected ApplicationContext applicationContext;
    private static final Map<String, String> ORDERED_COLUMNS = new HashMap<String, String>();

    public List<UserOrg> findAllNotSecure(String company, String group) {
        Set<GroupOrg> visibleGroups = this.groupResource.getContainers();
        MessageImpl message = new MessageImpl();
        message.put(Message.QUERY_STRING, (Object)"length=10000000");
        return this.findAllNotSecure(visibleGroups, company, group, null, (UriInfo)new UriInfoImpl((Message)message)).getContent();
    }

    private Page<UserOrg> findAllNotSecure(Set<GroupOrg> visibleGroups, String company, String group, String criteria, @Context UriInfo uriInfo) {
        PageRequest pageRequest = this.paginationJson.getPageRequest(uriInfo, ORDERED_COLUMNS);
        Set<String> visibleCompanies = this.companyResource.getContainers().stream().map(NamedBean::getId).collect(Collectors.toSet());
        Map allGroups = this.getGroupRepository().findAll();
        Set<String> filteredCompanies = this.computeFilteredCompanies(Normalizer.normalize((String)company), visibleCompanies);
        List<GroupOrg> filteredGroups = group == null ? null : this.computeFilteredGroups(group, visibleGroups, allGroups);
        return this.getUserRepository().findAll(filteredGroups, filteredCompanies, StringUtils.trimToNull((String)criteria), (Pageable)pageRequest);
    }

    @GET
    public TableItem<UserOrgVo> findAll(@QueryParam(value="company") String company, @QueryParam(value="group") String group, @QueryParam(value="search[value]") String criteria, @Context UriInfo uriInfo) {
        Set<GroupOrg> visibleGroups = this.groupResource.getContainers();
        Set writableGroups = this.groupResource.getContainersForWrite();
        Set writableCompanies = this.companyResource.getContainersForWrite();
        Set writableCompaniesIds = writableCompanies.stream().map(NamedBean::getId).collect(Collectors.toSet());
        Page<UserOrg> findAll = this.findAllNotSecure(visibleGroups, company, group, criteria, uriInfo);
        TableItem result = this.paginationJson.applyPagination(uriInfo, findAll, rawUserOrg -> {
            UserOrgVo securedUserOrg = new UserOrgVo();
            rawUserOrg.copy((SimpleUserOrg)securedUserOrg);
            securedUserOrg.setCanWrite(writableCompaniesIds.contains(rawUserOrg.getCompany()));
            securedUserOrg.setCanWriteGroups(!writableGroups.isEmpty());
            securedUserOrg.setGroups(visibleGroups.stream().filter(mGroup -> rawUserOrg.getGroups().contains(mGroup.getId())).map(mGroup -> {
                GroupVo vo = new GroupVo();
                vo.setCanWrite(writableGroups.contains(mGroup));
                vo.setName(mGroup.getName());
                return vo;
            }).toList());
            return securedUserOrg;
        });
        result.setExtensions(Map.of("customAttributes", this.getUserRepository().getCustomAttributes()));
        return result;
    }

    private Set<String> computeFilteredCompanies(String requestedCompany, Collection<String> visibleCompanies) {
        Set<String> filteredCompanies = StringUtils.isBlank((CharSequence)requestedCompany) ? new HashSet<String>(visibleCompanies) : (visibleCompanies.contains(requestedCompany) ? Collections.singleton(requestedCompany) : Collections.emptySet());
        return filteredCompanies;
    }

    private List<GroupOrg> computeFilteredGroups(String group, Set<GroupOrg> visibleGroups, Map<String, GroupOrg> allGroups) {
        return Optional.ofNullable(allGroups.get(Normalizer.normalize((String)group))).map(fg -> allGroups.values().stream().filter(visibleGroups::contains).filter(g -> DnUtils.equalsOrParentOf(fg.getDn(), g.getDn())).toList()).orElse(Collections.emptyList());
    }

    @GET
    @Path(value="{user:[a-z0-9](?:-?[\\-a-z\\.@_0-9]){1,100}}")
    public UserOrg findById(@PathParam(value="user") String user) {
        UserOrg rawUserOrg = this.getUserRepository().findByIdExpected(this.securityHelper.getLogin(), Normalizer.normalize((String)user));
        this.getUserRepository().checkLockStatus(rawUserOrg);
        UserOrg securedUserOrg = new UserOrg();
        rawUserOrg.copy((SimpleUserOrg)securedUserOrg);
        Set visibleGroups = this.groupResource.getContainers();
        securedUserOrg.setGroups(visibleGroups.stream().filter(mGroup -> rawUserOrg.getGroups().contains(mGroup.getId())).sorted().map(NamedBean::getName).toList());
        return securedUserOrg;
    }

    @PUT
    @Path(value="{user}/group/{group}")
    public void addUserToGroup(@PathParam(value="user") String user, @PathParam(value="group") String group) {
        this.updateGroupUser(user, Normalizer.normalize((String)group), Collection::add);
    }

    @DELETE
    @Path(value="{user}/group/{group}")
    public void removeUserFromGroup(@PathParam(value="user") String user, @PathParam(value="group") String group) {
        this.updateGroupUser(user, Normalizer.normalize((String)group), Collection::remove);
    }

    private void updateGroupUser(String user, String group, BiPredicate<Collection<String>, String> updater) {
        List delegates = this.delegateRepository.findAllByUser(this.securityHelper.getLogin());
        UserOrg userOrg = this.getUserRepository().findByIdExpected(user);
        if (this.getGroupRepository().findById(this.securityHelper.getLogin(), group) == null) {
            throw new ValidationJsonException(GROUP, (Serializable)((Object)"not-exist"), new Serializable[]{"0", GROUP, "1", group});
        }
        this.validateWriteGroup(group, delegates);
        HashSet<String> newGroups = new HashSet<String>(userOrg.getGroups());
        if (updater.test(newGroups, group)) {
            Collection<String> mergedGroups = this.mergeGroups(delegates, userOrg, newGroups);
            this.getUserRepository().updateMembership(new ArrayList<String>(mergedGroups), userOrg);
        }
    }

    @PUT
    public UserUpdateResult update(UserOrgEditionVo user) {
        boolean hasAttributeChange = this.validateChanges(this.securityHelper.getLogin(), user);
        this.getUserRepository().findByIdExpected(user.getId());
        return this.saveOrUpdate(user, hasAttributeChange);
    }

    public String create(UserOrgEditionVo user, boolean quiet) {
        this.validateChanges(this.securityHelper.getLogin(), user);
        if (this.getUserRepository().findById(user.getId()) != null) {
            throw new ValidationJsonException(USER_KEY, (Serializable)((Object)"already-exist"), new Serializable[]{"0", USER_KEY, "1", user.getId()});
        }
        this.saveOrUpdate(user, quiet, true);
        return user.getGeneratedPassword();
    }

    @POST
    public String create(UserOrgEditionVo user) {
        return this.create(user, false);
    }

    private boolean validateChanges(String principal, UserOrgEditionVo importEntry) {
        this.normalize(importEntry);
        List delegates = this.delegateRepository.findAllByUser(principal);
        UserOrg userOrg = this.getUserRepository().findById(importEntry.getId());
        String cleanCompany = Normalizer.normalize((String)importEntry.getCompany());
        String companyDn = ((CompanyOrg)this.getCompanyRepository().findByIdExpected(principal, cleanCompany)).getDn();
        boolean hasAttributeChange = this.hasAttributeChange(importEntry, userOrg);
        if (hasAttributeChange && !this.canWrite(delegates, companyDn, DelegateType.COMPANY)) {
            log.info("Attempt to create/update a read-only user '{}', company '{}'", (Object)importEntry.getId(), (Object)cleanCompany);
            throw new ValidationJsonException("company", (Serializable)((Object)READ_ONLY), new Serializable[]{"0", "company", "1", importEntry.getCompany()});
        }
        importEntry.setCompany(cleanCompany);
        this.validateAndGroupsCN(userOrg, importEntry, (List<DelegateOrg>)delegates);
        if (userOrg != null) {
            if (!userOrg.getCompany().equals(importEntry.getCompany())) {
                this.checkDeletionRight(importEntry.getId(), "move");
            }
            importEntry.setGroups(new ArrayList<String>(this.mergeGroups(delegates, userOrg, importEntry.getGroups())));
        }
        return hasAttributeChange;
    }

    private void validateAndGroupsCN(UserOrg userOrg, UserOrgEditionVo importEntry, List<DelegateOrg> delegates) {
        String previous = Optional.ofNullable(userOrg).map(SimpleUser::getDepartment).orElse(null);
        if (ObjectUtils.notEqual((Object)previous, (Object)importEntry.getDepartment())) {
            Optional.ofNullable(this.toDepartmentGroup(previous)).map(NamedBean::getId).ifPresent(importEntry.getGroups()::remove);
            Optional.ofNullable(this.toDepartmentGroup(importEntry.getDepartment())).map(NamedBean::getId).ifPresent(importEntry.getGroups()::add);
        }
        this.validateAndGroupsCN(Optional.ofNullable(userOrg).map(UserOrg::getGroups).orElse(Collections.emptyList()), importEntry.getGroups(), delegates);
    }

    private void validateAndGroupsCN(Collection<String> previousGroups, Collection<String> desiredGroups, List<DelegateOrg> delegates) {
        IGroupRepository repository = this.getGroupRepository();
        desiredGroups.forEach(g -> repository.findByIdExpected(this.securityHelper.getLogin(), g));
        CollectionUtils.disjunction(desiredGroups, previousGroups).forEach(g -> this.validateWriteGroup((String)g, delegates));
    }

    private void validateWriteGroup(String updatedGroup, List<DelegateOrg> delegates) {
        Optional.ofNullable((GroupOrg)this.getGroupRepository().findById(this.securityHelper.getLogin(), updatedGroup)).filter(g -> !this.canWrite(delegates, g.getDn(), DelegateType.GROUP)).ifPresent(g -> {
            throw new ValidationJsonException(GROUP, (Serializable)((Object)READ_ONLY), new Serializable[]{"0", GROUP, "1", g.getId()});
        });
    }

    private Collection<String> mergeGroups(List<DelegateOrg> delegates, UserOrg userOrg, Collection<String> groups) {
        HashSet<String> newGroups = new HashSet<String>(userOrg.getGroups());
        newGroups.addAll(groups);
        IGroupRepository repository = this.getGroupRepository();
        for (String oldGroup : userOrg.getGroups()) {
            String oldGroupDn = ((GroupOrg)repository.findById(oldGroup)).getDn();
            if (groups.contains(oldGroup) || !this.canWrite(delegates, oldGroupDn, DelegateType.GROUP)) continue;
            newGroups.remove(oldGroup);
        }
        return newGroups;
    }

    private void normalize(UserOrgEditionVo importEntry) {
        importEntry.setCompany(Normalizer.normalize((String)importEntry.getCompany()));
        importEntry.setId(StringUtils.trimToNull((String)Normalizer.normalize((String)importEntry.getId())));
        importEntry.setGroups(new ArrayList<String>(Normalizer.normalize(importEntry.getGroups())));
        importEntry.setDepartment(StringUtils.trimToNull((String)importEntry.getDepartment()));
        importEntry.setLocalId(StringUtils.trimToNull((String)importEntry.getLocalId()));
        importEntry.setLastName(WordUtils.capitalizeFully((String)StringUtils.trimToNull((String)importEntry.getLastName())));
        importEntry.setFirstName(WordUtils.capitalizeFully((String)StringUtils.trimToNull((String)importEntry.getFirstName())));
    }

    private boolean canWrite(List<DelegateOrg> delegates, String dn, DelegateType type) {
        return this.resource.isAdmin(this.securityHelper.getLogin()) || delegates.stream().anyMatch(delegate -> this.canWrite((DelegateOrg)delegate, dn, type));
    }

    protected boolean canWrite(DelegateOrg delegate, String dn, DelegateType type) {
        return (delegate.getType() == type || delegate.getType() == DelegateType.TREE) && delegate.isCanWrite() && DnUtils.equalsOrParentOf(delegate.getDn(), dn);
    }

    String mapToString(Map<String, String> map) {
        if (map == null) {
            return "";
        }
        return map.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Object::toString).collect(Collectors.joining());
    }

    boolean hasAttributeChange(UserOrgEditionVo importEntry, UserOrg userOrg) {
        return this.hasAttributeChange((SimpleUser)importEntry, userOrg == null, "new") || this.hasAttributeChange((SimpleUser)importEntry, (SimpleUser)userOrg, SimpleUser::getFirstName, SimpleUser::getLastName, SimpleUser::getCompany, SimpleUser::getLocalId, SimpleUser::getDepartment) || this.hasAttributeChange((SimpleUser)importEntry, !this.mapToString(importEntry.getCustomAttributes()).equals(this.mapToString(userOrg.getCustomAttributes())), "customAttributes") || this.hasAttributeChange((SimpleUser)importEntry, !userOrg.getMails().contains(importEntry.getMail()), "mail");
    }

    private boolean hasAttributeChange(SimpleUser importEntry, boolean hasChange, String source) {
        if (hasChange) {
            log.info("At least one change required for user {}, source: {}", (Object)importEntry.getId(), (Object)source);
        }
        return hasChange;
    }

    @SafeVarargs
    private boolean hasAttributeChange(SimpleUser user1, SimpleUser user2, Function<SimpleUser, String> ... equals) {
        Function predicateFalse = Arrays.stream(equals).filter(f -> !Strings.CI.equals(StringUtils.trimToNull((String)((String)f.apply(user2))), StringUtils.trimToNull((String)((String)f.apply(user1))))).findFirst().orElse(null);
        return predicateFalse != null && this.hasAttributeChange(user1, true, String.format("'%s' != '%s'", predicateFalse.apply(user1), predicateFalse.apply(user2)));
    }

    private UserUpdateResult saveOrUpdate(UserOrgEditionVo importEntry, boolean quiet, boolean hasAttributeChange) {
        IUserRepository repository = this.getUserRepository();
        UserOrg user = repository.findById(importEntry.getId());
        UserOrg newUser = this.toUserOrg(importEntry);
        if (user == null) {
            log.info("{} will be created", (Object)newUser.getId());
            user = repository.create(newUser);
            String generatedPassword = this.updatePassword(newUser, quiet);
            if (importEntry.isReturnGeneratePassword()) {
                importEntry.setGeneratedPassword(generatedPassword);
            }
        } else if (hasAttributeChange) {
            this.updateUser(user, newUser, quiet);
        }
        return repository.updateMembership(importEntry.getGroups(), user);
    }

    public UserUpdateResult saveOrUpdate(UserOrgEditionVo importEntry, boolean hasAttributeChange) {
        return this.saveOrUpdate(importEntry, false, hasAttributeChange);
    }

    private void updateUser(UserOrg oldUser, UserOrg newUser, boolean quiet) {
        log.info("{} already exists", (Object)newUser.getId());
        newUser.setDn(this.getUserRepository().toDn(newUser));
        this.updateCompanyAsNeeded(oldUser, newUser);
        boolean hadNoMail = oldUser.getMails().isEmpty();
        this.getUserRepository().updateUser(newUser);
        if (newUser.getMails().isEmpty()) {
            log.info("{} already exists, but has no mail", (Object)newUser.getId());
        } else if (hadNoMail) {
            log.info("{} already exists, but a mail has been created", (Object)newUser.getId());
            this.updatePassword(newUser, quiet);
        } else if (!oldUser.isSecured()) {
            log.info("{} had no password, a mail will be sent", (Object)newUser.getId());
            this.updatePassword(newUser, quiet);
        }
    }

    private UserOrg toUserOrg(UserOrgEditionVo importEntry) {
        UserOrg user = new UserOrg();
        importEntry.copy((SimpleUser)user);
        user.setGroups(new ArrayList());
        ArrayList mails = new ArrayList();
        CollectionUtils.addIgnoreNull(mails, (Object)importEntry.getMail());
        user.setMails(mails);
        return user;
    }

    @DELETE
    @Path(value="{user}")
    public void delete(@PathParam(value="user") String user) {
        UserOrg userOrg = this.checkDeletionRight(user, "delete");
        Map allGroups = this.getGroupRepository().findAll();
        this.checkLastMemberInGroups(userOrg, allGroups);
        IUserRepository repository = this.getUserRepository();
        repository.updateMembership(new ArrayList(), userOrg);
        repository.delete(userOrg);
    }

    @DELETE
    @Path(value="{user}/lock")
    public void lock(@PathParam(value="user") String user) {
        this.getUserRepository().lock(this.securityHelper.getLogin(), this.checkDeletionRight(user, "lock"));
    }

    @DELETE
    @Path(value="{user}/isolate")
    public void isolate(@PathParam(value="user") String user) {
        this.getUserRepository().isolate(this.securityHelper.getLogin(), this.checkDeletionRight(user, "isolate"));
    }

    @PUT
    @Path(value="{user}/unlock")
    public void unlock(@PathParam(value="user") String user) {
        this.getUserRepository().unlock(this.checkDeletionRight(user, "unlock"));
    }

    @PUT
    @Path(value="{user}/restore")
    public void restore(@PathParam(value="user") String user) {
        this.getUserRepository().restore(this.checkDeletionRight(user, "restore"));
    }

    @PUT
    @Path(value="{user}/reset")
    @ResponseBody
    @Produces(value={"text/plain"})
    public String resetPassword(@PathParam(value="user") String uid) {
        if (uid.equals(this.securityHelper.getLogin())) {
            UserOrg user = this.getUserRepository().findByIdExpected(uid);
            return this.updatePassword(user, false);
        }
        UserOrg user = this.checkResetRight(uid);
        return Optional.ofNullable(this.updatePassword(user, false)).map(p -> {
            this.getUserRepository().unlock(user);
            this.logAdminReset(user);
            return p;
        }).orElse(null);
    }

    private void logAdminReset(UserOrg user) {
        PasswordResetAudit logReset = new PasswordResetAudit();
        logReset.setLogin(user.getId());
        this.passwordResetRepository.saveAndFlush((Object)logReset);
    }

    private UserOrg checkResetRight(String user) {
        UserOrg userOrg = this.getUserRepository().findByIdExpected(this.securityHelper.getLogin(), Normalizer.normalize((String)user));
        String companyDn = ((CompanyOrg)this.getCompanyRepository().findById(userOrg.getCompany())).getDn();
        if (this.delegateRepository.findByMatchingDnForWrite(this.securityHelper.getLogin(), companyDn, DelegateType.TREE).isEmpty()) {
            log.warn("Attempt to reset the password of a user '{}' out of scope", (Object)user);
            throw new ValidationJsonException(USER_KEY, (Serializable)((Object)READ_ONLY), new Serializable[]{"0", "user", "1", user});
        }
        return userOrg;
    }

    private UserOrg checkDeletionRight(String user, String mode) {
        UserOrg userOrg = this.getUserRepository().findByIdExpected(this.securityHelper.getLogin(), Normalizer.normalize((String)user));
        String companyDn = ((CompanyOrg)this.getCompanyRepository().findById(userOrg.getCompany())).getDn();
        if (this.delegateRepository.findByMatchingDnForWrite(this.securityHelper.getLogin(), companyDn, DelegateType.COMPANY).isEmpty()) {
            log.warn("Attempt to {} a user '{}' out of scope", (Object)mode, (Object)user);
            throw new ValidationJsonException(USER_KEY, (Serializable)((Object)READ_ONLY), new Serializable[]{"0", "user", "1", user});
        }
        return userOrg;
    }

    private void checkLastMemberInGroups(UserOrg userOrg, Map<String, GroupOrg> allGroups) {
        for (String group : userOrg.getGroups()) {
            if (allGroups.get(group).getMembers().size() != 1) continue;
            throw new ValidationJsonException(USER_KEY, (Serializable)((Object)"last-member-of-group"), new Serializable[]{"user", userOrg.getId(), GROUP, group});
        }
    }

    protected String updatePassword(UserOrg user, boolean quiet) {
        return this.applicationContext.getBeansOfType(IPasswordGenerator.class).values().stream().findFirst().map(p -> {
            String password = p.generate(user.getId(), quiet);
            user.setSecured(true);
            return password;
        }).orElse(null);
    }

    public List<UserOrg> findAllBy(String attribute, String value) {
        return this.getUserRepository().findAllBy(attribute, value);
    }

    public UserOrg findByIdNoCache(String user) {
        return this.getUserRepository().findByIdNoCache(Normalizer.normalize((String)user));
    }

    private void updateCompanyAsNeeded(UserOrg userOrg, UserOrg newUser) {
        if (ObjectUtils.notEqual((Object)userOrg.getCompany(), (Object)newUser.getCompany())) {
            this.getUserRepository().move(userOrg, (CompanyOrg)this.getCompanyRepository().findById(newUser.getCompany()));
        }
    }

    private GroupOrg toDepartmentGroup(String department) {
        return Optional.ofNullable(department).map(arg_0 -> ((IGroupRepository)this.getGroupRepository()).findByDepartment(arg_0)).orElse(null);
    }

    public void mergeUser(UserOrg userOrg, UserOrg newUser) {
        boolean needUpdate = false;
        if (ObjectUtils.notEqual((Object)userOrg.getDepartment(), (Object)newUser.getDepartment())) {
            Optional.ofNullable(this.toDepartmentGroup(userOrg.getDepartment())).ifPresent(g -> this.getGroupRepository().removeUser(userOrg, (String)((Object)g.getId())));
            Optional.ofNullable(this.toDepartmentGroup(newUser.getDepartment())).ifPresent(g -> this.getGroupRepository().addUser(userOrg, (String)((Object)g.getId())));
            userOrg.setDepartment(newUser.getDepartment());
            needUpdate = true;
        }
        if (ObjectUtils.notEqual((Object)userOrg.getLocalId(), (Object)newUser.getLocalId())) {
            userOrg.setLocalId(newUser.getLocalId());
        }
        if (needUpdate) {
            this.getUserRepository().updateUser(userOrg);
        }
    }

    public void decorate(SessionSettings settings) {
        try {
            settings.getUserSettings().put("userDetails", this.findById(settings.getUserName()));
        }
        catch (ValidationJsonException ve) {
            log.debug("User being authenticated is not defined in primary identity provider ");
        }
        settings.getApplicationSettings().getData().computeIfAbsent("service:id:user-display", arg_0 -> ((ConfigurationResource)this.configuration).get(arg_0));
    }

    public Collection<GrantedAuthority> getGrantedAuthorities(String username) {
        try {
            UserOrg rawUserOrg = this.getUserRepository().toUser(Normalizer.normalize((String)username));
            ArrayList<GrantedAuthority> roles = new ArrayList<GrantedAuthority>();
            for (String group : CollectionUtils.emptyIfNull((Collection)rawUserOrg.getGroups())) {
                roles.add((GrantedAuthority)new SimpleGrantedAuthority(group.toUpperCase()));
                roles.add((GrantedAuthority)new SimpleGrantedAuthority(group.toLowerCase()));
                roles.add((GrantedAuthority)new SimpleGrantedAuthority(group));
            }
            return roles;
        }
        catch (ValidationJsonException ve) {
            log.debug("User being authenticated '{}' is not defined in primary identity provider ", (Object)username);
            return Collections.emptyList();
        }
    }

    static {
        ORDERED_COLUMNS.put(USER_KEY, USER_KEY);
        ORDERED_COLUMNS.put("firstName", "firstName");
        ORDERED_COLUMNS.put("lastName", "lastName");
        ORDERED_COLUMNS.put("mails", "mail");
        ORDERED_COLUMNS.put("company", "company");
    }
}

