/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.id.resource.batch;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.app.plugin.id.resource.batch.AbstractBatchTask;
import org.ligoj.app.plugin.id.resource.batch.BatchElement;
import org.ligoj.app.plugin.id.resource.batch.BatchTaskVo;
import org.ligoj.app.plugin.id.resource.batch.ImportStatus;
import org.ligoj.bootstrap.core.SpringUtils;
import org.ligoj.bootstrap.core.csv.CsvForBean;
import org.ligoj.bootstrap.core.resource.OnNullReturn404;
import org.ligoj.bootstrap.core.resource.TechnicalException;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.ligoj.bootstrap.core.validation.ValidatorBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class AbstractBatchResource<B extends BatchElement> {
    @Autowired
    protected TaskExecutor executor;
    @Autowired
    private CsvForBean csvForBean;
    private final Map<String, BatchTaskVo<B>> imports = new ConcurrentHashMap<String, BatchTaskVo<B>>();
    @Autowired
    private ValidatorBean validator;

    @GET
    @Path(value="{id:\\d+}")
    @OnNullReturn404
    public BatchTaskVo<B> getImportTask(@PathParam(value="id") long id) {
        return this.imports.get(SecurityContextHolder.getContext().getAuthentication().getName() + "-" + id);
    }

    @GET
    @Path(value="{id:\\d+}/status")
    @OnNullReturn404
    public ImportStatus getImportStatus(@PathParam(value="id") long id) {
        return Optional.ofNullable(this.getImportTask(id)).map(BatchTaskVo::getStatus).orElse(null);
    }

    private void cleanup() {
        for (Map.Entry<String, BatchTaskVo<B>> entry : this.imports.entrySet()) {
            if (!this.isFinished(entry.getValue())) continue;
            this.imports.remove(entry.getKey());
        }
    }

    private boolean isFinished(BatchTaskVo<?> task) {
        return task.getStatus().getEnd() != null && task.getStatus().getEnd().getTime() + 86400000L < System.currentTimeMillis();
    }

    protected <T extends AbstractBatchTask<B>> long batch(InputStream uploadedFile, String[] columns, String encoding, String[] defaultColumns, Class<B> batchType, Class<T> taskType, Boolean quiet) throws IOException {
        try {
            return this.batchInternal(uploadedFile, columns, encoding, defaultColumns, batchType, taskType, quiet);
        }
        catch (TechnicalException io) {
            throw new ValidationJsonException("csv-file", (Serializable)((Object)io.getMessage()), new Serializable[0]);
        }
    }

    protected <T extends AbstractBatchTask<B>> long batchInternal(InputStream uploadedFile, String[] columns, String encoding, String[] defaultColumns, Class<B> batchType, Class<T> taskType, Boolean quiet) throws IOException {
        long id = System.currentTimeMillis();
        String[] sanitizeColumns = ArrayUtils.isEmpty((Object[])columns) ? defaultColumns : columns;
        this.checkHeaders(defaultColumns, sanitizeColumns);
        String csvHeaders = StringUtils.chop((String)ArrayUtils.toString((Object)sanitizeColumns)).substring(1).replace(',', ';') + "\n";
        String encSafe = (String)ObjectUtils.getIfNull((Object)encoding, (Object)StandardCharsets.UTF_8.name());
        ByteArrayInputStream input = new ByteArrayInputStream(csvHeaders.getBytes(encSafe));
        List entries = this.csvForBean.toBean(batchType, (Reader)new InputStreamReader((InputStream)new SequenceInputStream(input, uploadedFile), encSafe));
        entries.removeIf(Objects::isNull);
        this.validator.validateCheck((Collection)entries, new Class[0]);
        BatchTaskVo importTask = new BatchTaskVo();
        importTask.setEntries(entries);
        importTask.setPrincipal(SecurityContextHolder.getContext().getAuthentication().getName());
        importTask.setId(id);
        importTask.setQuiet(BooleanUtils.isTrue((Boolean)quiet));
        AbstractBatchTask task = (AbstractBatchTask)SpringUtils.getBean(taskType);
        task.configure(importTask);
        this.executor.execute((Runnable)task);
        this.cleanup();
        this.imports.put(importTask.getPrincipal() + "-" + importTask.getId(), importTask);
        return id;
    }

    private void checkHeaders(String[] requested, String ... columns) {
        for (String column : columns) {
            if (ArrayUtils.contains((Object[])requested, (Object)column.trim())) continue;
            throw new ValidationJsonException("csv-file", (Serializable)((Object)("Invalid header " + column)), new Serializable[0]);
        }
    }
}

