/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.id.resource.batch;

import jakarta.ws.rs.ext.ExceptionMapper;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.ligoj.app.api.Normalizer;
import org.ligoj.app.plugin.id.resource.batch.BatchElement;
import org.ligoj.app.plugin.id.resource.batch.BatchTaskVo;
import org.ligoj.bootstrap.core.security.SecurityHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractBatchTask<B extends BatchElement>
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractBatchTask.class);
    @Autowired
    protected SecurityHelper securityHelper;
    protected ServerProviderFactory jaxrsFactory;
    protected BatchTaskVo<B> task;

    @Override
    public void run() {
        log.info("Executing {}", (Object)this.task.toString());
        this.securityHelper.setUserName(this.task.getPrincipal());
        this.doBatch();
        this.task.getStatus().setStatus(Boolean.TRUE);
        this.task.getStatus().setEnd(new Date());
    }

    protected abstract void doBatch(B var1, boolean var2) throws Exception;

    protected void doBatch(B entry) throws Exception {
        this.doBatch(entry, false);
    }

    private void doBatch() {
        for (BatchElement importEntry : this.task.getEntries()) {
            importEntry.setStatus(null);
            importEntry.setStatusText(null);
            try {
                this.doBatch(importEntry, this.task.isQuiet());
                importEntry.setStatus(Boolean.TRUE);
                log.info("Import of {} succeed", (Object)importEntry);
            }
            catch (Exception ne) {
                log.info("Import of {} failed : {}", (Object)importEntry, (Object)ne.getMessage());
                importEntry.setStatus(Boolean.FALSE);
                ExceptionMapper mapper = this.jaxrsFactory.createExceptionMapper(ne.getClass(), null);
                importEntry.setStatusText(mapper == null ? ne.getMessage() : mapper.toResponse((Throwable)ne).getEntity().toString());
            }
            this.task.getStatus().setDone(this.task.getStatus().getDone() + 1);
        }
    }

    public void configure(BatchTaskVo<B> task) {
        this.task = task;
        this.task.getStatus().setStart(new Date());
        this.task.getStatus().setEntries(task.getEntries().size());
        this.jaxrsFactory = this.getMessage() == null ? ServerProviderFactory.getInstance() : (ServerProviderFactory)this.getMessage().getExchange().getEndpoint().get((Object)"org.apache.cxf.jaxrs.provider.ServerProviderFactory");
    }

    protected Message getMessage() {
        return PhaseInterceptorChain.getCurrentMessage();
    }

    protected List<String> toList(String rawValue) {
        return Pattern.compile(",").splitAsStream(StringUtils.trimToEmpty((String)rawValue)).map(Normalizer::normalize).filter(StringUtils::isNotBlank).toList();
    }
}

