/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.id.resource.batch;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.app.iam.UserOrg;
import org.ligoj.app.iam.dao.DelegateOrgRepository;
import org.ligoj.app.plugin.id.resource.UserOrgEditionVo;
import org.ligoj.app.plugin.id.resource.UserOrgResource;
import org.ligoj.app.plugin.id.resource.batch.AbstractBatchTask;
import org.ligoj.app.plugin.id.resource.batch.UserBatchUpdateType;
import org.ligoj.app.plugin.id.resource.batch.UserUpdateEntry;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class UserAtomicTask
extends AbstractBatchTask<UserUpdateEntry> {
    @Autowired
    protected UserOrgResource resource;
    @Autowired
    protected DelegateOrgRepository repository;
    private static final Map<String, UserBatchUpdateType> UPDATE_ACTION_TYPES = new HashMap<String, UserBatchUpdateType>();
    private static final Map<String, BiConsumer<UserAtomicTask, UserUpdateEntry>> FUNCTIONS;

    @Override
    protected void doBatch(UserUpdateEntry entry, boolean quiet) {
        UserBatchUpdateType type = UPDATE_ACTION_TYPES.get(entry.getOperation());
        if (type == null) {
            throw new ValidationJsonException("operation", (Serializable)((Object)"unsupported-operation"), new Serializable[0]);
        }
        if (type != UserBatchUpdateType.ATTRIBUTE && StringUtils.isNotBlank((CharSequence)entry.getValue())) {
            throw new ValidationJsonException("value", (Serializable)((Object)"null-value-expected"), new Serializable[0]);
        }
        if (type == UserBatchUpdateType.ATTRIBUTE) {
            UserOrg user = this.resource.findById(entry.getUser());
            UserOrgEditionVo editUser = new UserOrgEditionVo();
            editUser.setId(user.getId());
            editUser.setFirstName(user.getFirstName());
            editUser.setLastName(user.getLastName());
            editUser.setCompany(user.getCompany());
            editUser.setLastName(user.getLastName());
            editUser.setMail(user.getMails().stream().findFirst().orElse(null));
            editUser.setDepartment(user.getDepartment());
            editUser.setLocalId(user.getLocalId());
            editUser.setGroups(user.getGroups());
            entry.setUserEdit(editUser);
            FUNCTIONS.get(entry.getOperation()).accept(this, entry);
            this.resource.update(entry.getUserEdit());
        } else {
            FUNCTIONS.get(entry.getOperation()).accept(this, entry);
        }
    }

    static {
        UPDATE_ACTION_TYPES.put("firstname", UserBatchUpdateType.ATTRIBUTE);
        UPDATE_ACTION_TYPES.put("lastname", UserBatchUpdateType.ATTRIBUTE);
        UPDATE_ACTION_TYPES.put("department", UserBatchUpdateType.ATTRIBUTE);
        UPDATE_ACTION_TYPES.put("localid", UserBatchUpdateType.ATTRIBUTE);
        UPDATE_ACTION_TYPES.put("company", UserBatchUpdateType.ATTRIBUTE);
        UPDATE_ACTION_TYPES.put("mail", UserBatchUpdateType.ATTRIBUTE);
        UPDATE_ACTION_TYPES.put("isolate", UserBatchUpdateType.ISOLATE);
        UPDATE_ACTION_TYPES.put("restore", UserBatchUpdateType.RESTORE);
        UPDATE_ACTION_TYPES.put("lock", UserBatchUpdateType.LOCK);
        UPDATE_ACTION_TYPES.put("delete", UserBatchUpdateType.DELETE);
        FUNCTIONS = new HashMap<String, BiConsumer<UserAtomicTask, UserUpdateEntry>>();
        FUNCTIONS.put("firstname", (u, e) -> e.getUserEdit().setFirstName(e.getValue()));
        FUNCTIONS.put("lastname", (u, e) -> e.getUserEdit().setLastName(e.getValue()));
        FUNCTIONS.put("department", (u, e) -> e.getUserEdit().setDepartment(e.getValue()));
        FUNCTIONS.put("localid", (u, e) -> e.getUserEdit().setLocalId(e.getValue()));
        FUNCTIONS.put("company", (u, e) -> e.getUserEdit().setCompany(e.getValue()));
        FUNCTIONS.put("mail", (u, e) -> e.getUserEdit().setMail(e.getValue()));
        FUNCTIONS.put("isolate", (u, e) -> u.resource.isolate(e.getUser()));
        FUNCTIONS.put("restore", (u, e) -> u.resource.restore(e.getUser()));
        FUNCTIONS.put("lock", (u, e) -> u.resource.lock(e.getUser()));
        FUNCTIONS.put("delete", (u, e) -> u.resource.delete(e.getUser()));
    }
}

