/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.id;

import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.app.api.Normalizer;

public final class DnUtils {
    private DnUtils() {
    }

    public static String toRdn(@NotNull String dn) {
        return Normalizer.normalize((String)StringUtils.split((String)dn, (String)"=,")[1]);
    }

    public static String toParentRdn(@NotNull String dn) {
        return Normalizer.normalize((String)StringUtils.split((String)dn, (String)"=,")[3]);
    }

    public static boolean equalsOrParentOf(@NotNull String parentDn, String childDn) {
        return childDn != null && (childDn.endsWith("," + parentDn) || childDn.equals(parentDn));
    }

    public static boolean equalsOrParentOf(@NotNull Collection<String> parentDns, String childDn) {
        for (String dn : parentDns) {
            if (!DnUtils.equalsOrParentOf(dn, childDn)) continue;
            return true;
        }
        return false;
    }
}

