/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.id.resource;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.ligoj.app.api.Normalizer;
import org.ligoj.app.iam.ContainerOrg;
import org.ligoj.app.iam.IContainerRepository;
import org.ligoj.app.iam.dao.CacheContainerRepository;
import org.ligoj.app.iam.dao.DelegateOrgRepository;
import org.ligoj.app.iam.model.CacheContainer;
import org.ligoj.app.model.ContainerType;
import org.ligoj.app.plugin.id.DnUtils;
import org.ligoj.app.plugin.id.model.ContainerScope;
import org.ligoj.app.plugin.id.resource.AbstractOrgResource;
import org.ligoj.app.plugin.id.resource.ContainerCountVo;
import org.ligoj.app.plugin.id.resource.ContainerEditionVo;
import org.ligoj.app.plugin.id.resource.ContainerScopeResource;
import org.ligoj.app.plugin.id.resource.ContainerWithScopeVo;
import org.ligoj.bootstrap.core.INamableBean;
import org.ligoj.bootstrap.core.NamedBean;
import org.ligoj.bootstrap.core.json.PaginationJson;
import org.ligoj.bootstrap.core.json.TableItem;
import org.ligoj.bootstrap.core.json.datatable.DataTableAttributes;
import org.ligoj.bootstrap.core.model.AbstractBusinessEntity;
import org.ligoj.bootstrap.core.model.AbstractNamedBusinessEntity;
import org.ligoj.bootstrap.core.resource.OnNullReturn404;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public abstract class AbstractContainerResource<T extends ContainerOrg, V extends ContainerEditionVo, C extends CacheContainer>
extends AbstractOrgResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractContainerResource.class);
    protected static final String TYPE_ATTRIBUTE = "type";
    protected static final Map<String, String> ORDERED_COLUMNS = new HashMap<String, String>();
    @Autowired
    protected ContainerScopeResource containerScopeResource;
    @Autowired
    protected PaginationJson paginationJson;
    @Autowired
    protected DelegateOrgRepository delegateRepository;
    protected final ContainerType type;

    protected AbstractContainerResource(ContainerType type) {
        this.type = type;
    }

    protected void checkForDeletion(ContainerOrg container) {
        if (!this.delegateRepository.canCreate(this.securityHelper.getLogin(), Normalizer.normalize((String)container.getDn()), this.type.getDelegateType())) {
            log.warn("Attempt to delete a {} '{}' out of scope", (Object)this.type, (Object)container.getName());
            throw new ValidationJsonException(this.getTypeName(), (Serializable)((Object)"unknown-id"), new Serializable[]{"0", this.getTypeName(), "1", container.getId()});
        }
        if (container.isLocked()) {
            throw new ValidationJsonException("company", (Serializable)((Object)"locked"), new Serializable[]{"0", container.getName()});
        }
    }

    @POST
    public String create(V container) {
        return (String)((Object)this.createInternal(container).getId());
    }

    protected T create(V container, ContainerScope type, String newDn) {
        log.info("Creating a {}@{}-{} '{}'", new Object[]{this.type, type.getName(), type.getId(), ((ContainerEditionVo)container).getName()});
        return (T)this.getRepository().create(newDn, ((ContainerEditionVo)container).getName());
    }

    public T createInternal(V container) {
        ContainerScope scope = this.containerScopeResource.findById(((ContainerEditionVo)container).getScope());
        if (this.type != scope.getType()) {
            throw new ValidationJsonException(TYPE_ATTRIBUTE, (Serializable)((Object)"container-scope-match"), new Serializable[]{TYPE_ATTRIBUTE, this.type, "provided", scope.getType()});
        }
        String newDn = this.toDn(container, scope);
        if (!this.delegateRepository.canCreate(this.securityHelper.getLogin(), Normalizer.normalize((String)newDn), this.type.getDelegateType())) {
            log.warn("Attempt to create a {} '{}' out of scope", (Object)scope, (Object)((ContainerEditionVo)container).getName());
            throw new ValidationJsonException("name", (Serializable)((Object)"read-only"), new Serializable[]{"0", this.getTypeName(), "1", ((ContainerEditionVo)container).getName()});
        }
        if (this.getRepository().findById(Normalizer.normalize((String)((ContainerEditionVo)container).getName())) != null) {
            throw new ValidationJsonException("name", (Serializable)((Object)"already-exist"), new Serializable[]{"0", this.getTypeName(), "1", ((ContainerEditionVo)container).getName()});
        }
        return this.create(container, scope, newDn);
    }

    @DELETE
    @Path(value="{id}")
    public void delete(@PathParam(value="id") String id) {
        T container = this.findByIdExpected(id);
        this.checkForDeletion((ContainerOrg)container);
        this.getRepository().delete(container);
    }

    public T findById(String id) {
        return (T)this.getRepository().findById(this.securityHelper.getLogin(), id);
    }

    public T findByIdExpected(String id) {
        return (T)this.getRepository().findByIdExpected(this.securityHelper.getLogin(), id);
    }

    @GET
    @Path(value="{container:[a-zA-Z0-9]([\\-: ]?[a-zA-Z0-9])+}")
    @OnNullReturn404
    public ContainerWithScopeVo findByName(@PathParam(value="container") String name) {
        return Optional.ofNullable(this.findById(name)).map(this::toVo).orElse(null);
    }

    protected abstract CacheContainerRepository<C> getCacheRepository();

    public Set<T> getContainers() {
        return this.toInternal(this.getCacheRepository().findAll(this.securityHelper.getLogin()));
    }

    public Page<T> getContainers(String criteria, Pageable pageRequest) {
        return this.toInternal(this.getCacheRepository().findAll(this.securityHelper.getLogin(), criteria, pageRequest));
    }

    @GET
    @Path(value="filter/read")
    public TableItem<String> getContainers(@Context UriInfo uriInfo) {
        return this.paginationJson.applyPagination(uriInfo, this.getCacheRepository().findAll(this.securityHelper.getLogin(), DataTableAttributes.getSearch((UriInfo)uriInfo), (Pageable)this.paginationJson.getPageRequest(uriInfo, ORDERED_COLUMNS)), AbstractNamedBusinessEntity::getName);
    }

    protected Set<T> getContainersForAdmin() {
        return this.toInternal(this.getCacheRepository().findAllAdmin(this.securityHelper.getLogin()));
    }

    public Set<String> getContainersIdForAdmin() {
        return this.getContainersIdForX(arg_0 -> this.getCacheRepository().findAllAdmin(arg_0));
    }

    private Set<String> getContainersIdForX(Function<String, List<C>> dataProvider) {
        Map all = this.getRepository().findAll();
        return dataProvider.apply(this.securityHelper.getLogin()).stream().map(AbstractBusinessEntity::getId).filter(all::containsKey).collect(Collectors.toSet());
    }

    @GET
    @Path(value="filter/admin")
    public TableItem<String> getContainersForAdmin(@Context UriInfo uriInfo) {
        return this.paginationJson.applyPagination(uriInfo, this.getCacheRepository().findAllAdmin(this.securityHelper.getLogin(), DataTableAttributes.getSearch((UriInfo)uriInfo), (Pageable)this.paginationJson.getPageRequest(uriInfo, ORDERED_COLUMNS)), AbstractNamedBusinessEntity::getName);
    }

    public Set<T> getContainersForWrite() {
        return this.toInternal(this.getCacheRepository().findAllWrite(this.securityHelper.getLogin()));
    }

    public Set<String> getContainersIdForWrite() {
        return this.getContainersIdForX(arg_0 -> this.getCacheRepository().findAllWrite(arg_0));
    }

    @GET
    @Path(value="filter/write")
    public TableItem<String> getContainersForWrite(@Context UriInfo uriInfo) {
        return this.paginationJson.applyPagination(uriInfo, this.getCacheRepository().findAllWrite(this.securityHelper.getLogin(), DataTableAttributes.getSearch((UriInfo)uriInfo), (Pageable)this.paginationJson.getPageRequest(uriInfo, ORDERED_COLUMNS)), AbstractNamedBusinessEntity::getName);
    }

    protected abstract IContainerRepository<T> getRepository();

    protected String getTypeName() {
        return this.getRepository().getTypeName();
    }

    protected void fillContainerCountVo(T rawContainer, Set<String> canWrite, Set<String> canAdmin, List<ContainerScope> types, ContainerCountVo securedContainer, Map<String, T> all) {
        NamedBean.copy(rawContainer, (INamableBean)securedContainer);
        securedContainer.setCanWrite(canWrite.contains(rawContainer.getId()));
        securedContainer.setCanAdmin(canAdmin.contains(rawContainer.getId()));
        securedContainer.setContainerType(this.type);
        ContainerScope scope = this.toScope(types, (ContainerOrg)rawContainer);
        if (scope != null) {
            securedContainer.setScope(scope.getName());
            securedContainer.setLocked(scope.isLocked());
        }
        securedContainer.setLocked(securedContainer.isLocked() || rawContainer.isLocked());
        String parent = rawContainer.getParent();
        if (parent != null) {
            securedContainer.setParents(new ArrayList<String>());
            this.fillParents(securedContainer.getParents(), rawContainer, all);
        }
    }

    private void fillParents(List<String> target, T currentGroup, Map<String, T> all) {
        if (currentGroup.getParent() != null) {
            target.add(currentGroup.getParent());
            this.fillParents(target, (ContainerOrg)all.get(currentGroup.getParent()), all);
        }
    }

    protected abstract String toDn(V var1, ContainerScope var2);

    protected Set<T> toInternal(Collection<C> cacheItems) {
        Map all = this.getRepository().findAll();
        return cacheItems.stream().map(AbstractBusinessEntity::getId).map(all::get).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected Page<T> toInternal(Page<C> cacheItems) {
        return new PageImpl(new ArrayList<T>(this.toInternal(cacheItems.getContent())), cacheItems.getPageable(), cacheItems.getTotalElements());
    }

    public ContainerScope toScope(List<ContainerScope> scopes, ContainerOrg container) {
        return scopes.stream().filter(s -> DnUtils.equalsOrParentOf(s.getDn(), container.getDn())).findFirst().orElse(null);
    }

    protected ContainerWithScopeVo toVo(T rawGroup) {
        ContainerWithScopeVo securedUserOrg = new ContainerWithScopeVo();
        List<ContainerScope> scopes = this.containerScopeResource.findAllDescOrder(this.type);
        ContainerScope scope = this.toScope(scopes, (ContainerOrg)rawGroup);
        NamedBean.copy(rawGroup, (INamableBean)securedUserOrg);
        if (scope != null) {
            securedUserOrg.setScope(scope.getName());
        }
        return securedUserOrg;
    }

    static {
        ORDERED_COLUMNS.put("name", "name");
    }

    public class TypeComparator
    implements Comparator<T> {
        private List<ContainerScope> types;

        @Override
        public int compare(T container1, T container2) {
            ContainerScope type2;
            ContainerScope type1 = AbstractContainerResource.this.toScope(this.types, (ContainerOrg)container1);
            int result = Objects.equals((Object)type1, (Object)(type2 = AbstractContainerResource.this.toScope(this.types, (ContainerOrg)container2))) ? 0 : (type1 == null ? 1 : (type2 == null ? -1 : type1.getName().compareToIgnoreCase(type2.getName())));
            if (result == 0) {
                return container1.getName().compareToIgnoreCase(container2.getName());
            }
            return result;
        }

        @Generated
        public TypeComparator(List<ContainerScope> types) {
            this.types = types;
        }
    }
}

