/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.id.resource;

import jakarta.ws.rs.NotAuthorizedException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheResult;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.app.api.Normalizer;
import org.ligoj.app.iam.IUserRepository;
import org.ligoj.app.iam.IamConfiguration;
import org.ligoj.app.iam.IamConfigurationProvider;
import org.ligoj.app.iam.SimpleUser;
import org.ligoj.app.iam.UserOrg;
import org.ligoj.app.plugin.id.resource.IdentityServicePlugin;
import org.ligoj.app.plugin.id.resource.UserOrgEditionVo;
import org.ligoj.app.plugin.id.resource.UserOrgResource;
import org.ligoj.app.resource.plugin.AbstractToolPluginResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

public abstract class AbstractPluginIdResource<U extends IUserRepository>
extends AbstractToolPluginResource
implements IdentityServicePlugin,
IamConfigurationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractPluginIdResource.class);
    private static final Object USER_LOCK = new Object();
    private static final Object NODE_CONFIGURATION_LOCK = new Object();
    private static final String DEFAULT_ID = "id";
    private final Map<String, IamConfiguration> nodeConfigurations = new HashMap<String, IamConfiguration>();
    @Autowired
    protected UserOrgResource userResource;

    protected abstract AbstractPluginIdResource<U> getSelf();

    @Override
    public Authentication authenticate(Authentication authentication, String node, boolean primary) {
        IUserRepository repository = this.getSelf().getConfiguration(node).getUserRepository();
        UserOrg user = repository.authenticate(authentication.getName(), (String)authentication.getCredentials());
        if (user != null) {
            if (primary) {
                if (user.getId().equals(authentication.getName())) {
                    return authentication;
                }
                return new UsernamePasswordAuthenticationToken((Object)user.getId(), null);
            }
            return new UsernamePasswordAuthenticationToken((Object)this.toApplicationUser(repository, authentication), null);
        }
        throw new BadCredentialsException("");
    }

    protected String toApplicationUser(U repository, Authentication authentication) {
        UserOrg account = repository.findOneBy(this.getAuthenticateProperty(repository, authentication), authentication.getName());
        if (CollectionUtils.isEmpty((Collection)account.getMails())) {
            log.info("Account '{} [{} {}]' has no mail", new Object[]{account.getId(), account.getFirstName(), account.getLastName()});
            throw new NotAuthorizedException((Object)"ambiguous-account-no-mail", new Object[0]);
        }
        return this.toApplicationUser(account);
    }

    protected String getAuthenticateProperty(U repository, Authentication authentication) {
        return DEFAULT_ID;
    }

    protected String toApplicationUser(UserOrg account) {
        List<UserOrg> usersByMail = this.userResource.findAllBy("mails", (String)account.getMails().getFirst());
        if (usersByMail.isEmpty()) {
            return this.newApplicationUser(account);
        }
        if (usersByMail.size() == 1) {
            this.userResource.mergeUser(usersByMail.getFirst(), account);
            return usersByMail.getFirst().getId();
        }
        log.info("Account '{} [{} {}]' has too many mails ({}), expected one", new Object[]{account.getId(), account.getFirstName(), account.getLastName(), usersByMail.size()});
        throw new NotAuthorizedException((Object)"ambiguous-account-too-many-mails", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String newApplicationUser(UserOrg account) {
        Object object = USER_LOCK;
        synchronized (object) {
            UserOrgEditionVo userEdition = new UserOrgEditionVo();
            account.copy((SimpleUser)userEdition);
            userEdition.setGroups(Collections.emptyList());
            userEdition.setMail((String)account.getMails().getFirst());
            userEdition.setName(this.nextFreeLogin(this.toLogin(account)));
            this.userResource.saveOrUpdate(userEdition, true);
            return userEdition.getId();
        }
    }

    protected String nextFreeLogin(String login) {
        String nextLogin;
        UserOrg user;
        int suffix = 0;
        do {
            nextLogin = login + String.valueOf(suffix == 0 ? "" : Integer.valueOf(suffix));
            user = this.userResource.findByIdNoCache(nextLogin);
            ++suffix;
        } while (user != null);
        return nextLogin;
    }

    protected String toLogin(UserOrg account) {
        String trimFirstName = this.normalize(account.getFirstName());
        String trimLastName = this.normalize(account.getLastName());
        if (trimFirstName.length() * trimLastName.length() == 0) {
            throw new NotAuthorizedException((Object)"cannot-build-application-login", new Object[0]);
        }
        return trimFirstName.charAt(0) + trimLastName;
    }

    private String normalize(String string) {
        return StringUtils.trimToEmpty((String)Normalizer.normalize((String)string).replace("[^\\w\\d]", " ").replace("  ", " "));
    }

    public IamConfiguration getConfiguration(String node) {
        this.getSelf().ensureCachedConfiguration(node);
        return this.nodeConfigurations.computeIfAbsent(node, this::refreshConfiguration);
    }

    @CacheResult(cacheName="id-configuration")
    public boolean ensureCachedConfiguration(@CacheKey String node) {
        this.refreshConfiguration(node);
        return true;
    }

    protected abstract U getUserRepository(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IamConfiguration refreshConfiguration(String node) {
        Object object = NODE_CONFIGURATION_LOCK;
        synchronized (object) {
            return this.nodeConfigurations.compute(node, (n, m) -> {
                IamConfiguration iam = new IamConfiguration();
                U repository = this.getUserRepository(node);
                iam.setNode(node);
                iam.setUserRepository(repository);
                this.copyConfiguration(iam, repository);
                return iam;
            });
        }
    }

    protected void copyConfiguration(IamConfiguration iam, U repository) {
        iam.setCompanyRepository(repository.getCompanyRepository());
        iam.setGroupRepository(repository.getGroupRepository());
    }
}

