/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.id.resource;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.ligoj.app.iam.CompanyOrg;
import org.ligoj.app.iam.ContainerOrg;
import org.ligoj.app.iam.ICompanyRepository;
import org.ligoj.app.iam.SimpleUser;
import org.ligoj.app.iam.UserOrg;
import org.ligoj.app.iam.dao.CacheCompanyRepository;
import org.ligoj.app.iam.model.CacheCompany;
import org.ligoj.app.model.ContainerType;
import org.ligoj.app.plugin.id.DnUtils;
import org.ligoj.app.plugin.id.model.ContainerScope;
import org.ligoj.app.plugin.id.resource.AbstractContainerResource;
import org.ligoj.app.plugin.id.resource.ContainerCountVo;
import org.ligoj.app.plugin.id.resource.ContainerEditionVo;
import org.ligoj.bootstrap.core.NamedBean;
import org.ligoj.bootstrap.core.json.TableItem;
import org.ligoj.bootstrap.core.json.datatable.DataTableAttributes;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Path(value="/service/id/company")
@Service
@Produces(value={"application/json"})
@Transactional
public class CompanyResource
extends AbstractContainerResource<CompanyOrg, ContainerEditionVo, CacheCompany> {
    @Autowired
    private CacheCompanyRepository cacheCompanyRepository;

    protected CompanyResource() {
        super(ContainerType.COMPANY);
    }

    public CacheCompanyRepository getCacheRepository() {
        return this.cacheCompanyRepository;
    }

    public ICompanyRepository getRepository() {
        return this.getCompanyRepository();
    }

    public CompanyOrg getUserCompany() {
        UserOrg user = this.getUserRepository().findById(this.securityHelper.getLogin());
        if (user == null) {
            return null;
        }
        return (CompanyOrg)this.getRepository().findById((String)ObjectUtils.getIfNull((Object)user.getCompany(), (Object)""));
    }

    private String getUserCompanyDn() {
        CompanyOrg company = this.getUserCompany();
        if (company == null) {
            return null;
        }
        return company.getDn();
    }

    public boolean isUserInternalCompany() {
        return ((String)ObjectUtils.getIfNull((Object)this.getUserCompanyDn(), (Object)"")).endsWith((String)ObjectUtils.getIfNull((Object)this.getUserRepository().getPeopleInternalBaseDn(), (Object)""));
    }

    @GET
    public TableItem<ContainerCountVo> findAll(@Context UriInfo uriInfo) {
        PageRequest pageRequest = this.paginationJson.getPageRequest(uriInfo, ORDERED_COLUMNS);
        List<ContainerScope> types = this.containerScopeResource.findAllDescOrder(ContainerType.COMPANY);
        Set visibleCompanies = this.getContainers();
        Set visibleCompaniesAsString = visibleCompanies.stream().map(NamedBean::getId).collect(Collectors.toSet());
        Set<String> writeCompanies = this.getContainersIdForWrite();
        Set<String> adminCompanies = this.getContainersIdForAdmin();
        Map users = this.getUserRepository().findAll();
        Map companies = this.getCompanyRepository().findAll();
        Page findAll = this.getRepository().findAll(visibleCompanies, DataTableAttributes.getSearch((UriInfo)uriInfo), (Pageable)pageRequest, Collections.singletonMap("type", new AbstractContainerResource.TypeComparator(types)));
        return this.paginationJson.applyPagination(uriInfo, findAll, rawCompany -> {
            ContainerCountVo securedCompany = new ContainerCountVo();
            this.fillContainerCountVo(rawCompany, writeCompanies, adminCompanies, types, securedCompany, companies);
            securedCompany.setCount((int)users.values().stream().filter(user -> ((String)((Object)rawCompany.getId())).equals(user.getCompany())).count());
            securedCompany.setCountVisible((int)users.values().stream().filter(user -> ((String)((Object)rawCompany.getId())).equals(user.getCompany())).filter(user -> visibleCompaniesAsString.contains(user.getCompany())).count());
            return securedCompany;
        });
    }

    @Override
    protected void checkForDeletion(ContainerOrg container) {
        super.checkForDeletion(container);
        Map users = this.getUserRepository().findAll();
        if (this.getRepository().findAll().values().stream().filter(c -> DnUtils.equalsOrParentOf(container.getDn(), c.getDn())).anyMatch(c -> users.values().stream().map(SimpleUser::getCompany).anyMatch(((String)((Object)c.getId()))::equals))) {
            throw new ValidationJsonException(this.getTypeName(), (Serializable)((Object)"not-empty-company"), new Serializable[]{"0", this.getTypeName(), "1", container.getId()});
        }
    }

    @Override
    protected String toDn(ContainerEditionVo container, ContainerScope scope) {
        return "ou=" + container.getName() + "," + scope.getDn();
    }
}

