/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.id.resource.batch;

import org.apache.commons.lang3.StringUtils;
import org.ligoj.app.model.ContainerType;
import org.ligoj.app.plugin.id.resource.ContainerScopeResource;
import org.ligoj.app.plugin.id.resource.GroupEditionVo;
import org.ligoj.app.plugin.id.resource.GroupResource;
import org.ligoj.app.plugin.id.resource.batch.AbstractBatchTask;
import org.ligoj.app.plugin.id.resource.batch.GroupImportEntry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class GroupFullTask
extends AbstractBatchTask<GroupImportEntry> {
    @Autowired
    protected GroupResource resource;
    @Autowired
    protected ContainerScopeResource containerScopeResource;

    @Override
    protected void doBatch(GroupImportEntry entry, boolean quiet) {
        GroupEditionVo edition = new GroupEditionVo();
        edition.setName(entry.getName());
        edition.setParent(StringUtils.trimToNull((String)entry.getParent()));
        edition.setScope((Integer)this.containerScopeResource.findByName(ContainerType.GROUP, entry.getScope()).getId());
        edition.setAssistants(this.toList(entry.getAssistant()));
        edition.setDepartments(this.toList(entry.getDepartment()));
        edition.setOwners(this.toList(entry.getOwner()));
        this.resource.create(edition);
    }
}

