/*
 * Decompiled with CFR 0.152.
 */
package net.jnellis.binpack;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.jnellis.binpack.Bin;
import net.jnellis.binpack.packing.BestFit;
import net.jnellis.binpack.packing.PackingPolicy;
import net.jnellis.binpack.preorder.Ascending;
import net.jnellis.binpack.preorder.Descending;
import net.jnellis.binpack.preorder.PreOrderPolicy;

public abstract class BinPacker<P extends Comparable<P>, C extends Comparable<C>, B extends Bin<P, C>> {
    private PreOrderPolicy<P> preOrderPolicy = new Descending<P>();
    private PackingPolicy<P, C, B> packingPolicy = new BestFit();
    private PreOrderPolicy<B> existingBinPreOrderPolicy = new Descending<B>();
    private PreOrderPolicy<C> availableCapacitiesPreOrderPolicy = new Ascending<C>();

    public PackingPolicy<P, C, B> getPackingPolicy() {
        return this.packingPolicy;
    }

    public BinPacker<P, C, B> setPackingPolicy(PackingPolicy<P, C, B> policy) {
        Objects.requireNonNull(policy, "PackingPolicy can't be null.");
        this.packingPolicy = policy;
        return this;
    }

    public PreOrderPolicy<B> getExistingBinPreOrderPolicy() {
        return this.existingBinPreOrderPolicy;
    }

    public BinPacker<P, C, B> setExistingBinPreOrderPolicy(PreOrderPolicy<B> preOrderPolicy) {
        Objects.requireNonNull(preOrderPolicy, "PreOrderPolicy can't be null.");
        this.existingBinPreOrderPolicy = preOrderPolicy;
        return this;
    }

    public PreOrderPolicy<C> getAvailableCapacitiesPreOrderPolicy() {
        return this.availableCapacitiesPreOrderPolicy;
    }

    public BinPacker<P, C, B> setAvailableCapacitiesPreOrderPolicy(PreOrderPolicy<C> preOrderPolicy) {
        Objects.requireNonNull(preOrderPolicy, "PreOrderPolicy can't be null.");
        this.availableCapacitiesPreOrderPolicy = preOrderPolicy;
        return this;
    }

    public PreOrderPolicy<P> getPreOrderPolicy() {
        return this.preOrderPolicy;
    }

    public BinPacker<P, C, B> setPreOrderPolicy(PreOrderPolicy<P> policy) {
        Objects.requireNonNull(policy, "PreOrderPolicy can't be null.");
        this.preOrderPolicy = policy;
        return this;
    }

    public List<B> packAll(List<P> pieces, List<B> existingBins, List<C> availableCapacities) {
        this.getPreOrderPolicy().order(pieces).forEach(this.getPackFunction(this.existingBinPreOrderPolicy.order(existingBins), this.availableCapacitiesPreOrderPolicy.order(availableCapacities)));
        return existingBins;
    }

    private Consumer<P> getPackFunction(List<B> bins, List<C> capacities) {
        return piece -> this.pack(piece, bins, capacities);
    }

    public List<B> pack(P piece, List<B> existingBins, List<C> availableCapacities) {
        Supplier<Bin> newBin = () -> this.addNewBin(piece, existingBins, availableCapacities);
        this.packingPolicy.chooseBin(piece, existingBins).orElseGet(newBin).add(piece);
        return existingBins;
    }

    protected abstract B addNewBin(P var1, List<B> var2, List<C> var3);
}

