/*
 * Decompiled with CFR 0.152.
 */
package net.jnellis.binpack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.jnellis.binpack.Bin;
import net.jnellis.binpack.CapacitySupport;

public class LinearBin
implements Bin<Double, Double> {
    private final List<Double> pieces = new ArrayList<Double>();
    private final List<Double> capacities;
    private final double maxCapacity;
    private final boolean existing;
    private double total = 0.0;

    public LinearBin(List<Double> capacities) {
        this.capacities = new ArrayList<Double>((Collection)Objects.requireNonNull(capacities));
        if (this.capacities.isEmpty()) {
            throw CapacitySupport.mustBeAtLeastOneCapacityException();
        }
        this.existing = false;
        this.maxCapacity = Collections.max(this.capacities);
    }

    public LinearBin(Double capacity) {
        this.capacities = Collections.singletonList(capacity);
        this.existing = true;
        this.maxCapacity = capacity;
    }

    public static Supplier<LinearBin> newBinSupplier(List<Double> capacities) {
        return () -> new LinearBin(capacities);
    }

    @Override
    public boolean add(Double piece) {
        if (piece < 0.0) {
            throw new AssertionError((Object)("Negative value pieces not allowed: " + piece));
        }
        if (this.canFit(piece)) {
            this.pieces.add(piece);
            this.total += piece.doubleValue();
            return true;
        }
        return false;
    }

    @Override
    public boolean canFit(Double piece) {
        return this.capacities.stream().anyMatch(capacity -> capacity >= this.total + piece);
    }

    @Override
    public final boolean isExisting() {
        return this.existing;
    }

    @Override
    public final List<Double> getPieces() {
        return Collections.unmodifiableList(this.pieces);
    }

    @Override
    public final Double getTotal() {
        return this.total;
    }

    @Override
    public final List<Double> getCapacities() {
        return Collections.unmodifiableList(this.capacities);
    }

    @Override
    public Double getMaxRemainingCapacity() {
        return this.maxCapacity - this.total;
    }

    @Override
    public Double getSmallestCapacityNeeded() {
        Optional<Double> min = this.capacities.stream().filter(capacity -> capacity >= this.total).min(Comparator.comparing(capacity -> capacity - this.total));
        return min.orElseThrow(CapacitySupport::mustBeAtLeastOneCapacityException);
    }

    public boolean isMoreThanHalfMaxCapacity(Double piece) {
        return this.maxCapacity / 2.0 < piece;
    }

    public String toString() {
        return "LinearBin{pieces=" + this.pieces + ", capacities=" + this.capacities + ", total=" + this.total + ", existing=" + this.existing + '}';
    }
}

