/*
 * Decompiled with CFR 0.152.
 */
package net.jnellis.binpack.collectors;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.jnellis.binpack.Bin;
import net.jnellis.binpack.collectors.BinPackCollector;

public class BestFitPackingCollector<P extends Comparable<P>, C extends Comparable<C>, B extends Bin<P, C>>
implements BinPackCollector<P, C, B, NavigableMap<C, ArrayDeque<B>>> {
    private final Supplier<B> newBinSupplier;
    private final Function<P, C> pieceAsCapacity;

    public BestFitPackingCollector(Supplier<B> newBinSupplier, Function<P, C> pieceAsCapacity) {
        this.newBinSupplier = newBinSupplier;
        this.pieceAsCapacity = pieceAsCapacity;
    }

    public static <P extends Comparable<P>, C extends Comparable<C>, B extends Bin<P, C> & Comparable<Bin<P, C>>> Collector<P, ?, Collection<B>> bestFitPacking(Supplier<B> newBinSupplier, Function<P, C> pieceAsCapacityFunction) {
        return new BestFitPackingCollector<P, C, B>(newBinSupplier, pieceAsCapacityFunction);
    }

    @Override
    public Supplier<NavigableMap<C, ArrayDeque<B>>> supplier() {
        return TreeMap::new;
    }

    @Override
    public BiConsumer<NavigableMap<C, ArrayDeque<B>>, P> accumulator() {
        return this::binpackTree2;
    }

    private void binpackTree2(NavigableMap<C, ArrayDeque<B>> binTree, P piece) {
        C key = this.pieceAsCapacity(piece);
        Map.Entry<C, ArrayDeque<B>> entry = binTree.ceilingEntry(key);
        if (entry == null) {
            this.addNewEntry(binTree, piece);
        } else {
            this.addToExistingList(binTree, entry, piece);
        }
    }

    private void addNewEntry(NavigableMap<C, ArrayDeque<B>> binTree, P piece) {
        Bin bin = (Bin)this.newBin().get();
        bin.add(piece);
        ArrayDeque<Bin> bList = new ArrayDeque<Bin>();
        bList.add(bin);
        binTree.put(bin.getMaxRemainingCapacity(), bList);
    }

    private void addToExistingList(NavigableMap<C, ArrayDeque<B>> binTree, Map.Entry<C, ArrayDeque<B>> entry, P piece) {
        ArrayDeque<B> bList = entry.getValue();
        assert (bList != null && !bList.isEmpty());
        Bin bin = (Bin)bList.poll();
        assert (bin != null);
        if (bList.isEmpty()) {
            binTree.remove(entry.getKey());
        }
        assert (bin.canFit(piece));
        bin.add(piece);
        Object newKey = bin.getMaxRemainingCapacity();
        binTree.computeIfAbsent(newKey, donotcare -> new ArrayDeque()).add(bin);
    }

    @Override
    public Supplier<B> newBin() {
        return this.newBinSupplier;
    }

    @Override
    public C pieceAsCapacity(P piece) {
        return (C)((Comparable)this.pieceAsCapacity.apply(piece));
    }

    @Override
    public BinaryOperator<NavigableMap<C, ArrayDeque<B>>> combiner() {
        return (bins, bins2) -> {
            bins.putAll(bins2);
            return bins;
        };
    }

    @Override
    public Function<NavigableMap<C, ArrayDeque<B>>, Collection<B>> finisher() {
        return binTree -> binTree.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

