/*
 * Decompiled with CFR 0.152.
 */
package net.jnellis.binpack.packing;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.jnellis.binpack.Bin;

@FunctionalInterface
public interface PackingPolicy<P extends Comparable<P>, C extends Comparable<C>, B extends Bin<P, C>> {
    public static <B> Stream<B> reverseStream(List<B> bins) {
        int lastIndex = bins.size() - 1;
        return IntStream.rangeClosed(0, lastIndex).mapToObj(i -> bins.get(lastIndex - i));
    }

    public Optional<B> chooseBin(P var1, List<B> var2);

    default public Predicate<B> binsThatCanFit(P piece) {
        return bin -> bin.canFit(piece);
    }
}

