/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov;

import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.app.plugin.prov.AbstractLookup;
import org.ligoj.app.plugin.prov.AbstractProvQuoteVmResource;
import org.ligoj.app.plugin.prov.AbstractQuoteInstanceOsEditionVo;
import org.ligoj.app.plugin.prov.AbstractQuoteVmEditionVo;
import org.ligoj.app.plugin.prov.ProvisioningService;
import org.ligoj.app.plugin.prov.dao.BaseProvTermPriceOsRepository;
import org.ligoj.app.plugin.prov.model.AbstractInstanceType;
import org.ligoj.app.plugin.prov.model.AbstractQuoteVm;
import org.ligoj.app.plugin.prov.model.AbstractQuoteVmOs;
import org.ligoj.app.plugin.prov.model.AbstractTermPriceVmOs;
import org.ligoj.app.plugin.prov.model.QuoteVmOs;
import org.ligoj.app.plugin.prov.model.VmOs;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProvQuoteInstanceOsResource<T extends AbstractInstanceType, P extends AbstractTermPriceVmOs<T>, C extends AbstractQuoteVmOs<P>, E extends AbstractQuoteInstanceOsEditionVo, L extends AbstractLookup<P>, Q extends QuoteVmOs>
extends AbstractProvQuoteVmResource<T, P, C, E, L, Q> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractProvQuoteInstanceOsResource.class);

    @Override
    public abstract BaseProvTermPriceOsRepository<T, P> getIpRepository();

    protected void checkOs(AbstractQuoteVmOs<P> entity) {
        ProvisioningService service = this.getService(entity.getConfiguration());
        if (service.getCatalogOs(entity.getOs()) != ((AbstractTermPriceVmOs)entity.getPrice()).getOs()) {
            log.warn("Attempt to create an instance with an incompatible OS {} with catalog OS {}", (Object)entity.getOs(), (Object)((AbstractTermPriceVmOs)entity.getPrice()).getOs());
            throw new ValidationJsonException("os", (Serializable)((Object)"incompatible-os"), new Serializable[]{((AbstractTermPriceVmOs)entity.getPrice()).getOs()});
        }
    }

    protected boolean canByol(VmOs os) {
        return os == VmOs.WINDOWS;
    }

    @Override
    protected void saveOrUpdateSpec(C entity, E vo) {
        ((AbstractQuoteVmOs)entity).setOs((VmOs)((Object)ObjectUtils.getIfNull((Object)((Object)((AbstractQuoteInstanceOsEditionVo)vo).getOs()), (Object)((Object)((AbstractTermPriceVmOs)((AbstractQuoteVm)entity).getPrice()).getOs()))));
        ((AbstractQuoteVm)entity).setEphemeral(((AbstractQuoteVmEditionVo)vo).isEphemeral());
        ((AbstractQuoteVmOs)entity).setMaxVariableCost(((AbstractQuoteInstanceOsEditionVo)vo).getMaxVariableCost());
        ((AbstractQuoteVm)entity).setInternet(((AbstractQuoteVmEditionVo)vo).getInternet());
        this.checkOs((AbstractQuoteVmOs<P>)entity);
    }

    public List<String> findLicenses(int subscription, VmOs os) {
        List<String> result = this.getIpRepository().findAllLicenses(this.subscriptionResource.checkVisible(Integer.valueOf(subscription)).getNode().getTool().getId(), os);
        result.replaceAll(l -> (String)StringUtils.defaultIfBlank((CharSequence)l, (CharSequence)"INCLUDED"));
        return result;
    }

    public List<String> findOs(int subscription) {
        return this.getIpRepository().findAllOs(this.subscriptionResource.checkVisible(Integer.valueOf(subscription)).getNode().getTool().getId());
    }
}

