/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov;

import java.util.Collection;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.app.plugin.prov.AbstractCostedResource;
import org.ligoj.app.plugin.prov.ProvNetworkResource;
import org.ligoj.app.plugin.prov.ProvTagResource;
import org.ligoj.app.plugin.prov.TagVo;
import org.ligoj.app.plugin.prov.UpdatedCost;
import org.ligoj.app.plugin.prov.dao.BaseProvQuoteRepository;
import org.ligoj.app.plugin.prov.dao.BaseProvTypeRepository;
import org.ligoj.app.plugin.prov.model.AbstractCodedEntity;
import org.ligoj.app.plugin.prov.model.AbstractPrice;
import org.ligoj.app.plugin.prov.model.AbstractQuote;
import org.ligoj.app.plugin.prov.model.ProvQuote;
import org.ligoj.app.plugin.prov.model.Rate;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.app.plugin.prov.quote.support.QuoteTagSupport;
import org.ligoj.bootstrap.core.IDescribableBean;
import org.ligoj.bootstrap.core.dao.RestRepository;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractProvQuoteResource<T extends AbstractCodedEntity, P extends AbstractPrice<T>, C extends AbstractQuote<P>, E extends IDescribableBean<Integer>>
extends AbstractCostedResource<T, P, C> {
    @Autowired
    protected ProvTagResource tagResource;
    @Autowired
    protected ProvNetworkResource networkResource;

    public abstract RestRepository<P, Integer> getIpRepository();

    public abstract BaseProvQuoteRepository<C> getQiRepository();

    public abstract BaseProvTypeRepository<T> getItRepository();

    protected abstract ResourceType getType();

    public abstract UpdatedCost create(E var1);

    public abstract UpdatedCost update(E var1);

    protected UpdatedCost deleteAll(int subscription) {
        ProvQuote quote = this.resource.getQuoteFromSubscription(subscription);
        UpdatedCost cost = new UpdatedCost(0);
        this.tagResource.onDeleteAll(this.getType(), (Integer)quote.getId());
        this.networkResource.onDeleteAll(this.getType(), (Integer)quote.getId());
        BaseProvQuoteRepository<C> repository = this.getQiRepository();
        cost.getDeleted().put(this.getType(), repository.findAllIdentifiers(quote));
        repository.deleteAll(repository.findAllBy("configuration.subscription.id", subscription));
        repository.flush();
        this.resource.updateCost(quote);
        return this.resource.refreshSupportCost(cost, quote);
    }

    protected void saveOrUpdate(C entity, QuoteTagSupport vo) {
        this.tagResource.replaceTags((Collection<TagVo>)vo.getTags(), (AbstractQuote<?>)entity);
    }

    protected UpdatedCost delete(int id) {
        this.tagResource.onDelete(this.getType(), id);
        this.networkResource.onDelete(this.getType(), id);
        return this.resource.refreshSupportCost(new UpdatedCost(id), this.deleteAndUpdateCost(this.getQiRepository(), id, Function.identity()::apply));
    }

    protected String normalize(String value) {
        return StringUtils.trimToEmpty((String)StringUtils.upperCase((String)value));
    }

    protected String normalize(AbstractQuote<?> quote) {
        if (quote == null) {
            return "";
        }
        return ((AbstractCodedEntity)((AbstractPrice)((Object)quote.getPrice())).getType()).getCode();
    }

    protected Rate normalize(Rate rate) {
        return rate == null ? Rate.WORST : rate;
    }

    protected int normalize(Integer value) {
        return value == null ? 0 : value;
    }

    protected boolean normalize(Boolean value) {
        return value != null && value != false;
    }

    protected boolean normalize(Boolean quoteValue, Boolean value) {
        return quoteValue == null ? this.normalize(value) : quoteValue.booleanValue();
    }
}

