/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import lombok.Generated;
import org.ligoj.app.plugin.prov.model.RoundSerializer;

public class Floating
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonSerialize(using=RoundSerializer.class)
    private double min;
    @JsonSerialize(using=RoundSerializer.class)
    private double max;
    @JsonSerialize(using=RoundSerializer.class)
    private double initial = 0.0;
    @JsonSerialize(using=RoundSerializer.class)
    private double maxInitial = 0.0;
    private boolean unbound;
    @JsonSerialize(using=RoundSerializer.class)
    private double minCo2;
    @JsonSerialize(using=RoundSerializer.class)
    private double maxCo2;

    public Floating() {
        this(0.0, 0.0);
    }

    public Floating(double base, double baseCo2) {
        this.min = base;
        this.max = base;
        this.minCo2 = baseCo2;
        this.maxCo2 = baseCo2;
    }

    public Floating add(Floating other) {
        this.min += other.min;
        this.max += other.max;
        this.initial += other.initial;
        this.maxInitial += other.maxInitial;
        this.unbound |= other.unbound;
        this.minCo2 += other.minCo2;
        this.maxCo2 += other.maxCo2;
        return this;
    }

    public Floating add(double cost, double co2) {
        this.min += cost;
        this.max += cost;
        this.minCo2 += co2;
        this.maxCo2 += co2;
        return this;
    }

    public Floating multiply(double rate) {
        this.min *= rate;
        this.max *= rate;
        this.initial *= rate;
        this.maxInitial *= rate;
        this.minCo2 *= rate;
        this.maxCo2 *= rate;
        return this;
    }

    public Floating round() {
        return new Floating(Floating.round(this.min), Floating.round(this.max), this.initial, this.maxInitial, this.unbound, Floating.round(this.minCo2), Floating.round(this.maxCo2));
    }

    public static double round(double value) {
        return (double)Math.round(value * 1000.0) / 1000.0;
    }

    @Generated
    public Floating(double min, double max, double initial, double maxInitial, boolean unbound, double minCo2, double maxCo2) {
        this.min = min;
        this.max = max;
        this.initial = initial;
        this.maxInitial = maxInitial;
        this.unbound = unbound;
        this.minCo2 = minCo2;
        this.maxCo2 = maxCo2;
    }

    @Generated
    public double getMin() {
        return this.min;
    }

    @Generated
    public double getMax() {
        return this.max;
    }

    @Generated
    public double getInitial() {
        return this.initial;
    }

    @Generated
    public double getMaxInitial() {
        return this.maxInitial;
    }

    @Generated
    public boolean isUnbound() {
        return this.unbound;
    }

    @Generated
    public double getMinCo2() {
        return this.minCo2;
    }

    @Generated
    public double getMaxCo2() {
        return this.maxCo2;
    }

    @Generated
    public void setMin(double min) {
        this.min = min;
    }

    @Generated
    public void setMax(double max) {
        this.max = max;
    }

    @Generated
    public void setMinCo2(double minCo2) {
        this.minCo2 = minCo2;
    }

    @Generated
    public void setMaxCo2(double maxCo2) {
        this.maxCo2 = maxCo2;
    }
}

