/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov;

import jakarta.persistence.EntityNotFoundException;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.ObjectUtils;
import org.ligoj.app.plugin.prov.Floating;
import org.ligoj.app.plugin.prov.UpdatedCost;
import org.ligoj.app.plugin.prov.dao.ProvQuoteRepository;
import org.ligoj.app.plugin.prov.model.AbstractQuote;
import org.ligoj.app.plugin.prov.model.Costed;
import org.ligoj.app.plugin.prov.model.ProvQuote;
import org.ligoj.app.resource.subscription.SubscriptionResource;
import org.ligoj.bootstrap.core.dao.RestRepository;

public interface QuoteRelated<C extends Costed> {
    public static final double HOURS_BY_MONTH = 730.0;

    public SubscriptionResource getSubscriptionResource();

    public ProvQuoteRepository getRepository();

    default public ProvQuote getQuoteFromSubscription(int subscription) {
        return (ProvQuote)this.getRepository().findBy("subscription", this.getSubscriptionResource().checkVisible(Integer.valueOf(subscription)));
    }

    default public <T extends Costed> UpdatedCost newUpdateCost(RestRepository<T, Integer> repository, T entity, Function<T, Floating> costUpdater) {
        Floating floatingCost = this.addCost(entity, costUpdater);
        repository.saveAndFlush(entity);
        UpdatedCost cost = new UpdatedCost((Integer)entity.getId());
        cost.setCost(floatingCost);
        cost.setTotal(((ProvQuote)entity.getConfiguration()).toFloating());
        return cost;
    }

    default public <T extends Costed> Floating addCost(T entity, Function<T, Floating> costUpdater) {
        double oldCost = (Double)ObjectUtils.getIfNull((Object)entity.getCost(), (Object)0.0);
        double oldMaxCost = (Double)ObjectUtils.getIfNull((Object)entity.getMaxCost(), (Object)0.0);
        double oldCo2 = (Double)ObjectUtils.getIfNull((Object)entity.getCo2(), (Object)0.0);
        double oldMaxCo2 = (Double)ObjectUtils.getIfNull((Object)entity.getMaxCo2(), (Object)0.0);
        double oldInitial = (Double)ObjectUtils.getIfNull((Object)entity.getInitialCost(), (Object)0.0);
        double oldMaxInitial = (Double)ObjectUtils.getIfNull((Object)entity.getMaxInitialCost(), (Object)0.0);
        Floating newCost = costUpdater.apply(entity);
        this.addCost(entity, oldCost, oldMaxCost, oldInitial, oldMaxInitial, oldCo2, oldMaxCo2);
        return newCost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T extends Costed> void addCost(T entity, double old, double oldMax, double oldInitial, double oldMaxInitial, double oldCo2, double oldMaxCo2) {
        ProvQuote quote = (ProvQuote)entity.getConfiguration();
        double delta = entity.getCost() - old;
        double maxDelta = entity.getMaxCost() - oldMax;
        double deltaCo2 = entity.getCo2() - oldCo2;
        double maxDeltaCo2 = entity.getMaxCo2() - oldMaxCo2;
        double deltaI = entity.getInitialCost() - oldInitial;
        double maxDeltaI = entity.getMaxInitialCost() - oldMaxInitial;
        if (Math.abs(delta) + Math.abs(maxDelta) + Math.abs(deltaI) + Math.abs(maxDeltaI) + Math.abs(deltaCo2) + Math.abs(maxDeltaCo2) != 0.0) {
            ProvQuote provQuote = quote;
            synchronized (provQuote) {
                quote.setCostNoSupport(this.round(quote.getCostNoSupport() + delta));
                quote.setMaxCostNoSupport(this.round(quote.getMaxCostNoSupport() + maxDelta));
                quote.setCo2(this.round(quote.getCo2() + deltaCo2));
                quote.setMaxCo2(this.round(quote.getMaxCo2() + maxDeltaCo2));
                quote.setInitialCost(this.round(quote.getInitialCost() + deltaI));
                quote.setMaxInitialCost(this.round(quote.getMaxInitialCost() + maxDeltaI));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Floating addCost(ProvQuote quote, Floating fc) {
        ProvQuote provQuote = quote;
        synchronized (provQuote) {
            quote.setCostNoSupport(this.round(quote.getCostNoSupport() + fc.getMin()));
            quote.setMaxCostNoSupport(this.round(quote.getMaxCostNoSupport() + fc.getMax()));
            quote.setCo2(this.round(quote.getCo2() + fc.getMinCo2()));
            quote.setMaxCo2(this.round(quote.getMaxCo2() + fc.getMaxCo2()));
            quote.setInitialCost(this.round(quote.getInitialCost() + fc.getInitial()));
            quote.setMaxInitialCost(this.round(quote.getMaxInitialCost() + fc.getMaxInitial()));
        }
        return fc;
    }

    default public double round(double value) {
        return Floating.round(value);
    }

    default public <T extends AbstractQuote<?>> Floating updateCost(T qr, Function<T, Floating> costProvider) {
        Floating cost = costProvider.apply(qr);
        qr.setCost(this.round(cost.getMin()));
        qr.setMaxCost(this.round(cost.getMax()));
        qr.setCo2(this.round(cost.getMinCo2()));
        qr.setMaxCo2(this.round(cost.getMaxCo2()));
        qr.setInitialCost(this.round(cost.getInitial()));
        qr.setMaxInitialCost(this.round(cost.getMaxInitial()));
        return new Floating(qr.getCost(), qr.getMaxCost(), qr.getInitialCost(), qr.getMaxInitialCost(), qr.isUnboundCost(), qr.getCo2(), qr.getMaxCo2());
    }

    default public <T> T assertFound(T object, String name) {
        return Optional.ofNullable(object).orElseThrow(() -> new EntityNotFoundException(name));
    }

    public Floating refresh(C var1);
}

