/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov;

import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class Workload {
    private final double baseline;
    private final List<WorkloadPeriod> periods;
    private static final double DEFAULT_BASELINE = 5.0;
    private static final Workload DEFAULT_WORKLOAD = new Workload(5.0, new String[]{null, "100@5.0"});
    private static final Workload FULL_WORKLOAD = new Workload(100.0, new String[]{null, "100@100"});

    private Workload(double baseline, String[] parts) {
        this.baseline = baseline;
        this.periods = parts.length == 1 ? List.of(new WorkloadPeriod(100.0, baseline)) : Stream.of(parts).skip(1L).map(p -> {
            String[] periodParts = StringUtils.split((String)p, (char)'@');
            return new WorkloadPeriod(Double.parseDouble(periodParts[0]), Double.parseDouble(periodParts[1]));
        }).toList();
    }

    public static Workload from(String rawData) {
        if (rawData == null) {
            return DEFAULT_WORKLOAD;
        }
        String[] parts = StringUtils.split((String)rawData, (char)',');
        double baseline = Double.parseDouble(parts[0]);
        if (baseline == 100.0) {
            return FULL_WORKLOAD;
        }
        return new Workload(baseline, parts);
    }

    @Generated
    public double getBaseline() {
        return this.baseline;
    }

    @Generated
    public List<WorkloadPeriod> getPeriods() {
        return this.periods;
    }

    static class WorkloadPeriod {
        double duration;
        double value;

        @Generated
        public WorkloadPeriod(double duration, double value) {
            this.duration = duration;
            this.value = value;
        }
    }
}

