/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.catalog;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.Strings;
import org.ligoj.app.model.Node;
import org.ligoj.app.plugin.prov.catalog.Co2Data;
import org.ligoj.app.plugin.prov.catalog.Co2RegionData;
import org.ligoj.app.plugin.prov.model.ProvContainerPrice;
import org.ligoj.app.plugin.prov.model.ProvContainerType;
import org.ligoj.app.plugin.prov.model.ProvDatabasePrice;
import org.ligoj.app.plugin.prov.model.ProvDatabaseType;
import org.ligoj.app.plugin.prov.model.ProvFunctionPrice;
import org.ligoj.app.plugin.prov.model.ProvFunctionType;
import org.ligoj.app.plugin.prov.model.ProvInstancePrice;
import org.ligoj.app.plugin.prov.model.ProvInstancePriceTerm;
import org.ligoj.app.plugin.prov.model.ProvInstanceType;
import org.ligoj.app.plugin.prov.model.ProvLocation;
import org.ligoj.app.plugin.prov.model.ProvStoragePrice;
import org.ligoj.app.plugin.prov.model.ProvStorageType;
import org.ligoj.app.plugin.prov.model.ProvSupportPrice;
import org.ligoj.app.plugin.prov.model.ProvSupportType;

public abstract class AbstractUpdateContext {
    protected Node node;
    private boolean force;
    private Map<String, ProvLocation> mapRegionById = new HashMap<String, ProvLocation>();
    protected Map<String, ProvInstanceType> instanceTypes = new ConcurrentHashMap<String, ProvInstanceType>();
    protected Map<String, ProvContainerType> containerTypes = new ConcurrentHashMap<String, ProvContainerType>();
    protected Map<String, ProvFunctionType> functionTypes = new ConcurrentHashMap<String, ProvFunctionType>();
    private Map<String, ProvSupportType> supportTypes = new HashMap<String, ProvSupportType>();
    protected Map<String, ProvDatabaseType> databaseTypes = new ConcurrentHashMap<String, ProvDatabaseType>();
    protected Map<String, ProvInstancePriceTerm> priceTerms = new ConcurrentHashMap<String, ProvInstancePriceTerm>();
    private Map<String, ProvInstancePrice> previous = new HashMap<String, ProvInstancePrice>();
    private final Set<String> prices = new HashSet<String>();
    private Map<String, ProvDatabasePrice> previousDatabase = new HashMap<String, ProvDatabasePrice>();
    private Map<String, ProvContainerPrice> previousContainer = new HashMap<String, ProvContainerPrice>();
    private Map<String, ProvFunctionPrice> previousFunction = new HashMap<String, ProvFunctionPrice>();
    private Map<String, ProvStoragePrice> previousStorage = new HashMap<String, ProvStoragePrice>();
    private Map<String, ProvSupportPrice> previousSupport = new HashMap<String, ProvSupportPrice>();
    private Map<String, ProvLocation> regions = Collections.synchronizedMap(new HashMap());
    private Set<String> mergedTypes = Collections.synchronizedSet(new HashSet());
    private Set<String> mergedTerms = Collections.synchronizedSet(new HashSet());
    private Set<String> mergedLocations = Collections.synchronizedSet(new HashSet());
    private Map<String, ProvStorageType> storageTypes = new ConcurrentHashMap<String, ProvStorageType>();
    private Pattern validOs;
    private Pattern validInstanceType;
    private Pattern validDatabaseType;
    private Pattern validContainerType;
    private Pattern validDatabaseEngine;
    private Pattern validRegion;
    private String baseUrl;
    private double hoursMonth = 730.0;
    private Map<String, Co2Data> co2DataSet = new ConcurrentHashMap<String, Co2Data>();
    private Map<String, Co2RegionData> co2RegionDataSet = new ConcurrentHashMap<String, Co2RegionData>();

    protected AbstractUpdateContext(AbstractUpdateContext parent) {
        this();
        this.setForce(parent.isForce());
        this.setHoursMonth(parent.getHoursMonth());
        this.setNode(parent.getNode());
        this.regions = parent.regions;
        this.baseUrl = parent.baseUrl;
        this.mergedTypes = parent.mergedTypes;
        this.mergedTerms = parent.mergedTerms;
        this.mergedLocations = parent.mergedLocations;
        this.storageTypes = parent.storageTypes;
        this.priceTerms = parent.priceTerms;
        this.validDatabaseEngine = parent.validDatabaseEngine;
        this.validDatabaseType = parent.validDatabaseType;
        this.validContainerType = parent.validContainerType;
        this.validInstanceType = parent.validInstanceType;
        this.validRegion = parent.validRegion;
        this.validOs = parent.validOs;
        this.mapRegionById = parent.getMapRegionById();
        this.co2DataSet = parent.getCo2DataSet();
        this.co2RegionDataSet = parent.getCo2RegionDataSet();
    }

    public double getSecondsMonth() {
        return this.getHoursMonth() * 3600000.0 / 1000.0;
    }

    public void setPrevious(Map<String, ProvInstancePrice> previous) {
        this.previous = previous;
        this.previousDatabase.clear();
        this.previousContainer.clear();
        this.previousFunction.clear();
        this.prices.clear();
    }

    public void setPreviousDatabase(Map<String, ProvDatabasePrice> previous) {
        this.previous.clear();
        this.previousDatabase = previous;
        this.previousContainer.clear();
        this.previousFunction.clear();
        this.prices.clear();
    }

    public void setPreviousContainer(Map<String, ProvContainerPrice> previous) {
        this.previousContainer = previous;
        this.previousDatabase.clear();
        this.previousFunction.clear();
        this.previous.clear();
        this.prices.clear();
    }

    public void setPreviousFunction(Map<String, ProvFunctionPrice> previous) {
        this.previousFunction = previous;
        this.previousContainer.clear();
        this.previousDatabase.clear();
        this.previous.clear();
        this.prices.clear();
    }

    public void cleanup() {
        this.prices.clear();
        this.mergedTypes.clear();
        this.mergedTerms.clear();
        this.mergedLocations.clear();
        this.storageTypes.clear();
        this.supportTypes.clear();
        this.storageTypes.clear();
        this.previous.clear();
        this.databaseTypes.clear();
        this.containerTypes.clear();
        this.functionTypes.clear();
        this.instanceTypes.clear();
        this.previousStorage.clear();
        this.previousDatabase.clear();
        this.previousContainer.clear();
        this.previousFunction.clear();
        this.previousSupport.clear();
        this.priceTerms.clear();
    }

    public String getUrl(String relative) {
        return this.baseUrl + Strings.CS.prependIfMissing(relative, (CharSequence)"/", new CharSequence[0]);
    }

    @Generated
    public AbstractUpdateContext() {
    }

    @Generated
    public Node getNode() {
        return this.node;
    }

    @Generated
    public boolean isForce() {
        return this.force;
    }

    @Generated
    public Map<String, ProvLocation> getMapRegionById() {
        return this.mapRegionById;
    }

    @Generated
    public Map<String, ProvInstanceType> getInstanceTypes() {
        return this.instanceTypes;
    }

    @Generated
    public Map<String, ProvContainerType> getContainerTypes() {
        return this.containerTypes;
    }

    @Generated
    public Map<String, ProvFunctionType> getFunctionTypes() {
        return this.functionTypes;
    }

    @Generated
    public Map<String, ProvSupportType> getSupportTypes() {
        return this.supportTypes;
    }

    @Generated
    public Map<String, ProvDatabaseType> getDatabaseTypes() {
        return this.databaseTypes;
    }

    @Generated
    public Map<String, ProvInstancePriceTerm> getPriceTerms() {
        return this.priceTerms;
    }

    @Generated
    public Map<String, ProvInstancePrice> getPrevious() {
        return this.previous;
    }

    @Generated
    public Set<String> getPrices() {
        return this.prices;
    }

    @Generated
    public Map<String, ProvDatabasePrice> getPreviousDatabase() {
        return this.previousDatabase;
    }

    @Generated
    public Map<String, ProvContainerPrice> getPreviousContainer() {
        return this.previousContainer;
    }

    @Generated
    public Map<String, ProvFunctionPrice> getPreviousFunction() {
        return this.previousFunction;
    }

    @Generated
    public Map<String, ProvStoragePrice> getPreviousStorage() {
        return this.previousStorage;
    }

    @Generated
    public Map<String, ProvSupportPrice> getPreviousSupport() {
        return this.previousSupport;
    }

    @Generated
    public Map<String, ProvLocation> getRegions() {
        return this.regions;
    }

    @Generated
    public Set<String> getMergedTypes() {
        return this.mergedTypes;
    }

    @Generated
    public Set<String> getMergedTerms() {
        return this.mergedTerms;
    }

    @Generated
    public Set<String> getMergedLocations() {
        return this.mergedLocations;
    }

    @Generated
    public Map<String, ProvStorageType> getStorageTypes() {
        return this.storageTypes;
    }

    @Generated
    public Pattern getValidOs() {
        return this.validOs;
    }

    @Generated
    public Pattern getValidInstanceType() {
        return this.validInstanceType;
    }

    @Generated
    public Pattern getValidDatabaseType() {
        return this.validDatabaseType;
    }

    @Generated
    public Pattern getValidContainerType() {
        return this.validContainerType;
    }

    @Generated
    public Pattern getValidDatabaseEngine() {
        return this.validDatabaseEngine;
    }

    @Generated
    public Pattern getValidRegion() {
        return this.validRegion;
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public double getHoursMonth() {
        return this.hoursMonth;
    }

    @Generated
    public Map<String, Co2Data> getCo2DataSet() {
        return this.co2DataSet;
    }

    @Generated
    public Map<String, Co2RegionData> getCo2RegionDataSet() {
        return this.co2RegionDataSet;
    }

    @Generated
    public void setNode(Node node) {
        this.node = node;
    }

    @Generated
    public void setForce(boolean force) {
        this.force = force;
    }

    @Generated
    public void setInstanceTypes(Map<String, ProvInstanceType> instanceTypes) {
        this.instanceTypes = instanceTypes;
    }

    @Generated
    public void setContainerTypes(Map<String, ProvContainerType> containerTypes) {
        this.containerTypes = containerTypes;
    }

    @Generated
    public void setFunctionTypes(Map<String, ProvFunctionType> functionTypes) {
        this.functionTypes = functionTypes;
    }

    @Generated
    public void setSupportTypes(Map<String, ProvSupportType> supportTypes) {
        this.supportTypes = supportTypes;
    }

    @Generated
    public void setDatabaseTypes(Map<String, ProvDatabaseType> databaseTypes) {
        this.databaseTypes = databaseTypes;
    }

    @Generated
    public void setPriceTerms(Map<String, ProvInstancePriceTerm> priceTerms) {
        this.priceTerms = priceTerms;
    }

    @Generated
    public void setPreviousStorage(Map<String, ProvStoragePrice> previousStorage) {
        this.previousStorage = previousStorage;
    }

    @Generated
    public void setPreviousSupport(Map<String, ProvSupportPrice> previousSupport) {
        this.previousSupport = previousSupport;
    }

    @Generated
    public void setRegions(Map<String, ProvLocation> regions) {
        this.regions = regions;
    }

    @Generated
    public void setStorageTypes(Map<String, ProvStorageType> storageTypes) {
        this.storageTypes = storageTypes;
    }

    @Generated
    public void setValidOs(Pattern validOs) {
        this.validOs = validOs;
    }

    @Generated
    public void setValidInstanceType(Pattern validInstanceType) {
        this.validInstanceType = validInstanceType;
    }

    @Generated
    public void setValidDatabaseType(Pattern validDatabaseType) {
        this.validDatabaseType = validDatabaseType;
    }

    @Generated
    public void setValidContainerType(Pattern validContainerType) {
        this.validContainerType = validContainerType;
    }

    @Generated
    public void setValidDatabaseEngine(Pattern validDatabaseEngine) {
        this.validDatabaseEngine = validDatabaseEngine;
    }

    @Generated
    public void setValidRegion(Pattern validRegion) {
        this.validRegion = validRegion;
    }

    @Generated
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Generated
    public void setHoursMonth(double hoursMonth) {
        this.hoursMonth = hoursMonth;
    }
}

