/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.catalog;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.ligoj.app.dao.NodeRepository;
import org.ligoj.app.model.Node;
import org.ligoj.app.plugin.prov.AbstractProvQuoteResource;
import org.ligoj.app.plugin.prov.ProvResource;
import org.ligoj.app.plugin.prov.catalog.CatalogEditionVo;
import org.ligoj.app.plugin.prov.catalog.CatalogVo;
import org.ligoj.app.plugin.prov.catalog.ImportCatalogService;
import org.ligoj.app.plugin.prov.dao.Co2Price;
import org.ligoj.app.plugin.prov.dao.ImportCatalogStatusRepository;
import org.ligoj.app.plugin.prov.dao.ProvLocationRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteRepository;
import org.ligoj.app.plugin.prov.model.ImportCatalogStatus;
import org.ligoj.app.plugin.prov.model.ProvLocation;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.app.resource.ServicePluginLocator;
import org.ligoj.app.resource.node.LongTaskRunnerNode;
import org.ligoj.app.resource.node.NodeHelper;
import org.ligoj.app.resource.node.NodeResource;
import org.ligoj.bootstrap.core.resource.OnNullReturn404;
import org.ligoj.bootstrap.core.security.SecurityHelper;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/prov/catalog")
@Produces(value={"application/json"})
@Transactional
public class ImportCatalogResource
implements LongTaskRunnerNode<ImportCatalogStatus, ImportCatalogStatusRepository> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportCatalogResource.class);
    private static final String BY_NODE = "node.id";
    @Autowired
    private NodeResource nodeResource;
    @Autowired
    private ProvResource resource;
    @Autowired
    private SecurityHelper securityHelper;
    @Autowired
    private NodeRepository nodeRepository;
    @Autowired
    protected ServicePluginLocator locator;
    @Autowired
    protected ImportCatalogStatusRepository taskRepository;
    @Autowired
    private ProvLocationRepository locationRepository;
    @Autowired
    private ProvQuoteRepository repository;

    @POST
    @Path(value="{node:service:prov:.+}")
    public ImportCatalogStatus updateCatalog(@PathParam(value="node") String node, @QueryParam(value="force") @DefaultValue(value="false") boolean force) {
        Node entity = this.nodeResource.checkWritableNode(node).getTool();
        ImportCatalogService catalogService = (ImportCatalogService)this.locator.getResource(entity.getId(), ImportCatalogService.class);
        ImportCatalogStatus task = (ImportCatalogStatus)this.startTask((Serializable)((Object)entity.getId()), t -> {
            t.setLocation(null);
            t.setNbPrices(0);
            t.setNbCo2Prices(0);
            t.setNbTypes(0);
            t.setWorkload(0);
            t.setDone(0);
            t.setPhase(null);
        });
        String user = this.securityHelper.getLogin();
        try (ExecutorService executor = Executors.newSingleThreadExecutor();){
            executor.submit(() -> {
                Thread.sleep(50L);
                this.securityHelper.setUserName(user);
                this.updateCatalog(catalogService, entity.getId(), force);
                return null;
            });
        }
        return task;
    }

    protected void updateCatalog(ImportCatalogService catalogService, String node) {
        this.updateCatalog(catalogService, node, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCatalog(ImportCatalogService catalogService, String node, boolean force) {
        log.info("Catalog update for {}", (Object)node);
        boolean failed = true;
        try {
            catalogService.updateCatalog(node, force);
            log.info("Catalog update succeed for {}", (Object)node);
            failed = false;
        }
        catch (Exception e) {
            log.error("Catalog update failed for {}", (Object)node, (Object)e);
        }
        finally {
            this.endTask((Serializable)((Object)node), failed, t -> {
                if (!t.isFailed()) {
                    t.setLastSuccess(t.getEnd());
                    this.updateStats((ImportCatalogStatus)((Object)t));
                }
            });
        }
    }

    @DELETE
    @Path(value="{node:service:prov:.+}")
    @OnNullReturn404
    public ImportCatalogStatus cancel(@PathParam(value="node") String node) {
        return (ImportCatalogStatus)super.cancel(this.nodeResource.checkWritableNode(node).getTool().getId());
    }

    @GET
    @Path(value="{node:service:prov:[^/]+}")
    public ImportCatalogStatus getTask(@PathParam(value="node") String node) {
        return (ImportCatalogStatus)super.getTask(this.nodeResource.checkWritableNode(node).getTool().getId());
    }

    public void updateStats(ImportCatalogStatus task) {
        this.updateStats(task, task.getLocked().getId());
    }

    private void updateStats(ImportCatalogStatus task, String node) {
        ImportCatalogStatus taskTemp = new ImportCatalogStatus();
        Stream.of(ResourceType.values()).forEach(t -> this.updateResourceStats(taskTemp, node, (ResourceType)((Object)t)));
        task.setNbLocations((int)this.locationRepository.countBy(BY_NODE, node));
        task.setNbPrices(taskTemp.getNbPrices());
        task.setNbTypes(taskTemp.getNbTypes());
        task.setNbCo2Prices(taskTemp.getNbCo2Prices());
    }

    private void updateResourceStats(ImportCatalogStatus task, String node, ResourceType t) {
        AbstractProvQuoteResource<?, ?, ?, ?> qResource = this.resource.getResource(t);
        task.setNbPrices(task.getNbPrices() + (int)qResource.getIpRepository().countBy("type.node.id", (Object)node));
        if (t.isCo2()) {
            task.setNbCo2Prices(task.getNbCo2Prices() + ((Co2Price)qResource.getIpRepository()).countCo2DataByNode(node));
        }
        task.setNbTypes(task.getNbTypes() + (int)qResource.getItRepository().countBy(BY_NODE, node));
    }

    @GET
    public List<CatalogVo> findAll() {
        Map statuses = this.taskRepository.findAllVisible(this.securityHelper.getLogin()).stream().collect(Collectors.toMap(s -> s.getLocked().getId(), Function.identity()));
        Page providers = this.nodeRepository.findAllVisible(this.securityHelper.getLogin(), "", ProvResource.SERVICE_KEY, null, 1, (Pageable)PageRequest.of((int)0, (int)100));
        return providers.getContent().stream().sorted().map(n -> {
            CatalogVo vo = new CatalogVo();
            vo.setStatus(Optional.ofNullable((ImportCatalogStatus)((Object)((Object)statuses.get(n.getId())))).orElseGet(() -> {
                ImportCatalogStatus status = new ImportCatalogStatus();
                this.updateStats(status, n.getId());
                return status;
            }));
            vo.setNode(NodeHelper.toVo((Node)n));
            vo.setCanImport(this.locator.getResource(n.getId(), ImportCatalogService.class) != null);
            vo.setNbQuotes((int)this.repository.countByNode(n.getId()));
            vo.setPreferredLocation((ProvLocation)((Object)((Object)this.locationRepository.findBy("node", n, new String[]{"preferred"}, new Object[]{true}))));
            return vo;
        }).toList();
    }

    @PUT
    public void update(CatalogEditionVo vo) {
        String nodeId = this.nodeResource.checkWritableNode(vo.getNode()).getTool().getId();
        if (!((ProvLocation)((Object)this.locationRepository.findBy("id", vo.getPreferredLocation()))).getNode().getId().equals(nodeId)) {
            throw new ValidationJsonException(nodeId, (Serializable)((Object)"node-not-same"), new Serializable[0]);
        }
        this.locationRepository.unsetPreferredLocation(nodeId);
        this.locationRepository.setPreferredLocation(nodeId, vo.getPreferredLocation());
    }

    public Supplier<ImportCatalogStatus> newTask() {
        return ImportCatalogStatus::new;
    }

    @Generated
    public NodeResource getNodeResource() {
        return this.nodeResource;
    }

    @Generated
    public NodeRepository getNodeRepository() {
        return this.nodeRepository;
    }

    @Generated
    public ImportCatalogStatusRepository getTaskRepository() {
        return this.taskRepository;
    }
}

