/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.currency;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.ligoj.app.plugin.prov.dao.ProvCurrencyRepository;
import org.ligoj.app.plugin.prov.model.CurrencyVo;
import org.ligoj.app.plugin.prov.model.ProvCurrency;
import org.ligoj.bootstrap.core.json.PaginationJson;
import org.ligoj.bootstrap.core.json.TableItem;
import org.ligoj.bootstrap.core.json.datatable.DataTableAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/prov/currency")
@Produces(value={"application/json"})
@Transactional
public class ProvCurrencyResource {
    private static final Map<String, String> ORM_COLUMNS = new HashMap<String, String>();
    @Autowired
    private ProvCurrencyRepository repository;
    @Autowired
    private PaginationJson paginationJson;

    @DELETE
    @Path(value="{id:\\d+}")
    @Consumes(value={"application/json"})
    public void delete(@PathParam(value="id") int id) {
        this.repository.deleteNoFetch(Integer.valueOf(id));
    }

    @POST
    @Consumes(value={"application/json"})
    public int create(ProvCurrency entity) {
        return (Integer)((ProvCurrency)((Object)this.repository.saveAndFlush((Object)entity))).getId();
    }

    @PUT
    @Consumes(value={"application/json"})
    public void update(ProvCurrency entity) {
        this.repository.saveAndFlush((Object)entity);
    }

    @GET
    @Consumes(value={"application/json"})
    public TableItem<CurrencyVo> findAll(@Context UriInfo uriInfo) {
        return this.paginationJson.applyPagination(uriInfo, this.repository.findAll(DataTableAttributes.getSearch((UriInfo)uriInfo), (Pageable)this.paginationJson.getPageRequest(uriInfo, ORM_COLUMNS)), Function.identity());
    }

    static {
        ORM_COLUMNS.put("name", "name");
        ORM_COLUMNS.put("description", "description");
        ORM_COLUMNS.put("unit", "unit");
    }
}

