/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.dao;

import java.util.List;
import javax.cache.annotation.CacheKey;
import org.ligoj.app.plugin.prov.dao.BaseProvTermPriceVmRepository;
import org.ligoj.app.plugin.prov.model.AbstractInstanceType;
import org.ligoj.app.plugin.prov.model.AbstractTermPriceVmOs;
import org.ligoj.app.plugin.prov.model.VmOs;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.NoRepositoryBean;

@NoRepositoryBean
public interface BaseProvTermPriceOsRepository<T extends AbstractInstanceType, P extends AbstractTermPriceVmOs<T>>
extends BaseProvTermPriceVmRepository<T, P> {
    public static final String DYNAMIC_QUERY_OS = "SELECT ip,\n (  ip.cost\n  + CEIL(GREATEST(ip.minCpu, :cpu) /ip.incrementCpu) * ip.incrementCpu * ip.costCpu\n  + CASE WHEN (ip.incrementGpu IS NULL OR ip.incrementGpu=0.0) THEN 0.0 ELSE (CEIL(GREATEST(ip.minGpu, :gpu) /ip.incrementGpu) * ip.incrementGpu * ip.costGpu) END\n  + CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio,0.0), :ram) /ip.incrementRam) * ip.incrementRam * ip.costRam\n )\n * (CASE WHEN ip.period = 0 THEN CAST(:globalRate AS Double) ELSE (ip.period * CEIL(:duration/ip.period)) END) AS totalCost,\n (  ip.cost\n  + CEIL(GREATEST(ip.minCpu, :cpu) /ip.incrementCpu) * ip.incrementCpu * ip.costCpu\n  + CASE WHEN (ip.incrementGpu IS NULL OR ip.incrementGpu=0.0) THEN 0.0 ELSE (CEIL(GREATEST(ip.minGpu, :gpu) /ip.incrementGpu) * ip.incrementGpu * ip.costGpu) END\n  + CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio,0.0), :ram) /ip.incrementRam) * ip.incrementRam * ip.costRam\n )\n * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE 1.0 END AS monthlyCost,\n\n (  ip.co2\n  + CEIL(GREATEST(ip.minCpu, :cpu) /ip.incrementCpu) * ip.incrementCpu * ip.co2Cpu\n  + CASE WHEN (ip.incrementGpu IS NULL OR ip.incrementGpu=0.0) THEN 0.0 ELSE (CEIL(GREATEST(ip.minGpu, :gpu) /ip.incrementGpu) * ip.incrementGpu * ip.co2Gpu) END\n  + CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio,0.0), :ram) /ip.incrementRam) * ip.incrementRam * ip.co2Ram\n )\n * CASE WHEN ip.period = 0 THEN CAST(:globalRate AS Double) ELSE (ip.period * CEIL(:duration/ip.period)) END AS totalCo2,\n (  ip.co2\n  + CEIL(GREATEST(ip.minCpu, :cpu) /ip.incrementCpu) * ip.incrementCpu * ip.co2Cpu\n  + CASE WHEN (ip.incrementGpu IS NULL OR ip.incrementGpu=0.0) THEN 0.0 ELSE (CEIL(GREATEST(ip.minGpu, :gpu) /ip.incrementGpu) * ip.incrementGpu * ip.co2Gpu) END\n  + CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio,0.0), :ram) /ip.incrementRam) * ip.incrementRam * ip.co2Ram\n )\n * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE 1.0 END AS monthlyCo2\n FROM #{#entityName} ip WHERE\n      ip.location.id = :location\n  AND ip.incrementCpu IS NOT NULL\n  AND (ip.license IS NULL OR :license = ip.license)\n  AND (ip.type.id IN :types)\n  AND (ip.term.id IN :terms)\n  AND (ip.maxCpu  IS NULL OR ip.maxCpu >=:cpu)\n  AND (ip.maxGpu  IS NULL OR ip.maxGpu >=:gpu)\n  AND (ip.maxRam  IS NULL OR ip.maxRam >=:ram)\n  AND (ip.initialCost IS NULL OR :initialCost >= ip.initialCost)\n  AND (ip.maxRamRatio IS NULL OR GREATEST(ip.minCpu, :cpu) * ip.maxRamRatio <= :ram)\n  AND ip.os=:os\n";
    public static final String LOWEST_QUERY_OS = "SELECT ip,\n (CASE\n  WHEN ip.period = 0 THEN (ip.cost * :rate * :duration)\n  ELSE (ip.costPeriod * ceil(:duration/ip.period)) END) AS totalCost,\n (CASE\n  WHEN ip.period = 0 THEN (ip.cost * :rate)\n  ELSE ip.cost END) AS monthlyCost,\n (CASE\n  WHEN ip.period = 0 THEN (ip.co2 * :rate * :duration)\n  ELSE (ip.co2Period * ceil(:duration/ip.period)) END) AS totalCo2,\n (CASE\n  WHEN ip.period = 0 THEN (ip.co2 * :rate)\n  ELSE ip.co2 END) AS monthlyCo2\n FROM #{#entityName} ip WHERE\n      ip.location.id = :location\n  AND ip.incrementCpu IS NULL\n  AND (ip.type.id IN :types)\n  AND (ip.term.id IN :terms)\n  AND (ip.initialCost IS NULL OR :initialCost >= ip.initialCost)\n  AND (ip.license IS NULL OR :license = ip.license)\n  AND ip.os=:os\n";

    @Query(value="SELECT DISTINCT(ip.license) FROM #{#entityName} ip INNER JOIN ip.type AS i\n  WHERE :node = i.node.id AND ip.os=:os ORDER BY ip.license\n")
    public List<String> findAllLicenses(String var1, VmOs var2);

    @Query(value="SELECT DISTINCT(ip.os) FROM #{#entityName} ip INNER JOIN ip.type AS i\n  WHERE ip.os IS NOT NULL AND :node = i.node.id\n  ORDER BY ip.os\n")
    public List<String> findAllOs(@CacheKey String var1);
}

