/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.dao;

import java.util.List;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheResult;
import org.ligoj.app.plugin.prov.dao.BaseProvTermPriceOsRepository;
import org.ligoj.app.plugin.prov.model.ProvContainerPrice;
import org.ligoj.app.plugin.prov.model.ProvContainerType;
import org.ligoj.app.plugin.prov.model.VmOs;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;

public interface ProvContainerPriceRepository
extends BaseProvTermPriceOsRepository<ProvContainerType, ProvContainerPrice> {
    @Override
    @CacheResult(cacheName="prov-container-license")
    public List<String> findAllLicenses(@CacheKey String var1, @CacheKey VmOs var2);

    @Override
    @CacheResult(cacheName="prov-container-os")
    public List<String> findAllOs(@CacheKey String var1);

    @Query(value="SELECT ip,\n (  ip.cost\n  + CEIL(GREATEST(ip.minCpu, :cpu) /ip.incrementCpu) * ip.incrementCpu * ip.costCpu\n  + CASE WHEN (ip.incrementGpu IS NULL OR ip.incrementGpu=0.0) THEN 0.0 ELSE (CEIL(GREATEST(ip.minGpu, :gpu) /ip.incrementGpu) * ip.incrementGpu * ip.costGpu) END\n  + CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio,0.0), :ram) /ip.incrementRam) * ip.incrementRam * ip.costRam\n )\n * (CASE WHEN ip.period = 0 THEN CAST(:globalRate AS Double) ELSE (ip.period * CEIL(:duration/ip.period)) END) AS totalCost,\n (  ip.cost\n  + CEIL(GREATEST(ip.minCpu, :cpu) /ip.incrementCpu) * ip.incrementCpu * ip.costCpu\n  + CASE WHEN (ip.incrementGpu IS NULL OR ip.incrementGpu=0.0) THEN 0.0 ELSE (CEIL(GREATEST(ip.minGpu, :gpu) /ip.incrementGpu) * ip.incrementGpu * ip.costGpu) END\n  + CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio,0.0), :ram) /ip.incrementRam) * ip.incrementRam * ip.costRam\n )\n * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE 1.0 END AS monthlyCost,\n\n (  ip.co2\n  + CEIL(GREATEST(ip.minCpu, :cpu) /ip.incrementCpu) * ip.incrementCpu * ip.co2Cpu\n  + CASE WHEN (ip.incrementGpu IS NULL OR ip.incrementGpu=0.0) THEN 0.0 ELSE (CEIL(GREATEST(ip.minGpu, :gpu) /ip.incrementGpu) * ip.incrementGpu * ip.co2Gpu) END\n  + CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio,0.0), :ram) /ip.incrementRam) * ip.incrementRam * ip.co2Ram\n )\n * CASE WHEN ip.period = 0 THEN CAST(:globalRate AS Double) ELSE (ip.period * CEIL(:duration/ip.period)) END AS totalCo2,\n (  ip.co2\n  + CEIL(GREATEST(ip.minCpu, :cpu) /ip.incrementCpu) * ip.incrementCpu * ip.co2Cpu\n  + CASE WHEN (ip.incrementGpu IS NULL OR ip.incrementGpu=0.0) THEN 0.0 ELSE (CEIL(GREATEST(ip.minGpu, :gpu) /ip.incrementGpu) * ip.incrementGpu * ip.co2Gpu) END\n  + CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio,0.0), :ram) /ip.incrementRam) * ip.incrementRam * ip.co2Ram\n )\n * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE 1.0 END AS monthlyCo2\n FROM #{#entityName} ip WHERE\n      ip.location.id = :location\n  AND ip.incrementCpu IS NOT NULL\n  AND (ip.license IS NULL OR :license = ip.license)\n  AND (ip.type.id IN :types)\n  AND (ip.term.id IN :terms)\n  AND (ip.maxCpu  IS NULL OR ip.maxCpu >=:cpu)\n  AND (ip.maxGpu  IS NULL OR ip.maxGpu >=:gpu)\n  AND (ip.maxRam  IS NULL OR ip.maxRam >=:ram)\n  AND (ip.initialCost IS NULL OR :initialCost >= ip.initialCost)\n  AND (ip.maxRamRatio IS NULL OR GREATEST(ip.minCpu, :cpu) * ip.maxRamRatio <= :ram)\n  AND ip.os=:os\n  ORDER BY totalCost ASC, totalCo2 ASC, ip.type.id DESC, ip.maxCpu ASC\n")
    public List<Object[]> findLowestDynamicCost(List<Integer> var1, List<Integer> var2, double var3, double var5, double var7, VmOs var9, int var10, double var11, double var13, double var15, String var17, double var18, Pageable var20);

    @Query(value="SELECT ip,\n (  ip.cost\n  + CEIL(GREATEST(ip.minCpu, :cpu) /ip.incrementCpu) * ip.incrementCpu * ip.costCpu\n  + CASE WHEN (ip.incrementGpu IS NULL OR ip.incrementGpu=0.0) THEN 0.0 ELSE (CEIL(GREATEST(ip.minGpu, :gpu) /ip.incrementGpu) * ip.incrementGpu * ip.costGpu) END\n  + CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio,0.0), :ram) /ip.incrementRam) * ip.incrementRam * ip.costRam\n )\n * (CASE WHEN ip.period = 0 THEN CAST(:globalRate AS Double) ELSE (ip.period * CEIL(:duration/ip.period)) END) AS totalCost,\n (  ip.cost\n  + CEIL(GREATEST(ip.minCpu, :cpu) /ip.incrementCpu) * ip.incrementCpu * ip.costCpu\n  + CASE WHEN (ip.incrementGpu IS NULL OR ip.incrementGpu=0.0) THEN 0.0 ELSE (CEIL(GREATEST(ip.minGpu, :gpu) /ip.incrementGpu) * ip.incrementGpu * ip.costGpu) END\n  + CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio,0.0), :ram) /ip.incrementRam) * ip.incrementRam * ip.costRam\n )\n * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE 1.0 END AS monthlyCost,\n\n (  ip.co2\n  + CEIL(GREATEST(ip.minCpu, :cpu) /ip.incrementCpu) * ip.incrementCpu * ip.co2Cpu\n  + CASE WHEN (ip.incrementGpu IS NULL OR ip.incrementGpu=0.0) THEN 0.0 ELSE (CEIL(GREATEST(ip.minGpu, :gpu) /ip.incrementGpu) * ip.incrementGpu * ip.co2Gpu) END\n  + CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio,0.0), :ram) /ip.incrementRam) * ip.incrementRam * ip.co2Ram\n )\n * CASE WHEN ip.period = 0 THEN CAST(:globalRate AS Double) ELSE (ip.period * CEIL(:duration/ip.period)) END AS totalCo2,\n (  ip.co2\n  + CEIL(GREATEST(ip.minCpu, :cpu) /ip.incrementCpu) * ip.incrementCpu * ip.co2Cpu\n  + CASE WHEN (ip.incrementGpu IS NULL OR ip.incrementGpu=0.0) THEN 0.0 ELSE (CEIL(GREATEST(ip.minGpu, :gpu) /ip.incrementGpu) * ip.incrementGpu * ip.co2Gpu) END\n  + CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio,0.0), :ram) /ip.incrementRam) * ip.incrementRam * ip.co2Ram\n )\n * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE 1.0 END AS monthlyCo2\n FROM #{#entityName} ip WHERE\n      ip.location.id = :location\n  AND ip.incrementCpu IS NOT NULL\n  AND (ip.license IS NULL OR :license = ip.license)\n  AND (ip.type.id IN :types)\n  AND (ip.term.id IN :terms)\n  AND (ip.maxCpu  IS NULL OR ip.maxCpu >=:cpu)\n  AND (ip.maxGpu  IS NULL OR ip.maxGpu >=:gpu)\n  AND (ip.maxRam  IS NULL OR ip.maxRam >=:ram)\n  AND (ip.initialCost IS NULL OR :initialCost >= ip.initialCost)\n  AND (ip.maxRamRatio IS NULL OR GREATEST(ip.minCpu, :cpu) * ip.maxRamRatio <= :ram)\n  AND ip.os=:os\n  ORDER BY totalCo2 ASC, totalCost ASC, ip.type.id DESC, ip.maxCpu ASC\n")
    public List<Object[]> findLowestDynamicCo2(List<Integer> var1, List<Integer> var2, double var3, double var5, double var7, VmOs var9, int var10, double var11, double var13, double var15, String var17, double var18, Pageable var20);

    @Query(value="SELECT ip,\n (CASE\n  WHEN ip.period = 0 THEN (ip.cost * :rate * :duration)\n  ELSE (ip.costPeriod * ceil(:duration/ip.period)) END) AS totalCost,\n (CASE\n  WHEN ip.period = 0 THEN (ip.cost * :rate)\n  ELSE ip.cost END) AS monthlyCost,\n (CASE\n  WHEN ip.period = 0 THEN (ip.co2 * :rate * :duration)\n  ELSE (ip.co2Period * ceil(:duration/ip.period)) END) AS totalCo2,\n (CASE\n  WHEN ip.period = 0 THEN (ip.co2 * :rate)\n  ELSE ip.co2 END) AS monthlyCo2\n FROM #{#entityName} ip WHERE\n      ip.location.id = :location\n  AND ip.incrementCpu IS NULL\n  AND (ip.type.id IN :types)\n  AND (ip.term.id IN :terms)\n  AND (ip.initialCost IS NULL OR :initialCost >= ip.initialCost)\n  AND (ip.license IS NULL OR :license = ip.license)\n  AND ip.os=:os\n  ORDER BY totalCost ASC, totalCo2 ASC, ip.type.id DESC\n")
    public List<Object[]> findLowestCost(List<Integer> var1, List<Integer> var2, VmOs var3, int var4, double var5, double var7, String var9, double var10, Pageable var12);

    @Query(value="SELECT ip,\n (CASE\n  WHEN ip.period = 0 THEN (ip.cost * :rate * :duration)\n  ELSE (ip.costPeriod * ceil(:duration/ip.period)) END) AS totalCost,\n (CASE\n  WHEN ip.period = 0 THEN (ip.cost * :rate)\n  ELSE ip.cost END) AS monthlyCost,\n (CASE\n  WHEN ip.period = 0 THEN (ip.co2 * :rate * :duration)\n  ELSE (ip.co2Period * ceil(:duration/ip.period)) END) AS totalCo2,\n (CASE\n  WHEN ip.period = 0 THEN (ip.co2 * :rate)\n  ELSE ip.co2 END) AS monthlyCo2\n FROM #{#entityName} ip WHERE\n      ip.location.id = :location\n  AND ip.incrementCpu IS NULL\n  AND (ip.type.id IN :types)\n  AND (ip.term.id IN :terms)\n  AND (ip.initialCost IS NULL OR :initialCost >= ip.initialCost)\n  AND (ip.license IS NULL OR :license = ip.license)\n  AND ip.os=:os\n  ORDER BY totalCo2 ASC, totalCost ASC, ip.type.id DESC\n")
    public List<Object[]> findLowestCo2(List<Integer> var1, List<Integer> var2, VmOs var3, int var4, double var5, double var7, String var9, double var10, Pageable var12);
}

