/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.dao;

import java.util.List;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheResult;
import org.ligoj.app.plugin.prov.model.ProvLocation;
import org.ligoj.bootstrap.core.dao.RestRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

public interface ProvLocationRepository
extends RestRepository<ProvLocation, Integer> {
    @Query(value="SELECT pl FROM ProvLocation pl INNER JOIN pl.node n WHERE (:node = n.id OR :node LIKE CONCAT(n.id, ':%')) AND EXISTS (SELECT 1 FROM ProvInstancePrice ip WHERE ip.location = pl)")
    public List<ProvLocation> findAll(String var1);

    @Query(value="SELECT pl FROM ProvLocation pl INNER JOIN pl.node n WHERE (:node = n.id OR :node LIKE CONCAT(n.id, ':%')) AND UPPER(pl.name) = UPPER(:name)")
    public ProvLocation findByName(String var1, String var2);

    @CacheResult(cacheName="prov-location")
    @Query(value="SELECT pl.id FROM ProvLocation pl INNER JOIN pl.node n WHERE (:node = n.id OR :node LIKE CONCAT(n.id, ':%')) AND UPPER(pl.name) = UPPER(:name)")
    public Integer toId(@CacheKey String var1, @CacheKey String var2);

    @Modifying
    @Query(value="UPDATE ProvLocation SET preferred = false WHERE node.id = :node AND preferred = true ")
    public void unsetPreferredLocation(String var1);

    @Modifying
    @Query(value="UPDATE ProvLocation SET preferred = true WHERE node.id = :node AND id = :preferredId ")
    public void setPreferredLocation(String var1, int var2);
}

