/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.dao;

import java.util.List;
import org.ligoj.app.plugin.prov.model.ProvQuote;
import org.ligoj.bootstrap.core.dao.RestRepository;
import org.springframework.data.jpa.repository.Query;

public interface ProvQuoteRepository
extends RestRepository<ProvQuote, Integer> {
    @Query(value="SELECT q, COALESCE(COUNT(qi.id),0), COALESCE(SUM(qi.cpu*qi.minQuantity),0), COALESCE(SUM(qi.gpu*qi.minQuantity),0), COALESCE(SUM(qi.ram*qi.minQuantity),0), COALESCE(SUM(CASE qi.internet WHEN 0 THEN qi.minQuantity ELSE 0 END),0) FROM ProvQuote q LEFT JOIN q.instances AS qi LEFT JOIN qi.price AS ip LEFT JOIN ip.type AS i WHERE q.subscription.id = :subscription GROUP BY q")
    public List<Object[]> getComputeSummary(int var1);

    @Query(value="SELECT q, COALESCE(COUNT(qi.id),0), COALESCE(SUM(qi.cpu*qi.minQuantity),0),COALESCE(SUM(qi.gpu*qi.minQuantity),0), COALESCE(SUM(qi.ram*qi.minQuantity),0), COALESCE(SUM(CASE qi.internet WHEN 0 THEN qi.minQuantity ELSE 0 END),0) FROM ProvQuote q LEFT JOIN q.databases AS qi LEFT JOIN qi.price AS ip LEFT JOIN ip.type AS i WHERE q.subscription.id = :subscription GROUP BY q")
    public List<Object[]> getDatabaseSummary(int var1);

    @Query(value="SELECT q, COALESCE(COUNT(qi.id),0), COALESCE(SUM(qi.cpu*qi.minQuantity),0),COALESCE(SUM(qi.gpu*qi.minQuantity),0), COALESCE(SUM(qi.ram*qi.minQuantity),0), COALESCE(SUM(CASE qi.internet WHEN 0 THEN qi.minQuantity ELSE 0 END),0) FROM ProvQuote q LEFT JOIN q.containers AS qi LEFT JOIN qi.price AS ip LEFT JOIN ip.type AS i WHERE q.subscription.id = :subscription GROUP BY q")
    public List<Object[]> getContainerSummary(int var1);

    @Query(value="SELECT q, COALESCE(COUNT(qi.id),0), COALESCE(SUM(qi.nbRequests),0) FROM ProvQuote q LEFT JOIN q.functions AS qi LEFT JOIN qi.price AS ip LEFT JOIN ip.type AS i WHERE q.subscription.id = :subscription GROUP BY q")
    public List<Object[]> getFunctionSummary(int var1);

    @Query(value="SELECT q, COALESCE(SUM(CASE WHEN qs.id IS NULL THEN 0 ELSE COALESCE(qi.minQuantity,1) END),0), COALESCE(SUM(qs.size*COALESCE(qi.minQuantity,1)),0) FROM ProvQuote q LEFT JOIN q.storages AS qs LEFT JOIN qs.quoteInstance AS qi  LEFT JOIN qs.quoteContainer AS qc WHERE q.subscription.id = :subscription GROUP BY q")
    public List<Object[]> getStorageSummary(int var1);

    @Query(value="FROM ProvQuote AS q\nLEFT JOIN FETCH q.instances AS qi\nLEFT JOIN FETCH qi.price AS ip\nLEFT JOIN FETCH ip.type AS i\nLEFT JOIN FETCH ip.location AS il\nLEFT JOIN FETCH ip.term\nLEFT JOIN FETCH q.usage WHERE q.subscription.id = :subscription\n")
    public ProvQuote getCompute(int var1);

    @Query(value="SELECT COUNT (q) FROM ProvQuote AS q INNER JOIN q.subscription AS s WHERE s.node.id = :node OR s.node.id LIKE CONCAT(:node, ':%')")
    public long countByNode(String var1);
}

