/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.dao;

import java.util.List;
import org.ligoj.app.plugin.prov.model.ProvStorageOptimized;
import org.ligoj.app.plugin.prov.model.ProvStoragePrice;
import org.ligoj.app.plugin.prov.model.Rate;
import org.ligoj.bootstrap.core.dao.RestRepository;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;

public interface ProvStoragePriceRepository
extends RestRepository<ProvStoragePrice, Integer> {
    @Query(value="FROM ProvStoragePrice WHERE location.name = :location AND type.node.id = :node")
    public List<ProvStoragePrice> findAll(String var1, String var2);

    @Query(value="SELECT sp,\n (sp.cost + (CASE WHEN :size < st.minimal THEN st.minimal\n                  WHEN st.increment IS NULL THEN :size\n                  ELSE (CEIL(:size / st.increment)*st.increment)\n             END) * sp.costGb) AS cost,\n st.latency AS latency,\n st.code AS code\n FROM ProvStoragePrice AS sp INNER JOIN sp.type st\n WHERE (:node = st.node.id OR :node LIKE CONCAT(st.node.id,'%'))\n AND (sp.location.id = :location AND (:qLocation = 0 OR (sp.location.id = :qLocation)))\n AND (st.latency >= :latency)\n AND (CAST(:optimized as string) IS NULL OR st.optimized = :optimized)\n AND (st.maximal IS NULL OR st.maximal >= :size)\n AND (:instanceType = ''\n \tOR (  (st.notInstanceType IS NULL OR :instanceType NOT LIKE st.notInstanceType)\n \t  AND (st.instanceType IS NOT NULL AND :instanceType LIKE st.instanceType)))\n AND (:containerType = ''\n \tOR (  (st.notContainerType IS NULL OR :containerType NOT LIKE st.notContainerType)\n \t  AND (st.containerType IS NOT NULL AND :containerType LIKE st.containerType)))\n AND (:functionType = ''\n \tOR (  (st.notFunctionType IS NULL OR :functionType NOT LIKE st.notFunctionType)\n \t  AND (st.functionType IS NOT NULL AND :functionType LIKE st.functionType)))\n AND (:databaseType = ''\n \tOR (  (st.notDatabaseType IS NULL OR :databaseType NOT LIKE st.notDatabaseType)\n \t  AND (st.databaseType IS NOT NULL AND :databaseType LIKE st.databaseType)\n \t  AND ((st.engine IS NULL AND :databaseStorageEngine = '') OR (st.engine = :databaseStorageEngine))))\n ORDER BY cost ASC, latency DESC, code")
    public List<Object[]> findLowestPrice(String var1, double var2, Rate var4, String var5, String var6, String var7, String var8, String var9, ProvStorageOptimized var10, int var11, int var12, Pageable var13);

    @Query(value="SELECT sp FROM ProvStoragePrice sp, Subscription s INNER JOIN s.node AS sn INNER JOIN sp.location AS loc INNER JOIN sp.type AS st WHERE s.id = :subscription AND sn.id LIKE CONCAT(st.node.id, ':%') AND st.code = :type  AND loc.id = :location")
    public ProvStoragePrice findByTypeCode(int var1, String var2, int var3);

    @Query(value="FROM ProvStoragePrice e INNER JOIN FETCH e.type t INNER JOIN e.location l WHERE                       (:location = '' OR l.name = :location) AND t.node.id = :node             ")
    public List<ProvStoragePrice> findByLocation(String var1, String var2);

    @Query(value="FROM ProvStoragePrice e INNER JOIN FETCH e.type t INNER JOIN FETCH e.location l WHERE                       t.code = :type AND t.node.id = :node             ")
    public List<ProvStoragePrice> findByTypeName(String var1, String var2);
}

