/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.PositiveOrZero;
import lombok.Generated;
import org.hibernate.annotations.ColumnDefault;
import org.ligoj.app.plugin.prov.model.AbstractPrice;
import org.ligoj.app.plugin.prov.model.Costed;
import org.ligoj.app.plugin.prov.model.ProvLocation;
import org.ligoj.app.plugin.prov.model.ProvQuote;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.bootstrap.core.model.AbstractDescribedEntity;

@MappedSuperclass
public abstract class AbstractQuote<P extends AbstractPrice<?>>
extends AbstractDescribedEntity<Integer>
implements Costed {
    private static final long serialVersionUID = 1L;
    @NotNull
    @PositiveOrZero
    private double cost;
    @NotNull
    @PositiveOrZero
    private double maxCost;
    @NotNull
    @PositiveOrZero
    private double initialCost = 0.0;
    @NotNull
    @PositiveOrZero
    private double maxInitialCost = 0.0;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JsonIgnore
    private ProvQuote configuration;
    @ManyToOne
    private ProvLocation location;
    @NotNull
    @PositiveOrZero
    @ColumnDefault(value="0")
    private double co2 = 0.0;
    @NotNull
    @PositiveOrZero
    @ColumnDefault(value="0")
    private double maxCo2 = 0.0;

    public abstract P getPrice();

    public abstract void setPrice(P var1);

    @Transient
    @JsonIgnore
    public ProvLocation getResolvedLocation() {
        return this.location == null ? this.getConfiguration().getLocation() : this.location;
    }

    public abstract ResourceType getResourceType();

    @Override
    @Generated
    public double getCost() {
        return this.cost;
    }

    @Override
    @Generated
    public double getMaxCost() {
        return this.maxCost;
    }

    @Override
    @Generated
    public double getInitialCost() {
        return this.initialCost;
    }

    @Override
    @Generated
    public double getMaxInitialCost() {
        return this.maxInitialCost;
    }

    @Generated
    public ProvQuote getConfiguration() {
        return this.configuration;
    }

    @Generated
    public ProvLocation getLocation() {
        return this.location;
    }

    @Override
    @Generated
    public double getCo2() {
        return this.co2;
    }

    @Override
    @Generated
    public double getMaxCo2() {
        return this.maxCo2;
    }

    @Generated
    public void setCost(double cost) {
        this.cost = cost;
    }

    @Generated
    public void setMaxCost(double maxCost) {
        this.maxCost = maxCost;
    }

    @Generated
    public void setInitialCost(double initialCost) {
        this.initialCost = initialCost;
    }

    @Generated
    public void setMaxInitialCost(double maxInitialCost) {
        this.maxInitialCost = maxInitialCost;
    }

    @JsonIgnore
    @Generated
    public void setConfiguration(ProvQuote configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setLocation(ProvLocation location) {
        this.location = location;
    }

    @Generated
    public void setCo2(double co2) {
        this.co2 = co2;
    }

    @Generated
    public void setMaxCo2(double maxCo2) {
        this.maxCo2 = maxCo2;
    }

    @Generated
    protected AbstractQuote() {
    }
}

