/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.ligoj.app.plugin.prov.model.AbstractQuote;
import org.ligoj.app.plugin.prov.model.AbstractTermPriceVm;
import org.ligoj.app.plugin.prov.model.InternetAccess;
import org.ligoj.app.plugin.prov.model.ProvBudget;
import org.ligoj.app.plugin.prov.model.ProvOptimizer;
import org.ligoj.app.plugin.prov.model.ProvQuoteStorage;
import org.ligoj.app.plugin.prov.model.ProvUsage;
import org.ligoj.app.plugin.prov.model.QuoteVm;
import org.ligoj.app.plugin.prov.model.Rate;
import org.ligoj.app.plugin.prov.model.ResourceScope;
import org.ligoj.bootstrap.core.INamableBean;
import org.ligoj.bootstrap.core.model.ToIdSerializer;

@MappedSuperclass
public abstract class AbstractQuoteVm<P extends AbstractTermPriceVm<?>>
extends AbstractQuote<P>
implements QuoteVm,
ResourceScope {
    private static final long serialVersionUID = 1L;
    public static final String LICENSE_INCLUDED = "INCLUDED";
    @PositiveOrZero
    private double cpu;
    @PositiveOrZero
    private Double cpuMax;
    @PositiveOrZero
    private double gpu;
    @PositiveOrZero
    private Double gpuMax;
    @PositiveOrZero
    private int ram;
    @PositiveOrZero
    private Integer ramMax;
    private String workload;
    private String processor;
    private Boolean physical;
    private Boolean edge;
    @NotNull
    private InternetAccess internet = InternetAccess.PUBLIC;
    @NotNull
    @PositiveOrZero
    private int minQuantity = 1;
    @PositiveOrZero
    private Integer maxQuantity = 1;
    @ManyToOne
    @JsonSerialize(using=ToIdSerializer.class)
    private ProvUsage usage;
    @ManyToOne
    @JsonSerialize(using=ToIdSerializer.class)
    private ProvBudget budget;
    @ManyToOne
    @JsonSerialize(using=ToIdSerializer.class)
    private ProvOptimizer optimizer;
    private String license;
    private boolean ephemeral;
    private boolean autoScale;
    @Enumerated(value=EnumType.ORDINAL)
    private Rate cpuRate;
    @Enumerated(value=EnumType.ORDINAL)
    private Rate gpuRate;
    @Enumerated(value=EnumType.ORDINAL)
    private Rate networkRate;
    @Enumerated(value=EnumType.ORDINAL)
    private Rate storageRate;
    @Enumerated(value=EnumType.ORDINAL)
    private Rate ramRate;

    @Override
    @JsonIgnore
    public boolean isUnboundCost() {
        return this.maxQuantity == null;
    }

    public abstract List<ProvQuoteStorage> getStorages();

    @JsonIgnore
    public ProvUsage getResolvedUsage() {
        return this.usage == null ? this.getConfiguration().getUsage() : this.usage;
    }

    @JsonIgnore
    public ProvBudget getResolvedBudget() {
        return this.budget == null ? this.getConfiguration().getBudget() : this.budget;
    }

    @JsonIgnore
    public ProvOptimizer getResolvedOptimizer() {
        return this.optimizer == null ? this.getConfiguration().getOptimizer() : this.optimizer;
    }

    @Override
    @JsonIgnore
    public String getUsageName() {
        return Optional.ofNullable(this.getResolvedUsage()).map(INamableBean::getName).orElse(null);
    }

    @Override
    @JsonIgnore
    public String getBudgetName() {
        return Optional.ofNullable(this.getResolvedBudget()).map(INamableBean::getName).orElse(null);
    }

    @Override
    @JsonIgnore
    public String getOptimizerName() {
        return Optional.ofNullable(this.getResolvedOptimizer()).map(INamableBean::getName).orElse(null);
    }

    @Override
    public String getLocationName() {
        return this.getResolvedLocation().getName();
    }

    @Override
    public abstract P getPrice();

    @Override
    @Generated
    public double getCpu() {
        return this.cpu;
    }

    @Override
    @Generated
    public Double getCpuMax() {
        return this.cpuMax;
    }

    @Override
    @Generated
    public double getGpu() {
        return this.gpu;
    }

    @Override
    @Generated
    public Double getGpuMax() {
        return this.gpuMax;
    }

    @Override
    @Generated
    public int getRam() {
        return this.ram;
    }

    @Override
    @Generated
    public Integer getRamMax() {
        return this.ramMax;
    }

    @Override
    @Generated
    public String getWorkload() {
        return this.workload;
    }

    @Override
    @Generated
    public String getProcessor() {
        return this.processor;
    }

    @Override
    @Generated
    public Boolean getPhysical() {
        return this.physical;
    }

    @Override
    @Generated
    public Boolean getEdge() {
        return this.edge;
    }

    @Generated
    public InternetAccess getInternet() {
        return this.internet;
    }

    @Generated
    public int getMinQuantity() {
        return this.minQuantity;
    }

    @Generated
    public Integer getMaxQuantity() {
        return this.maxQuantity;
    }

    @Override
    @Generated
    public ProvUsage getUsage() {
        return this.usage;
    }

    @Override
    @Generated
    public ProvBudget getBudget() {
        return this.budget;
    }

    @Override
    @Generated
    public ProvOptimizer getOptimizer() {
        return this.optimizer;
    }

    @Override
    @Generated
    public String getLicense() {
        return this.license;
    }

    @Override
    @Generated
    public boolean isEphemeral() {
        return this.ephemeral;
    }

    @Override
    @Generated
    public boolean isAutoScale() {
        return this.autoScale;
    }

    @Override
    @Generated
    public Rate getCpuRate() {
        return this.cpuRate;
    }

    @Override
    @Generated
    public Rate getGpuRate() {
        return this.gpuRate;
    }

    @Override
    @Generated
    public Rate getNetworkRate() {
        return this.networkRate;
    }

    @Override
    @Generated
    public Rate getStorageRate() {
        return this.storageRate;
    }

    @Override
    @Generated
    public Rate getRamRate() {
        return this.ramRate;
    }

    @Generated
    public void setCpu(double cpu) {
        this.cpu = cpu;
    }

    @Generated
    public void setCpuMax(Double cpuMax) {
        this.cpuMax = cpuMax;
    }

    @Generated
    public void setGpu(double gpu) {
        this.gpu = gpu;
    }

    @Generated
    public void setGpuMax(Double gpuMax) {
        this.gpuMax = gpuMax;
    }

    @Generated
    public void setRam(int ram) {
        this.ram = ram;
    }

    @Generated
    public void setRamMax(Integer ramMax) {
        this.ramMax = ramMax;
    }

    @Generated
    public void setWorkload(String workload) {
        this.workload = workload;
    }

    @Generated
    public void setProcessor(String processor) {
        this.processor = processor;
    }

    @Generated
    public void setPhysical(Boolean physical) {
        this.physical = physical;
    }

    @Generated
    public void setEdge(Boolean edge) {
        this.edge = edge;
    }

    @Generated
    public void setInternet(InternetAccess internet) {
        this.internet = internet;
    }

    @Generated
    public void setMinQuantity(int minQuantity) {
        this.minQuantity = minQuantity;
    }

    @Generated
    public void setMaxQuantity(Integer maxQuantity) {
        this.maxQuantity = maxQuantity;
    }

    @Override
    @Generated
    public void setUsage(ProvUsage usage) {
        this.usage = usage;
    }

    @Override
    @Generated
    public void setBudget(ProvBudget budget) {
        this.budget = budget;
    }

    @Override
    @Generated
    public void setOptimizer(ProvOptimizer optimizer) {
        this.optimizer = optimizer;
    }

    @Generated
    public void setLicense(String license) {
        this.license = license;
    }

    @Generated
    public void setEphemeral(boolean ephemeral) {
        this.ephemeral = ephemeral;
    }

    @Generated
    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    @Generated
    public void setCpuRate(Rate cpuRate) {
        this.cpuRate = cpuRate;
    }

    @Generated
    public void setGpuRate(Rate gpuRate) {
        this.gpuRate = gpuRate;
    }

    @Generated
    public void setNetworkRate(Rate networkRate) {
        this.networkRate = networkRate;
    }

    @Generated
    public void setStorageRate(Rate storageRate) {
        this.storageRate = storageRate;
    }

    @Generated
    public void setRamRate(Rate ramRate) {
        this.ramRate = ramRate;
    }

    @Generated
    protected AbstractQuoteVm() {
    }
}

