/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.hibernate.annotations.ColumnDefault;
import org.ligoj.app.model.PluginConfiguration;
import org.ligoj.app.model.Subscription;
import org.ligoj.app.plugin.prov.ProvisioningService;
import org.ligoj.app.plugin.prov.model.Costed;
import org.ligoj.app.plugin.prov.model.ProvBudget;
import org.ligoj.app.plugin.prov.model.ProvCurrency;
import org.ligoj.app.plugin.prov.model.ProvLocation;
import org.ligoj.app.plugin.prov.model.ProvOptimizer;
import org.ligoj.app.plugin.prov.model.ProvQuoteContainer;
import org.ligoj.app.plugin.prov.model.ProvQuoteDatabase;
import org.ligoj.app.plugin.prov.model.ProvQuoteFunction;
import org.ligoj.app.plugin.prov.model.ProvQuoteInstance;
import org.ligoj.app.plugin.prov.model.ProvQuoteStorage;
import org.ligoj.app.plugin.prov.model.ProvQuoteSupport;
import org.ligoj.app.plugin.prov.model.ProvTag;
import org.ligoj.app.plugin.prov.model.ProvUsage;
import org.ligoj.app.plugin.prov.model.ReservationMode;
import org.ligoj.app.plugin.prov.model.ResourceScope;
import org.ligoj.bootstrap.core.model.AbstractDescribedAuditedEntity;

@Entity
@Table(name="LIGOJ_PROV_QUOTE")
public class ProvQuote
extends AbstractDescribedAuditedEntity<Integer>
implements PluginConfiguration,
Costed,
ResourceScope {
    private static final long serialVersionUID = 1L;
    @NotNull
    @PositiveOrZero
    private double cost = 0.0;
    @NotNull
    @PositiveOrZero
    private double maxCost = 0.0;
    @PositiveOrZero
    private double initialCost = 0.0;
    @PositiveOrZero
    private double maxInitialCost = 0.0;
    @PositiveOrZero
    @NotNull
    private Double costSupport = 0.0;
    @PositiveOrZero
    @NotNull
    private Double maxCostSupport = 0.0;
    @PositiveOrZero
    @NotNull
    private Double costNoSupport = 0.0;
    @PositiveOrZero
    @NotNull
    private Double maxCostNoSupport = 0.0;
    @NotNull
    @PositiveOrZero
    private Integer unboundCostCounter = 0;
    @NotNull
    @ManyToOne
    @JsonIgnore
    private Subscription subscription;
    @OneToMany(mappedBy="configuration", cascade={CascadeType.REMOVE})
    @JsonIgnore
    private List<ProvQuoteInstance> instances;
    @OneToMany(mappedBy="configuration", cascade={CascadeType.REMOVE})
    @JsonIgnore
    private List<ProvQuoteDatabase> databases;
    @OneToMany(mappedBy="configuration", cascade={CascadeType.REMOVE})
    @JsonIgnore
    private List<ProvQuoteContainer> containers;
    @OneToMany(mappedBy="configuration", cascade={CascadeType.REMOVE})
    @JsonIgnore
    private List<ProvQuoteFunction> functions;
    @OneToMany(mappedBy="configuration", cascade={CascadeType.REMOVE})
    @JsonIgnore
    private List<ProvUsage> usages = new ArrayList<ProvUsage>();
    @OneToMany(mappedBy="configuration", cascade={CascadeType.REMOVE})
    @JsonIgnore
    private List<ProvBudget> budgets = new ArrayList<ProvBudget>();
    @OneToMany(mappedBy="configuration", cascade={CascadeType.REMOVE})
    @JsonIgnore
    private List<ProvOptimizer> optimizers = new ArrayList<ProvOptimizer>();
    @OneToMany(mappedBy="configuration", cascade={CascadeType.REMOVE})
    @JsonIgnore
    private List<ProvQuoteStorage> storages;
    @OneToMany(mappedBy="configuration", cascade={CascadeType.REMOVE})
    @JsonIgnore
    private List<ProvQuoteSupport> supports = new ArrayList<ProvQuoteSupport>();
    @OneToMany(mappedBy="configuration", cascade={CascadeType.REMOVE})
    @JsonIgnore
    private List<ProvTag> tags;
    private String uiSettings;
    @ManyToOne
    @NotNull
    private ProvLocation location;
    @ManyToOne
    private ProvUsage usage;
    @ManyToOne
    private ProvBudget budget;
    @ManyToOne
    private ProvOptimizer optimizer;
    private String license;
    @Min(value=50L)
    @Max(value=150L)
    private @Min(value=50L) @Max(value=150L) Integer ramAdjustedRate = 100;
    private ReservationMode reservationMode = ReservationMode.RESERVED;
    @ManyToOne
    private ProvCurrency currency;
    private String processor;
    private Boolean physical;
    @Transient
    @JsonIgnore
    private transient ProvisioningService service;
    @Transient
    @JsonIgnore
    private final Object leanLock = new Object();
    private Boolean leanOnChange = false;
    @NotNull
    @PositiveOrZero
    @ColumnDefault(value="0")
    private double co2 = 0.0;
    @NotNull
    @PositiveOrZero
    @ColumnDefault(value="0")
    private double maxCo2 = 0.0;

    @Override
    @JsonIgnore
    public boolean isUnboundCost() {
        return this.unboundCostCounter > 0;
    }

    @JsonIgnore
    public ProvQuote getConfiguration() {
        return this;
    }

    @Override
    @Generated
    public double getCost() {
        return this.cost;
    }

    @Override
    @Generated
    public double getMaxCost() {
        return this.maxCost;
    }

    @Override
    @Generated
    public double getInitialCost() {
        return this.initialCost;
    }

    @Override
    @Generated
    public double getMaxInitialCost() {
        return this.maxInitialCost;
    }

    @Generated
    public Double getCostSupport() {
        return this.costSupport;
    }

    @Generated
    public Double getMaxCostSupport() {
        return this.maxCostSupport;
    }

    @Generated
    public Double getCostNoSupport() {
        return this.costNoSupport;
    }

    @Generated
    public Double getMaxCostNoSupport() {
        return this.maxCostNoSupport;
    }

    @Generated
    public Integer getUnboundCostCounter() {
        return this.unboundCostCounter;
    }

    @Generated
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Generated
    public List<ProvQuoteInstance> getInstances() {
        return this.instances;
    }

    @Generated
    public List<ProvQuoteDatabase> getDatabases() {
        return this.databases;
    }

    @Generated
    public List<ProvQuoteContainer> getContainers() {
        return this.containers;
    }

    @Generated
    public List<ProvQuoteFunction> getFunctions() {
        return this.functions;
    }

    @Generated
    public List<ProvUsage> getUsages() {
        return this.usages;
    }

    @Generated
    public List<ProvBudget> getBudgets() {
        return this.budgets;
    }

    @Generated
    public List<ProvOptimizer> getOptimizers() {
        return this.optimizers;
    }

    @Generated
    public List<ProvQuoteStorage> getStorages() {
        return this.storages;
    }

    @Generated
    public List<ProvQuoteSupport> getSupports() {
        return this.supports;
    }

    @Generated
    public List<ProvTag> getTags() {
        return this.tags;
    }

    @Generated
    public String getUiSettings() {
        return this.uiSettings;
    }

    @Generated
    public ProvLocation getLocation() {
        return this.location;
    }

    @Override
    @Generated
    public ProvUsage getUsage() {
        return this.usage;
    }

    @Override
    @Generated
    public ProvBudget getBudget() {
        return this.budget;
    }

    @Override
    @Generated
    public ProvOptimizer getOptimizer() {
        return this.optimizer;
    }

    @Generated
    public String getLicense() {
        return this.license;
    }

    @Generated
    public Integer getRamAdjustedRate() {
        return this.ramAdjustedRate;
    }

    @Generated
    public ReservationMode getReservationMode() {
        return this.reservationMode;
    }

    @Generated
    public ProvCurrency getCurrency() {
        return this.currency;
    }

    @Generated
    public String getProcessor() {
        return this.processor;
    }

    @Generated
    public Boolean getPhysical() {
        return this.physical;
    }

    @Generated
    public ProvisioningService getService() {
        return this.service;
    }

    @Generated
    public Object getLeanLock() {
        return this.leanLock;
    }

    @Generated
    public Boolean getLeanOnChange() {
        return this.leanOnChange;
    }

    @Override
    @Generated
    public double getCo2() {
        return this.co2;
    }

    @Override
    @Generated
    public double getMaxCo2() {
        return this.maxCo2;
    }

    @Generated
    public void setCost(double cost) {
        this.cost = cost;
    }

    @Generated
    public void setMaxCost(double maxCost) {
        this.maxCost = maxCost;
    }

    @Generated
    public void setInitialCost(double initialCost) {
        this.initialCost = initialCost;
    }

    @Generated
    public void setMaxInitialCost(double maxInitialCost) {
        this.maxInitialCost = maxInitialCost;
    }

    @Generated
    public void setCostSupport(Double costSupport) {
        this.costSupport = costSupport;
    }

    @Generated
    public void setMaxCostSupport(Double maxCostSupport) {
        this.maxCostSupport = maxCostSupport;
    }

    @Generated
    public void setCostNoSupport(Double costNoSupport) {
        this.costNoSupport = costNoSupport;
    }

    @Generated
    public void setMaxCostNoSupport(Double maxCostNoSupport) {
        this.maxCostNoSupport = maxCostNoSupport;
    }

    @Generated
    public void setUnboundCostCounter(Integer unboundCostCounter) {
        this.unboundCostCounter = unboundCostCounter;
    }

    @JsonIgnore
    @Generated
    public void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    @JsonIgnore
    @Generated
    public void setInstances(List<ProvQuoteInstance> instances) {
        this.instances = instances;
    }

    @JsonIgnore
    @Generated
    public void setDatabases(List<ProvQuoteDatabase> databases) {
        this.databases = databases;
    }

    @JsonIgnore
    @Generated
    public void setContainers(List<ProvQuoteContainer> containers) {
        this.containers = containers;
    }

    @JsonIgnore
    @Generated
    public void setFunctions(List<ProvQuoteFunction> functions) {
        this.functions = functions;
    }

    @JsonIgnore
    @Generated
    public void setUsages(List<ProvUsage> usages) {
        this.usages = usages;
    }

    @JsonIgnore
    @Generated
    public void setBudgets(List<ProvBudget> budgets) {
        this.budgets = budgets;
    }

    @JsonIgnore
    @Generated
    public void setOptimizers(List<ProvOptimizer> optimizers) {
        this.optimizers = optimizers;
    }

    @JsonIgnore
    @Generated
    public void setStorages(List<ProvQuoteStorage> storages) {
        this.storages = storages;
    }

    @JsonIgnore
    @Generated
    public void setSupports(List<ProvQuoteSupport> supports) {
        this.supports = supports;
    }

    @JsonIgnore
    @Generated
    public void setTags(List<ProvTag> tags) {
        this.tags = tags;
    }

    @Generated
    public void setUiSettings(String uiSettings) {
        this.uiSettings = uiSettings;
    }

    @Generated
    public void setLocation(ProvLocation location) {
        this.location = location;
    }

    @Override
    @Generated
    public void setUsage(ProvUsage usage) {
        this.usage = usage;
    }

    @Override
    @Generated
    public void setBudget(ProvBudget budget) {
        this.budget = budget;
    }

    @Override
    @Generated
    public void setOptimizer(ProvOptimizer optimizer) {
        this.optimizer = optimizer;
    }

    @Generated
    public void setLicense(String license) {
        this.license = license;
    }

    @Generated
    public void setRamAdjustedRate(Integer ramAdjustedRate) {
        this.ramAdjustedRate = ramAdjustedRate;
    }

    @Generated
    public void setReservationMode(ReservationMode reservationMode) {
        this.reservationMode = reservationMode;
    }

    @Generated
    public void setCurrency(ProvCurrency currency) {
        this.currency = currency;
    }

    @Generated
    public void setProcessor(String processor) {
        this.processor = processor;
    }

    @Generated
    public void setPhysical(Boolean physical) {
        this.physical = physical;
    }

    @JsonIgnore
    @Generated
    public void setService(ProvisioningService service) {
        this.service = service;
    }

    @Generated
    public void setLeanOnChange(Boolean leanOnChange) {
        this.leanOnChange = leanOnChange;
    }

    @Generated
    public void setCo2(double co2) {
        this.co2 = co2;
    }

    @Generated
    public void setMaxCo2(double maxCo2) {
        this.maxCo2 = maxCo2;
    }
}

