/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.List;
import lombok.Generated;
import org.ligoj.app.plugin.prov.model.AbstractQuoteVm;
import org.ligoj.app.plugin.prov.model.ProvFunctionPrice;
import org.ligoj.app.plugin.prov.model.ProvQuoteStorage;
import org.ligoj.app.plugin.prov.model.QuoteFunction;
import org.ligoj.app.plugin.prov.model.ResourceType;

@Entity
@Table(name="LIGOJ_PROV_QUOTE_FUNCTION", uniqueConstraints={@UniqueConstraint(columnNames={"name", "configuration"})})
public class ProvQuoteFunction
extends AbstractQuoteVm<ProvFunctionPrice>
implements QuoteFunction {
    private static final long serialVersionUID = 1L;
    @NotNull
    @NotBlank
    private String runtime = "Python";
    @Positive
    private int duration = 100;
    @Positive
    private double nbRequests = 1.0;
    @PositiveOrZero
    private double concurrency = 0.0;
    @JsonIgnore
    @OneToMany(mappedBy="quoteFunction")
    private List<ProvQuoteStorage> storages;
    @NotNull
    @ManyToOne
    private ProvFunctionPrice price;

    @Override
    public ResourceType getResourceType() {
        return ResourceType.FUNCTION;
    }

    @Override
    @Generated
    public String getRuntime() {
        return this.runtime;
    }

    @Override
    @Generated
    public int getDuration() {
        return this.duration;
    }

    @Override
    @Generated
    public double getNbRequests() {
        return this.nbRequests;
    }

    @Override
    @Generated
    public double getConcurrency() {
        return this.concurrency;
    }

    @Override
    @Generated
    public List<ProvQuoteStorage> getStorages() {
        return this.storages;
    }

    @Override
    @Generated
    public ProvFunctionPrice getPrice() {
        return this.price;
    }

    @Generated
    public void setRuntime(String runtime) {
        this.runtime = runtime;
    }

    @Generated
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Generated
    public void setNbRequests(double nbRequests) {
        this.nbRequests = nbRequests;
    }

    @Generated
    public void setConcurrency(double concurrency) {
        this.concurrency = concurrency;
    }

    @JsonIgnore
    @Generated
    public void setStorages(List<ProvQuoteStorage> storages) {
        this.storages = storages;
    }

    @Override
    @Generated
    public void setPrice(ProvFunctionPrice price) {
        this.price = price;
    }
}

