/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.ligoj.app.plugin.prov.model.AbstractQuote;
import org.ligoj.app.plugin.prov.model.AbstractQuoteVm;
import org.ligoj.app.plugin.prov.model.ProvQuoteContainer;
import org.ligoj.app.plugin.prov.model.ProvQuoteDatabase;
import org.ligoj.app.plugin.prov.model.ProvQuoteFunction;
import org.ligoj.app.plugin.prov.model.ProvQuoteInstance;
import org.ligoj.app.plugin.prov.model.ProvStorageOptimized;
import org.ligoj.app.plugin.prov.model.ProvStoragePrice;
import org.ligoj.app.plugin.prov.model.QuoteStorage;
import org.ligoj.app.plugin.prov.model.Rate;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.bootstrap.core.INamableBean;
import org.ligoj.bootstrap.core.model.ToIdSerializer;
import org.springframework.data.domain.Persistable;

@Entity
@Table(name="LIGOJ_PROV_QUOTE_STORAGE", uniqueConstraints={@UniqueConstraint(columnNames={"name", "configuration"})})
public class ProvQuoteStorage
extends AbstractQuote<ProvStoragePrice>
implements QuoteStorage {
    private static final long serialVersionUID = 1L;
    @Enumerated(value=EnumType.ORDINAL)
    private Rate latency;
    private ProvStorageOptimized optimized;
    @NotNull
    @Positive
    private int size;
    @Positive
    private Integer sizeMax;
    @ManyToOne(fetch=FetchType.LAZY)
    @JsonSerialize(using=ToIdSerializer.class)
    private ProvQuoteInstance quoteInstance;
    @ManyToOne(fetch=FetchType.LAZY)
    @JsonSerialize(using=ToIdSerializer.class)
    private ProvQuoteContainer quoteContainer;
    @ManyToOne(fetch=FetchType.LAZY)
    @JsonSerialize(using=ToIdSerializer.class)
    private ProvQuoteDatabase quoteDatabase;
    @ManyToOne(fetch=FetchType.LAZY)
    @JsonSerialize(using=ToIdSerializer.class)
    private ProvQuoteFunction quoteFunction;
    private Integer quantity = 1;
    @NotNull
    @ManyToOne
    private ProvStoragePrice price;

    @Override
    public ResourceType getResourceType() {
        return ResourceType.STORAGE;
    }

    @Override
    @JsonIgnore
    public boolean isUnboundCost() {
        return Optional.ofNullable(this.getQuoteResource()).map(AbstractQuoteVm::isUnboundCost).orElse(false);
    }

    @JsonIgnore
    public AbstractQuoteVm<?> getQuoteResource() {
        return (AbstractQuoteVm)ObjectUtils.firstNonNull((Object[])new AbstractQuoteVm[]{this.quoteDatabase, this.quoteInstance, this.quoteContainer, this.quoteFunction});
    }

    @Override
    @JsonIgnore
    public Integer getInstance() {
        return Optional.ofNullable(this.getQuoteInstance()).map(Persistable::getId).orElse(null);
    }

    @Override
    @JsonIgnore
    public Integer getDatabase() {
        return Optional.ofNullable(this.getQuoteDatabase()).map(Persistable::getId).orElse(null);
    }

    @Override
    @JsonIgnore
    public Integer getContainer() {
        return Optional.ofNullable(this.getQuoteContainer()).map(Persistable::getId).orElse(null);
    }

    @Override
    @JsonIgnore
    public Integer getFunction() {
        return Optional.ofNullable(this.getQuoteFunction()).map(Persistable::getId).orElse(null);
    }

    @Override
    @JsonIgnore
    public String getLocationName() {
        return Optional.ofNullable(this.getLocation()).map(INamableBean::getName).orElse(null);
    }

    @Override
    @Generated
    public Rate getLatency() {
        return this.latency;
    }

    @Override
    @Generated
    public ProvStorageOptimized getOptimized() {
        return this.optimized;
    }

    @Override
    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public Integer getSizeMax() {
        return this.sizeMax;
    }

    @Generated
    public ProvQuoteInstance getQuoteInstance() {
        return this.quoteInstance;
    }

    @Generated
    public ProvQuoteContainer getQuoteContainer() {
        return this.quoteContainer;
    }

    @Generated
    public ProvQuoteDatabase getQuoteDatabase() {
        return this.quoteDatabase;
    }

    @Generated
    public ProvQuoteFunction getQuoteFunction() {
        return this.quoteFunction;
    }

    @Generated
    public Integer getQuantity() {
        return this.quantity;
    }

    @Override
    @Generated
    public ProvStoragePrice getPrice() {
        return this.price;
    }

    @Generated
    public void setLatency(Rate latency) {
        this.latency = latency;
    }

    @Generated
    public void setOptimized(ProvStorageOptimized optimized) {
        this.optimized = optimized;
    }

    @Generated
    public void setSize(int size) {
        this.size = size;
    }

    @Generated
    public void setSizeMax(Integer sizeMax) {
        this.sizeMax = sizeMax;
    }

    @Generated
    public void setQuoteInstance(ProvQuoteInstance quoteInstance) {
        this.quoteInstance = quoteInstance;
    }

    @Generated
    public void setQuoteContainer(ProvQuoteContainer quoteContainer) {
        this.quoteContainer = quoteContainer;
    }

    @Generated
    public void setQuoteDatabase(ProvQuoteDatabase quoteDatabase) {
        this.quoteDatabase = quoteDatabase;
    }

    @Generated
    public void setQuoteFunction(ProvQuoteFunction quoteFunction) {
        this.quoteFunction = quoteFunction;
    }

    @Generated
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    @Override
    @Generated
    public void setPrice(ProvStoragePrice price) {
        this.price = price;
    }
}

