/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.quote.database;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.ligoj.app.plugin.prov.AbstractProvQuoteVmResource;
import org.ligoj.app.plugin.prov.UpdatedCost;
import org.ligoj.app.plugin.prov.dao.Optimizer;
import org.ligoj.app.plugin.prov.dao.ProvDatabasePriceRepository;
import org.ligoj.app.plugin.prov.dao.ProvDatabaseTypeRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteDatabaseRepository;
import org.ligoj.app.plugin.prov.model.ProvDatabasePrice;
import org.ligoj.app.plugin.prov.model.ProvDatabaseType;
import org.ligoj.app.plugin.prov.model.ProvInstancePriceTerm;
import org.ligoj.app.plugin.prov.model.ProvQuote;
import org.ligoj.app.plugin.prov.model.ProvQuoteDatabase;
import org.ligoj.app.plugin.prov.model.QuoteDatabase;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.app.plugin.prov.quote.database.QuoteDatabaseEditionVo;
import org.ligoj.app.plugin.prov.quote.database.QuoteDatabaseLookup;
import org.ligoj.app.plugin.prov.quote.database.QuoteDatabaseQuery;
import org.ligoj.bootstrap.core.json.TableItem;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/prov")
@Produces(value={"application/json"})
@Transactional
public class ProvQuoteDatabaseResource
extends AbstractProvQuoteVmResource<ProvDatabaseType, ProvDatabasePrice, ProvQuoteDatabase, QuoteDatabaseEditionVo, QuoteDatabaseLookup, QuoteDatabase> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProvQuoteDatabaseResource.class);
    private static final String ENGINE_ORACLE = "ORACLE";
    @Autowired
    private ProvDatabasePriceRepository ipRepository;
    @Autowired
    private ProvQuoteDatabaseRepository qiRepository;
    @Autowired
    private ProvDatabaseTypeRepository itRepository;

    @Override
    protected ResourceType getType() {
        return ResourceType.DATABASE;
    }

    @Override
    @POST
    @Path(value="database")
    @Consumes(value={"application/json"})
    public UpdatedCost create(QuoteDatabaseEditionVo vo) {
        return this.saveOrUpdate(new ProvQuoteDatabase(), vo);
    }

    @Override
    @PUT
    @Path(value="database")
    @Consumes(value={"application/json"})
    public UpdatedCost update(QuoteDatabaseEditionVo vo) {
        return super.update(vo);
    }

    @Override
    protected void saveOrUpdateSpec(ProvQuoteDatabase entity, QuoteDatabaseEditionVo vo) {
        this.checkAttribute("engine", entity.getPrice().getEngine(), vo.getEngine());
        this.checkAttribute("edition", entity.getPrice().getEdition(), vo.getEdition());
        entity.setEngine(entity.getPrice().getEngine());
        entity.setEdition(entity.getPrice().getEdition());
    }

    protected void checkAttribute(String name, String pQuote, String vPrice) {
        if (!Strings.CI.equals(pQuote, vPrice)) {
            log.warn("Attempt to create a database with an incompatible {} {} with catalog {} {}", new Object[]{name, pQuote, name, vPrice});
            throw new ValidationJsonException(name, (Serializable)((Object)("incompatible-" + name)), new Serializable[]{String.valueOf(vPrice)});
        }
    }

    @Override
    @DELETE
    @Path(value="{subscription:\\d+}/database")
    @Consumes(value={"application/json"})
    public UpdatedCost deleteAll(@PathParam(value="subscription") int subscription) {
        return super.deleteAll(subscription);
    }

    @Override
    @DELETE
    @Path(value="database/{id:\\d+}")
    @Consumes(value={"application/json"})
    public UpdatedCost delete(@PathParam(value="id") int id) {
        return super.delete(id);
    }

    @GET
    @Path(value="{subscription:\\d+}/database-lookup")
    @Consumes(value={"application/json"})
    public QuoteDatabaseLookup lookup(@PathParam(value="subscription") int subscription, @BeanParam QuoteDatabaseQuery query) {
        return (QuoteDatabaseLookup)this.lookupInternal(subscription, query);
    }

    @Override
    protected List<Object[]> findLowestPrice(ProvQuote configuration, QuoteDatabase query, List<Integer> types, List<Integer> terms, int location, double rate, double duration, double initialCost, Optimizer optimizer) {
        String licenseR = this.getLicense(configuration, query.getLicense(), query.getEngine(), this::canByol);
        String engineR = this.normalize(query.getEngine());
        String editionR = this.normalize(query.getEdition());
        if (optimizer == Optimizer.CO2) {
            return this.ipRepository.findLowestCo2(types, terms, location, rate, duration, licenseR, engineR, editionR, initialCost, (Pageable)PageRequest.of((int)0, (int)1));
        }
        return this.ipRepository.findLowestCost(types, terms, location, rate, duration, licenseR, engineR, editionR, initialCost, (Pageable)PageRequest.of((int)0, (int)1));
    }

    @Override
    protected List<Object[]> findLowestDynamicPrice(ProvQuote configuration, QuoteDatabase query, List<Integer> types, List<Integer> terms, double cpu, double gpu, double ram, int location, double rate, int duration, double initialCost, Optimizer optimizer) {
        String licenseR = this.getLicense(configuration, query.getLicense(), query.getEngine(), this::canByol);
        String engineR = this.normalize(query.getEngine());
        String editionR = this.normalize(query.getEdition());
        if (optimizer == Optimizer.CO2) {
            return this.ipRepository.findLowestDynamicCo2(types, terms, Math.ceil(cpu), gpu, Math.ceil(this.round(ram / 1024.0)), engineR, editionR, location, rate, this.round(rate * (double)duration), duration, licenseR, initialCost, (Pageable)PageRequest.of((int)0, (int)1));
        }
        return this.ipRepository.findLowestDynamicCost(types, terms, Math.ceil(cpu), gpu, Math.ceil(this.round(ram / 1024.0)), engineR, editionR, location, rate, this.round(rate * (double)duration), duration, licenseR, initialCost, (Pageable)PageRequest.of((int)0, (int)1));
    }

    private boolean canByol(String engine) {
        return ENGINE_ORACLE.equalsIgnoreCase(engine);
    }

    @Override
    @GET
    @Path(value="{subscription:\\d+}/database-price-term")
    @Consumes(value={"application/json"})
    public TableItem<ProvInstancePriceTerm> findPriceTerms(@PathParam(value="subscription") int subscription, @Context UriInfo uriInfo) {
        return super.findPriceTerms(subscription, uriInfo);
    }

    @GET
    @Path(value="{subscription:\\d+}/database-license/{engine}")
    public List<String> findLicenses(@PathParam(value="subscription") int subscription, @PathParam(value="engine") String engine) {
        List<String> result = this.ipRepository.findAllLicenses(this.subscriptionResource.checkVisible(Integer.valueOf(subscription)).getNode().getTool().getId(), this.normalize(engine));
        result.replaceAll(l -> (String)StringUtils.defaultIfBlank((CharSequence)l, (CharSequence)"INCLUDED"));
        return result;
    }

    @GET
    @Path(value="{subscription:\\d+}/database-engine")
    public List<String> findEngines(@PathParam(value="subscription") int subscription) {
        return this.ipRepository.findAllEngines(this.subscriptionResource.checkVisible(Integer.valueOf(subscription)).getNode().getTool().getId());
    }

    @GET
    @Path(value="{subscription:\\d+}/database-edition/{engine}")
    public List<String> findEditions(@PathParam(value="subscription") int subscription, @PathParam(value="engine") String engine) {
        return this.ipRepository.findAllEditions(this.subscriptionResource.checkVisible(Integer.valueOf(subscription)).getNode().getTool().getId(), this.normalize(engine));
    }

    @Override
    @GET
    @Path(value="{subscription:\\d+}/database-type")
    @Consumes(value={"application/json"})
    public TableItem<ProvDatabaseType> findAllTypes(@PathParam(value="subscription") int subscription, @Context UriInfo uriInfo) {
        return super.findAllTypes(subscription, uriInfo);
    }

    @Override
    protected QuoteDatabaseLookup newPrice(Object[] rs) {
        QuoteDatabaseLookup result = new QuoteDatabaseLookup();
        result.setPrice((ProvDatabasePrice)rs[0]);
        result.setCost(this.round((Double)rs[2]));
        result.setCo2(this.round((Double)rs[4]));
        return result;
    }

    @Override
    @Generated
    public ProvDatabasePriceRepository getIpRepository() {
        return this.ipRepository;
    }

    @Generated
    public ProvQuoteDatabaseRepository getQiRepository() {
        return this.qiRepository;
    }

    @Override
    @Generated
    public ProvDatabaseTypeRepository getItRepository() {
        return this.itRepository;
    }
}

