/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.quote.instance;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.app.plugin.prov.AbstractProvQuoteInstanceOsResource;
import org.ligoj.app.plugin.prov.ProvisioningService;
import org.ligoj.app.plugin.prov.UpdatedCost;
import org.ligoj.app.plugin.prov.dao.Optimizer;
import org.ligoj.app.plugin.prov.dao.ProvInstancePriceRepository;
import org.ligoj.app.plugin.prov.dao.ProvInstanceTypeRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteInstanceRepository;
import org.ligoj.app.plugin.prov.model.ProvInstancePrice;
import org.ligoj.app.plugin.prov.model.ProvInstancePriceTerm;
import org.ligoj.app.plugin.prov.model.ProvInstanceType;
import org.ligoj.app.plugin.prov.model.ProvQuote;
import org.ligoj.app.plugin.prov.model.ProvQuoteInstance;
import org.ligoj.app.plugin.prov.model.ProvTenancy;
import org.ligoj.app.plugin.prov.model.QuoteInstance;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.app.plugin.prov.model.VmOs;
import org.ligoj.app.plugin.prov.quote.instance.QuoteInstanceEditionVo;
import org.ligoj.app.plugin.prov.quote.instance.QuoteInstanceLookup;
import org.ligoj.app.plugin.prov.quote.instance.QuoteInstanceQuery;
import org.ligoj.bootstrap.core.json.TableItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/prov")
@Produces(value={"application/json"})
@Transactional
public class ProvQuoteInstanceResource
extends AbstractProvQuoteInstanceOsResource<ProvInstanceType, ProvInstancePrice, ProvQuoteInstance, QuoteInstanceEditionVo, QuoteInstanceLookup, QuoteInstance> {
    @Autowired
    private ProvInstancePriceRepository ipRepository;
    @Autowired
    private ProvQuoteInstanceRepository qiRepository;
    @Autowired
    private ProvInstanceTypeRepository itRepository;

    @Override
    protected ResourceType getType() {
        return ResourceType.INSTANCE;
    }

    @Override
    @POST
    @Path(value="instance")
    @Consumes(value={"application/json"})
    public UpdatedCost create(QuoteInstanceEditionVo vo) {
        return this.saveOrUpdate(new ProvQuoteInstance(), vo);
    }

    @Override
    @PUT
    @Path(value="instance")
    @Consumes(value={"application/json"})
    public UpdatedCost update(QuoteInstanceEditionVo vo) {
        return super.update(vo);
    }

    @Override
    protected void saveOrUpdateSpec(ProvQuoteInstance entity, QuoteInstanceEditionVo vo) {
        entity.setSoftware(StringUtils.trimToNull((String)vo.getSoftware()));
        entity.setTenancy((ProvTenancy)((Object)ObjectUtils.getIfNull((Object)((Object)vo.getTenancy()), (Object)((Object)ProvTenancy.SHARED))));
        super.saveOrUpdateSpec(entity, vo);
        this.checkOs(entity);
    }

    @Override
    @DELETE
    @Path(value="{subscription:\\d+}/instance")
    @Consumes(value={"application/json"})
    public UpdatedCost deleteAll(@PathParam(value="subscription") int subscription) {
        return super.deleteAll(subscription);
    }

    @Override
    @DELETE
    @Path(value="instance/{id:\\d+}")
    @Consumes(value={"application/json"})
    public UpdatedCost delete(@PathParam(value="id") int id) {
        return super.delete(id);
    }

    @GET
    @Path(value="{subscription:\\d+}/instance-lookup")
    @Consumes(value={"application/json"})
    public QuoteInstanceLookup lookup(@PathParam(value="subscription") int subscription, @BeanParam QuoteInstanceQuery query) {
        return (QuoteInstanceLookup)this.lookupInternal(subscription, query);
    }

    @Override
    protected List<Object[]> findLowestPrice(ProvQuote configuration, QuoteInstance query, List<Integer> types, List<Integer> terms, int location, double rate, double duration, double initialCost, Optimizer optimizer) {
        ProvisioningService service = this.getService(configuration);
        VmOs os = service.getCatalogOs(query.getOs());
        String licenseR = this.normalize(this.getLicense(configuration, query.getLicense(), os, x$0 -> this.canByol((VmOs)((Object)x$0))));
        String softwareR = this.normalize(query.getSoftware());
        ProvTenancy tenancyR = (ProvTenancy)((Object)ObjectUtils.getIfNull((Object)((Object)query.getTenancy()), (Object)((Object)ProvTenancy.SHARED)));
        if (optimizer == Optimizer.CO2) {
            return this.ipRepository.findLowestCo2(types, terms, os, location, rate, duration, licenseR, softwareR, initialCost, tenancyR, (Pageable)PageRequest.of((int)0, (int)1));
        }
        return this.ipRepository.findLowestCost(types, terms, os, location, rate, duration, licenseR, softwareR, initialCost, tenancyR, (Pageable)PageRequest.of((int)0, (int)1));
    }

    @Override
    protected List<Object[]> findLowestDynamicPrice(ProvQuote configuration, QuoteInstance query, List<Integer> types, List<Integer> terms, double cpu, double gpu, double ram, int location, double rate, int duration, double initialCost, Optimizer optimizer) {
        ProvisioningService service = this.getService(configuration);
        VmOs os = service.getCatalogOs(query.getOs());
        String licenseR = this.normalize(this.getLicense(configuration, query.getLicense(), os, x$0 -> this.canByol((VmOs)((Object)x$0))));
        String softwareR = this.normalize(query.getSoftware());
        ProvTenancy tenancyR = (ProvTenancy)((Object)ObjectUtils.getIfNull((Object)((Object)query.getTenancy()), (Object)((Object)ProvTenancy.SHARED)));
        if (optimizer == Optimizer.CO2) {
            return this.ipRepository.findLowestDynamicCo2(types, terms, Math.ceil(Math.max(1.0, cpu)), gpu, Math.ceil(this.round(ram / 1024.0)), os, location, rate, this.round(rate * (double)duration), duration, licenseR, softwareR, initialCost, tenancyR, (Pageable)PageRequest.of((int)0, (int)1));
        }
        return this.ipRepository.findLowestDynamicCost(types, terms, Math.ceil(Math.max(1.0, cpu)), gpu, Math.ceil(this.round(ram / 1024.0)), os, location, rate, this.round(rate * (double)duration), duration, licenseR, softwareR, initialCost, tenancyR, (Pageable)PageRequest.of((int)0, (int)1));
    }

    @Override
    @GET
    @Path(value="{subscription:\\d+}/instance-price-term")
    @Consumes(value={"application/json"})
    public TableItem<ProvInstancePriceTerm> findPriceTerms(@PathParam(value="subscription") int subscription, @Context UriInfo uriInfo) {
        return super.findPriceTerms(subscription, uriInfo);
    }

    @Override
    @GET
    @Path(value="{subscription:\\d+}/instance-license/{os}")
    public List<String> findLicenses(@PathParam(value="subscription") int subscription, @PathParam(value="os") VmOs os) {
        return super.findLicenses(subscription, os);
    }

    @GET
    @Path(value="{subscription:\\d+}/instance-software/{os}")
    public List<String> findSoftwareNames(@PathParam(value="subscription") int subscription, @PathParam(value="os") VmOs os) {
        return this.ipRepository.findAllSoftwareNames(this.subscriptionResource.checkVisible(Integer.valueOf(subscription)).getNode().getTool().getId(), os);
    }

    @Override
    @GET
    @Path(value="{subscription:\\d+}/instance-os")
    public List<String> findOs(@PathParam(value="subscription") int subscription) {
        return super.findOs(subscription);
    }

    @Override
    @GET
    @Path(value="{subscription:\\d+}/instance-type")
    @Consumes(value={"application/json"})
    public TableItem<ProvInstanceType> findAllTypes(@PathParam(value="subscription") int subscription, @Context UriInfo uriInfo) {
        return super.findAllTypes(subscription, uriInfo);
    }

    @Override
    protected QuoteInstanceLookup newPrice(Object[] rs) {
        QuoteInstanceLookup result = new QuoteInstanceLookup();
        result.setPrice((ProvInstancePrice)rs[0]);
        result.setCost(this.round((Double)rs[2]));
        result.setCo2(this.round((Double)rs[4]));
        return result;
    }

    @Override
    @Generated
    public ProvInstancePriceRepository getIpRepository() {
        return this.ipRepository;
    }

    @Generated
    public ProvQuoteInstanceRepository getQiRepository() {
        return this.qiRepository;
    }

    @Override
    @Generated
    public ProvInstanceTypeRepository getItRepository() {
        return this.itRepository;
    }
}

