/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.terraform;

import com.hazelcast.cache.HazelcastCacheManager;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.CacheConfiguration;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.cache.configuration.Configuration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ModifiedExpiryPolicy;
import org.ligoj.bootstrap.resource.system.cache.CacheManagerAware;
import org.springframework.stereotype.Component;

@Component
public class ProvCache
implements CacheManagerAware {
    public void onCreate(HazelcastCacheManager cacheManager, Function<String, CacheConfig<?, ?>> provider) {
        cacheManager.createCache("terraform-version", provider.apply("terraform-version"));
        CacheConfiguration cfgTVL = provider.apply("terraform-version-latest").setExpiryPolicyFactory(ModifiedExpiryPolicy.factoryOf((Duration)Duration.ONE_DAY));
        cacheManager.createCache("terraform-version-latest", (Configuration)cfgTVL);
        CacheConfig cfgPL = provider.apply("prov-location").setEvictionConfig(new EvictionConfig().setEvictionPolicy(EvictionPolicy.LRU).setSize(1000));
        cacheManager.createCache("prov-location", (Configuration)cfgPL);
        this.createCacheEvict(cacheManager, provider, "prov-instance-type", "prov-instance-type-dyn", "prov-instance-type-has-dyn", "prov-instance-has-co2", "prov-instance-term", "prov-database-type", "prov-database-type-dyn", "prov-database-type-has-dyn", "prov-database-has-co2", "prov-container-type", "prov-container-type-dyn", "prov-container-type-has-dyn", "prov-container-has-co2", "prov-function-type", "prov-function-type-dyn", "prov-function-type-has-dyn", "prov-function-has-co2");
        this.createCache(cacheManager, provider, "prov-processor", "prov-instance-software", "prov-instance-license", "prov-instance-os", "prov-database-engine", "prov-database-edition", "prov-database-license", "prov-container-license", "prov-container-os");
    }

    private void createCache(HazelcastCacheManager cacheManager, Function<String, CacheConfig<?, ?>> provider, String ... names) {
        Stream.of(names).forEach(name -> cacheManager.createCache(name, (Configuration)((CacheConfig)provider.apply((String)name))));
    }

    private void createCacheEvict(HazelcastCacheManager cacheManager, Function<String, CacheConfig<?, ?>> provider, String ... names) {
        Stream.of(names).forEach(name -> {
            CacheConfig cfgPIT = ((CacheConfig)provider.apply((String)name)).setEvictionConfig(new EvictionConfig().setEvictionPolicy(EvictionPolicy.LRU).setSize(1000));
            cacheManager.createCache(name, (Configuration)cfgPIT);
        });
    }
}

