/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.terraform;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.ligoj.app.model.Subscription;
import org.ligoj.app.plugin.prov.model.TerraformStatus;
import org.ligoj.app.plugin.prov.terraform.TerraformAction;
import org.ligoj.app.plugin.prov.terraform.TerraformContext;
import org.ligoj.app.plugin.prov.terraform.TerraformRunnerResource;
import org.ligoj.app.plugin.prov.terraform.TerraformUtils;
import org.ligoj.bootstrap.core.resource.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TerraformBaseCommand
implements TerraformAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TerraformBaseCommand.class);
    private static final Pattern SHOW_CHANGE = Pattern.compile("^\\s*([\\-~+/]+)");
    private static final Pattern STATE_CHANGE = Pattern.compile("^[^\\s]+$");
    @Autowired
    protected TerraformUtils utils;
    @Autowired
    protected TerraformRunnerResource runner;

    protected void computeWorkload(Subscription subscription) {
        this.runner.nextStep((Serializable)((Object)subscription.getNode().getId()), t -> this.computeWorkload(subscription, (TerraformStatus)t));
    }

    protected void computeWorkload(Subscription subscription, TerraformStatus status) {
        AtomicInteger added = new AtomicInteger();
        AtomicInteger deleted = new AtomicInteger();
        AtomicInteger updated = new AtomicInteger();
        AtomicInteger replaced = new AtomicInteger();
        try (Stream<String> stream = Files.lines(this.utils.toFile(subscription, "show.log").toPath());){
            stream.map(SHOW_CHANGE::matcher).filter(Matcher::find).forEach(matcher -> {
                switch (matcher.group(1)) {
                    case "+": {
                        added.incrementAndGet();
                        break;
                    }
                    case "-": {
                        deleted.incrementAndGet();
                        break;
                    }
                    case "-/+": {
                        replaced.incrementAndGet();
                        break;
                    }
                    default: {
                        updated.incrementAndGet();
                    }
                }
            });
        }
        catch (IOException e) {
            log.warn("Unable to get the full workload from the 'show' command", (Throwable)e);
        }
        status.setToAdd(added.get());
        status.setToReplace(replaced.get());
        status.setToDestroy(deleted.get());
        status.setToReplace(replaced.get());
        status.setToUpdate(updated.get());
    }

    protected void computeWorkloadState(Subscription subscription) {
        this.runner.nextStep((Serializable)((Object)subscription.getNode().getId()), t -> this.computeWorkloadState(subscription, (TerraformStatus)t));
    }

    protected void computeWorkloadState(Subscription subscription, TerraformStatus status) {
        try (Stream<String> stream = Files.lines(this.utils.toFile(subscription, "state.log").toPath());){
            status.setToDestroy((int)stream.map(STATE_CHANGE::matcher).filter(Matcher::find).count());
        }
        catch (IOException e) {
            log.warn("Unable to get the full workload from the 'state' command", (Throwable)e);
        }
    }

    @Override
    public void execute(TerraformContext context, OutputStream out, String ... arguments) throws IOException, InterruptedException {
        this.handleCode(context.getSubscription(), out, this.execute(context.getSubscription(), out, arguments));
        String command = arguments[0];
        if ("show".equals(command)) {
            this.computeWorkload(context.getSubscription());
        } else if ("state".equals(command) && "list".equals(arguments[1])) {
            this.computeWorkloadState(context.getSubscription());
        }
    }

    public int execute(File directory, OutputStream out, String ... arguments) throws InterruptedException, IOException {
        FileUtils.forceMkdir((File)directory);
        ProcessBuilder builder = this.utils.newBuilder(arguments).redirectErrorStream(true).directory(directory);
        Process process = builder.start();
        process.getInputStream().transferTo(out);
        int code = process.waitFor();
        out.flush();
        return code;
    }

    private int execute(Subscription subscription, OutputStream out, String ... command) throws InterruptedException, IOException {
        return this.execute(this.utils.toFile(subscription, new String[0]), out, command);
    }

    private void handleCode(Subscription subscription, OutputStream out, int code) throws IOException {
        if (code == 0) {
            log.info("Terraform paused for {} ({}) : {}", new Object[]{subscription.getId(), subscription, code});
            out.write(("Terraform exit code " + code + " -> no need to continue").getBytes());
        } else if (code != 2) {
            log.error("Terraform failed for {} ({}) : {}", new Object[]{subscription.getId(), subscription, code});
            out.write(("Terraform exit code " + code + " -> aborted").getBytes());
            throw new BusinessException("aborted", new Object[0]);
        }
    }
}

