/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.terraform;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheResult;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.ligoj.app.dao.SubscriptionRepository;
import org.ligoj.app.model.Node;
import org.ligoj.app.model.Subscription;
import org.ligoj.app.plugin.prov.ProvResource;
import org.ligoj.app.plugin.prov.model.TerraformStatus;
import org.ligoj.app.plugin.prov.terraform.TerraformAction;
import org.ligoj.app.plugin.prov.terraform.TerraformBaseCommand;
import org.ligoj.app.plugin.prov.terraform.TerraformContext;
import org.ligoj.app.plugin.prov.terraform.TerraformInformation;
import org.ligoj.app.plugin.prov.terraform.TerraformRunnerResource;
import org.ligoj.app.plugin.prov.terraform.TerraformSequence;
import org.ligoj.app.plugin.prov.terraform.TerraformUtils;
import org.ligoj.app.plugin.prov.terraform.Terraforming;
import org.ligoj.app.resource.ServicePluginLocator;
import org.ligoj.app.resource.node.NodeResource;
import org.ligoj.app.resource.plugin.AbstractToolPluginResource;
import org.ligoj.app.resource.subscription.SubscriptionResource;
import org.ligoj.bootstrap.core.resource.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
@jakarta.ws.rs.Path(value="/service/prov")
@Produces(value={"application/json"})
@Transactional
public class TerraformResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TerraformResource.class);
    private static final Pattern TERRAFORM_VERSION = Pattern.compile(".* v(\\S+)\\s+.*");
    @Autowired
    private SubscriptionResource subscriptionResource;
    @Autowired
    private SubscriptionRepository subscriptionRepository;
    @Autowired
    protected ProvResource resource;
    @Autowired
    protected TerraformRunnerResource runner;
    @Autowired
    protected ServicePluginLocator locator;
    @Autowired
    protected TerraformUtils utils;
    @Autowired
    protected TerraformResource self;
    @Autowired
    protected TerraformBaseCommand executableCommand;
    @Autowired
    private NodeResource nodeResource;
    private final Map<String, TerraformAction> commandMapping = new HashMap<String, TerraformAction>();

    public TerraformResource() {
        this.commandMapping.put("generate", (context, out, arguments) -> this.getImpl(context.getSubscription().getNode()).generate(context));
        this.commandMapping.put("secrets", (context, out, arguments) -> this.getImpl(context.getSubscription().getNode()).generateSecrets(context));
        this.commandMapping.put("clean", (context, out, arguments) -> this.clean(context.getSubscription()));
    }

    @GET
    @Produces(value={"application/octet-stream"})
    @jakarta.ws.rs.Path(value="{subscription:\\d+}/{file:.*.zip}")
    public Response download(@PathParam(value="subscription") int subscription, @PathParam(value="file") String file) {
        Subscription subscription2 = this.subscriptionResource.checkVisible(Integer.valueOf(subscription));
        return AbstractToolPluginResource.download(o -> this.utils.zip(subscription2, o), (String)file).build();
    }

    @GET
    @Produces(value={"text/plain"})
    @jakarta.ws.rs.Path(value="{subscription:\\d+}/terraform.log")
    public Response getLog(@PathParam(value="subscription") int subscription) {
        Subscription entity = this.subscriptionResource.checkVisible(Integer.valueOf(subscription));
        StreamingOutput so = o -> {
            for (String command : Optional.ofNullable(this.runner.getTask(subscription)).map(s -> s.getSequence().split(",")).orElse(ArrayUtils.EMPTY_STRING_ARRAY)) {
                File log = this.utils.toFile(entity, command + ".log");
                if (!log.exists()) continue;
                o.write(("---- " + command + " ----\n").getBytes());
                FileUtils.copyFile((File)log, (OutputStream)o);
                o.write("\n".getBytes());
            }
        };
        return Response.ok().entity((Object)so).build();
    }

    @POST
    @jakarta.ws.rs.Path(value="{subscription:\\d+}/terraform")
    public TerraformStatus create(@PathParam(value="subscription") int subscription, TerraformContext context) {
        return this.sequenceNewThread(subscription, context, TerraformSequence.CREATE);
    }

    @DELETE
    @jakarta.ws.rs.Path(value="{subscription:\\d+}/terraform")
    public TerraformStatus destroy(@PathParam(value="subscription") int subscription, TerraformContext context) {
        return this.sequenceNewThread(subscription, context, TerraformSequence.DESTROY);
    }

    private TerraformStatus sequenceNewThread(int subscription, TerraformContext context, TerraformSequence sequence) {
        Subscription entity = this.subscriptionResource.checkVisible(Integer.valueOf(subscription));
        this.getImpl(entity.getNode());
        log.info("Terraform {} request for {} ({})", new Object[]{sequence, subscription, entity});
        SecurityContext securityContext = SecurityContextHolder.getContext();
        context.setSubscription(entity);
        context.setSequence(this.utils.getTerraformCommands(sequence));
        context.getContext().entrySet().forEach(e -> e.setValue(StringUtils.trim((String)((String)e.getValue()))));
        TerraformStatus task = this.startTask(context, sequence);
        Executors.newSingleThreadExecutor().submit(() -> {
            log.info("Terraform {} start for {} ({})", new Object[]{sequence, subscription, entity});
            try {
                SecurityContextHolder.setContext((SecurityContext)securityContext);
                Thread.sleep(50L);
                this.self.sequenceNewTransaction(context);
                log.info("Terraform {} succeed for {} ({})", new Object[]{sequence, subscription, entity});
            }
            catch (Exception e) {
                log.error("Terraform {} failed for {} ({})", new Object[]{sequence, subscription, entity, e});
            }
            return null;
        });
        return task;
    }

    protected TerraformStatus startTask(TerraformContext context, TerraformSequence type) {
        return (TerraformStatus)this.runner.startTask((Serializable)((Object)context.getSubscription().getNode().getId()), t -> {
            t.setSequence(context.getSequence().stream().map(s -> s[0]).collect(Collectors.joining(",")));
            t.setSubscription((Integer)context.getSubscription().getId());
            t.setCommandIndex(null);
            t.setType(type);
            t.setToAdd(0);
            t.setToDestroy(0);
            t.setToUpdate(0);
            t.setToReplace(0);
            t.setCompleting(0);
            t.setCompleted(0);
        });
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void sequenceNewTransaction(TerraformContext context) throws IOException, InterruptedException {
        boolean failed = true;
        try {
            context.setQuote(this.resource.getConfiguration((Integer)context.getSubscription().getId()));
            context.setSubscription((Subscription)this.subscriptionRepository.findOneExpected((Serializable)((Integer)context.getSubscription().getId())));
            this.sequenceInternal(context);
            failed = false;
        }
        catch (Throwable throwable) {
            this.runner.endTask((Serializable)((Object)context.getSubscription().getNode().getId()), failed);
            FileUtils.deleteQuietly((File)this.utils.toFile(context.getSubscription(), "secrets.auto.tfvars"));
            throw throwable;
        }
        this.runner.endTask((Serializable)((Object)context.getSubscription().getNode().getId()), failed);
        FileUtils.deleteQuietly((File)this.utils.toFile(context.getSubscription(), "secrets.auto.tfvars"));
    }

    protected void clean(Subscription subscription) throws IOException {
        Path parent = this.utils.toFile(subscription, new String[0]).toPath();
        try (Stream<Path> files = Files.walk(parent, new FileVisitOption[0]);){
            files.filter(path -> !Strings.CS.endsWithAny((CharSequence)path.toString(), new CharSequence[]{".tfstate", ".tfstate.backup", ".keep.tf", ".keep.auto.tfvars"})).filter(path -> !path.toFile().isDirectory()).filter(path -> !path.toString().contains(".terraform")).map(Path::toFile).forEach(FileUtils::deleteQuietly);
        }
    }

    private Terraforming getImpl(Node node) {
        return Optional.ofNullable((Terraforming)this.locator.getResource(node.getId(), Terraforming.class)).orElseThrow(() -> new BusinessException("terraform-no-supported", new Object[]{node.getRefined().getId()}));
    }

    private void sequenceInternal(TerraformContext context) throws InterruptedException, IOException {
        Subscription subscription = context.getSubscription();
        for (String[] arguments : context.getSequence()) {
            String command = arguments[0];
            this.runner.nextStep((Serializable)((Object)subscription.getNode().getId()), t -> t.setCommandIndex(t.getCommandIndex() == null ? 0 : t.getCommandIndex() + 1));
            try (FileOutputStream out = new FileOutputStream(this.utils.toFile(subscription, command + ".log"));){
                this.getAction(command).execute(context, out, arguments);
            }
        }
    }

    protected TerraformAction getAction(String command) {
        return this.commandMapping.getOrDefault(command, this.executableCommand);
    }

    @CacheResult(cacheName="terraform-version")
    @jakarta.ws.rs.Path(value="terraform/install")
    @GET
    public TerraformInformation getVersion() throws IOException, InterruptedException {
        this.nodeResource.checkWritableNode(ProvResource.SERVICE_KEY);
        TerraformInformation result = new TerraformInformation();
        if (this.utils.isInstalled()) {
            result.setInstalled(true);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int code = this.executableCommand.execute(this.utils.getHome().toFile(), (OutputStream)bos, "-v");
            String output = bos.toString();
            if (code == 0) {
                Matcher matcher = TERRAFORM_VERSION.matcher(output);
                if (matcher.find()) {
                    result.setVersion(matcher.group(1));
                }
            } else {
                log.error("Unable to get Terraform version, code: {}, output: {}", (Object)code, (Object)output);
            }
        }
        result.setLastVersion(this.utils.getLatestVersion());
        return result;
    }

    @CacheRemoveAll(cacheName="terraform-version")
    @jakarta.ws.rs.Path(value="terraform/version/{version:\\d+\\.\\d+\\.\\d+.*}")
    @POST
    public TerraformInformation install(@PathParam(value="version") String version) throws IOException, InterruptedException {
        this.nodeResource.checkWritableNode(ProvResource.SERVICE_KEY);
        this.utils.install(version);
        return this.getVersion();
    }
}

