/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.terraform;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import org.ligoj.app.dao.NodeRepository;
import org.ligoj.app.model.Subscription;
import org.ligoj.app.plugin.prov.dao.TerraformStatusRepository;
import org.ligoj.app.plugin.prov.model.TerraformStatus;
import org.ligoj.app.plugin.prov.terraform.TerraformUtils;
import org.ligoj.app.resource.ServicePluginLocator;
import org.ligoj.app.resource.node.LongTaskRunnerNode;
import org.ligoj.app.resource.node.NodeResource;
import org.ligoj.app.resource.subscription.SubscriptionResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/prov")
@Produces(value={"application/json"})
@Transactional
public class TerraformRunnerResource
implements LongTaskRunnerNode<TerraformStatus, TerraformStatusRepository> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TerraformRunnerResource.class);
    private static final Pattern PATTERN_APPLY = Pattern.compile("^[^\\s:]+: (([A-Za-z]+)\\.|([A-Za-z]+) complete)(.*)");
    private static final Pattern PATTERN_DESTROY = Pattern.compile("^(.+: (Destroying)\\.|.+: (Destruction) complete|data\\.[^:]+:+ (Refreshing))");
    private static final Set<String> COMPLETED_OPERATIONS = new HashSet<String>(Arrays.asList("Destruction", "Creation", "Modifications", "Refreshing"));
    private static final Set<String> PENDING_OPERATIONS = new HashSet<String>(Arrays.asList("Creating", "Modifying", "Destroying"));
    @Autowired
    protected TerraformStatusRepository taskRepository;
    @Autowired
    private NodeRepository nodeRepository;
    @Autowired
    private NodeResource nodeResource;
    @Autowired
    private SubscriptionResource subscriptionResource;
    @Autowired
    protected ServicePluginLocator locator;
    @Autowired
    protected TerraformUtils utils;

    public Supplier<TerraformStatus> newTask() {
        return TerraformStatus::new;
    }

    @GET
    @Path(value="{subscription:\\d+}/terraform")
    @org.springframework.transaction.annotation.Transactional(readOnly=true)
    public TerraformStatus getTask(@PathParam(value="subscription") int subscription) {
        return this.getTaskInternal(this.getSubscriptionResource().checkVisible(Integer.valueOf(subscription)));
    }

    @org.springframework.transaction.annotation.Transactional(readOnly=true)
    public TerraformStatus getTaskInternal(Subscription subscription) {
        TerraformStatus status = (TerraformStatus)this.getTaskInternal((Serializable)((Object)subscription.getNode().getId()));
        if (status == null || status.getSubscription() != ((Integer)subscription.getId()).intValue()) {
            return null;
        }
        if (status.getSequence().contains("apply")) {
            this.completeProgress(subscription, status, "apply.log", this::parseApplyLogLine);
        }
        if (status.getSequence().contains("destroy")) {
            this.completeProgress(subscription, status, "destroy.log", this::parseDestroyLogLine);
        }
        return status;
    }

    private void completeProgress(Subscription subscription, TerraformStatus status, String file, BiConsumer<TerraformStatus, Stream<String>> apply) {
        try (Stream<String> stream = this.utils.toFile(subscription, file).exists() ? Files.lines(this.utils.toFile(subscription, file).toPath()) : Arrays.stream(new String[0]);){
            apply.accept(status, stream);
        }
        catch (Exception e) {
            log.warn("Unable to read log file {}", (Object)file, (Object)e);
        }
    }

    protected void parseApplyLogLine(TerraformStatus status, Stream<String> stream) {
        this.parseLogLine(status, stream, PATTERN_APPLY);
    }

    protected void parseDestroyLogLine(TerraformStatus status, Stream<String> stream) {
        this.parseLogLine(status, stream, PATTERN_DESTROY);
    }

    private void parseLogLine(TerraformStatus status, Stream<String> stream, Pattern pattern) {
        stream.map(pattern::matcher).filter(Matcher::find).forEach(matcher -> {
            if (COMPLETED_OPERATIONS.contains(matcher.group(3))) {
                status.setCompleting(status.getCompleting() - 1);
                status.setCompleted(status.getCompleted() + 1);
            } else if (COMPLETED_OPERATIONS.contains(matcher.group(4))) {
                status.setCompleted(status.getCompleted() + 1);
            } else if (PENDING_OPERATIONS.contains(matcher.group(2))) {
                status.setCompleting(status.getCompleting() + 1);
            }
        });
    }

    @Generated
    public TerraformStatusRepository getTaskRepository() {
        return this.taskRepository;
    }

    @Generated
    public NodeRepository getNodeRepository() {
        return this.nodeRepository;
    }

    @Generated
    public NodeResource getNodeResource() {
        return this.nodeResource;
    }

    @Generated
    public SubscriptionResource getSubscriptionResource() {
        return this.subscriptionResource;
    }
}

