/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.terraform;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.cache.annotation.CacheResult;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.SystemUtils;
import org.ligoj.app.model.Subscription;
import org.ligoj.app.plugin.prov.terraform.TerraformSequence;
import org.ligoj.app.resource.plugin.LigojPluginsClassLoader;
import org.ligoj.bootstrap.core.curl.CurlProcessor;
import org.ligoj.bootstrap.core.resource.BusinessException;
import org.ligoj.bootstrap.resource.system.configuration.ConfigurationResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TerraformUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TerraformUtils.class);
    private static final String OS_DEFAULT = "default";
    private static final String OS_WINDOWS = "windows";
    private static final String TERRAFORM_PATH = "terraform.path";
    private static final String BASE_REPO = "https://releases.hashicorp.com/terraform/";
    private static final String CONF_REPO = "service:prov:terraform:repository";
    private static final Pattern VERSION_PATTERN = Pattern.compile("<a\\s+href\\s*=\\s*\"/terraform/([^/\"]+)/?\"\\s*>terraform_");
    private static final String[] TERRAFORM_SHELL_WIN = new String[]{"cmd.exe", "/c"};
    private static final String[] TERRAFORM_SHELL_LINUX = new String[]{"sh", "-c"};
    private final Map<String, String[]> shells = new HashMap<String, String[]>();
    @Autowired
    protected ConfigurationResource configuration;
    protected final Map<String, String> bins = new HashMap<String, String>();
    private final Map<String, String> distributions = new HashMap<String, String>();

    public TerraformUtils() {
        this.shells.put(OS_WINDOWS, TERRAFORM_SHELL_WIN);
        this.shells.put(OS_DEFAULT, TERRAFORM_SHELL_LINUX);
        this.distributions.put(OS_WINDOWS, "windows_amd64");
        this.distributions.put("mac", "darwin_amd64");
        this.distributions.put("freebsd", "freebsd_amd64");
        this.distributions.put("solaris", "solaris_amd64");
        this.distributions.put("openbsd", "openbsd_amd64");
        this.distributions.put(OS_DEFAULT, "linux_amd64");
        this.bins.put(OS_WINDOWS, "terraform.exe");
        this.bins.put(OS_DEFAULT, "terraform");
    }

    public ProcessBuilder newBuilder(String ... args) {
        if (!this.isInstalled()) {
            throw new BusinessException("terraform-not-found", new Object[0]);
        }
        Object[] shell = this.getOsValue(this.shells);
        String bin = this.getHome().resolve(this.configuration.get(TERRAFORM_PATH, this.getOsValue(this.bins))).toString();
        return new ProcessBuilder((String[])ArrayUtils.addAll((Object[])shell, (Object[])new String[]{bin + " " + String.join((CharSequence)" ", (CharSequence[])ArrayUtils.addAll((Object[])args, (Object[])new String[0]))}));
    }

    private <T> T getOsValue(Map<String, T> map) {
        return this.getOsValue(map, this.getCurrentOs());
    }

    protected <T> T getOsValue(Map<String, T> map, String os) {
        String[] osParts = StringUtils.trimToEmpty((String)os).toLowerCase(Locale.ENGLISH).split(" ");
        return (T)IntStream.iterate(osParts.length, i -> i - 1).limit(osParts.length).mapToObj(i -> map.get(StringUtils.join((Object[])osParts, (String)" ", (int)0, (int)i))).filter(Objects::nonNull).findFirst().orElseGet(() -> map.get(OS_DEFAULT));
    }

    public List<String[]> getTerraformCommands(TerraformSequence type) {
        return Arrays.stream(this.getTerraformSequence(type)).map(String::trim).map(this::getTerraformArguments).toList();
    }

    private String[] getTerraformArguments(String command) {
        return this.configuration.get("service:prov:terraform:command-" + command, command + " -v").split(" ");
    }

    public String[] getTerraformSequence(TerraformSequence type) {
        String key = "service:prov:terraform:sequence-" + type.name().toLowerCase();
        return this.configuration.get(key, "clean").split(",");
    }

    protected Path getHome() {
        return this.getClassLoader().getHomeDirectory().resolve("prov");
    }

    protected LigojPluginsClassLoader getClassLoader() {
        return LigojPluginsClassLoader.getInstance();
    }

    protected String getCurrentOs() {
        return SystemUtils.OS_NAME;
    }

    private Path getTerraformBin() {
        return this.getHome().resolve(this.getOsValue(this.bins));
    }

    protected boolean isInstalled() {
        return this.getTerraformBin().toFile().exists();
    }

    @CacheResult(cacheName="terraform-version-latest")
    public String getLatestVersion() {
        try (CurlProcessor curl = new CurlProcessor();){
            Matcher matcher = VERSION_PATTERN.matcher(Objects.toString(curl.get(this.configuration.get(CONF_REPO, BASE_REPO), new String[0]), ""));
            if (matcher.find()) {
                String string = matcher.group(1);
                return string;
            }
        }
        return null;
    }

    public void install() throws IOException {
        this.install(this.getLatestVersion());
    }

    public void install(String version) throws IOException {
        this.install(this.getHome().toFile(), this.configuration.get(CONF_REPO, BASE_REPO), version);
    }

    private void install(File toDir, String repository, String version) throws IOException {
        this.install(toDir, Strings.CS.appendIfMissing(repository, (CharSequence)"/", new CharSequence[0]) + version + "/terraform_" + version + "_" + this.getOsValue(this.distributions) + ".zip");
    }

    private void install(File toDir, String url) throws IOException {
        try (InputStream openStream = URI.create(url).toURL().openStream();){
            this.unzip(openStream, toDir).forEach(f -> f.setExecutable(true));
        }
    }

    public List<File> zip(Subscription subscription, OutputStream out) throws IOException {
        return this.zip(this.toFile(subscription, new String[0]).toPath(), out);
    }

    public List<File> zip(Path fromDir, OutputStream out) throws IOException {
        try (ZipOutputStream zs = new ZipOutputStream(out);){
            List<File> list;
            block11: {
                Stream<Path> stream = Files.walk(fromDir, new FileVisitOption[0]);
                try {
                    list = stream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).filter(path -> !Strings.CS.endsWithAny((CharSequence)path.toString(), new CharSequence[]{".ptf", "secrets.auto.tfvars"})).filter(path -> !path.toString().contains(".terraform")).map(path -> this.addEntry(fromDir, (Path)path, zs)).toList();
                    if (stream == null) break block11;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return list;
        }
    }

    protected File addEntry(Path fromDir, Path path, ZipOutputStream zs) {
        try {
            zs.putNextEntry(new ZipEntry(fromDir.relativize(path).toString()));
            Files.copy(path, zs);
            zs.closeEntry();
        }
        catch (IOException e) {
            log.error("Unable to create Zip file from {}", (Object)fromDir, (Object)e);
        }
        return path.toFile();
    }

    public List<File> unzip(InputStream source, File toDir) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        try (ZipInputStream zis = new ZipInputStream(source);){
            FileUtils.forceMkdir((File)toDir);
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File file = new File(toDir, zipEntry.getName());
                files.add(file);
                FileUtils.forceMkdirParent((File)file);
                FileOutputStream fos = new FileOutputStream(file);
                zis.transferTo(fos);
                fos.close();
                zipEntry = zis.getNextEntry();
            }
        }
        return files;
    }

    public File toFile(Subscription subscription, String ... fragments) throws IOException {
        return LigojPluginsClassLoader.getInstance().toPath(subscription, fragments).toFile();
    }
}

