/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.vm.schedule;

import java.text.MessageFormat;
import java.text.ParseException;
import org.apache.commons.lang3.ObjectUtils;
import org.ligoj.app.plugin.vm.dao.VmScheduleRepository;
import org.ligoj.app.plugin.vm.execution.VmExecutionResource;
import org.ligoj.app.plugin.vm.model.VmSchedule;
import org.ligoj.bootstrap.core.SpringUtils;
import org.ligoj.bootstrap.core.security.SecurityHelper;
import org.quartz.JobExecutionContext;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class VmJob
extends QuartzJobBean {
    private static final Logger log = LoggerFactory.getLogger(VmJob.class);
    private static final String TRIGGER_ID_PARSER = "{0,number,integer}-{1,number,integer}";

    protected void executeInternal(JobExecutionContext arg0) {
        int schedule = arg0.getMergedJobDataMap().getInt("schedule");
        ApplicationContext context = (ApplicationContext)ObjectUtils.defaultIfNull((Object)((ApplicationContext)arg0.getMergedJobDataMap().get((Object)"context")), (Object)SpringUtils.getApplicationContext());
        VmSchedule entity = (VmSchedule)((Object)((VmScheduleRepository)context.getBean(VmScheduleRepository.class)).findOneExpected(Integer.valueOf(schedule)));
        log.info("Executing {} for schedule {}, subscription {}", new Object[]{entity.getOperation(), entity.getId(), entity.getSubscription().getId()});
        ((SecurityHelper)context.getBean(SecurityHelper.class)).setUserName("_system");
        ((VmExecutionResource)context.getBean(VmExecutionResource.class)).execute(entity.getSubscription(), entity.getOperation());
        log.info("Succeed {} for schedule {}, subscription {}", new Object[]{entity.getOperation(), entity.getId(), entity.getSubscription().getId()});
    }

    protected static String format(VmSchedule schedule) {
        return String.valueOf(schedule.getId()) + "-" + String.valueOf(schedule.getSubscription().getId());
    }

    protected static int getSchedule(TriggerKey key) {
        return ((Long)VmJob.parse(key.getName())[0]).intValue();
    }

    protected static int getSubscription(TriggerKey key) {
        return ((Long)VmJob.parse(key.getName())[1]).intValue();
    }

    protected static Object[] parse(String source) {
        try {
            return new MessageFormat(TRIGGER_ID_PARSER).parse(source);
        }
        catch (ParseException e) {
            log.debug("Unable to parse job source", (Throwable)e);
            return new Object[2];
        }
    }
}

