/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.jackson;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.SerializableDatabase;
import org.linguafranca.pwdb.StreamConfiguration;
import org.linguafranca.pwdb.StreamFormat;
import org.linguafranca.pwdb.kdbx.KdbxHeader;
import org.linguafranca.pwdb.kdbx.KdbxStreamFormat;
import org.linguafranca.pwdb.kdbx.jackson.JacksonEntry;
import org.linguafranca.pwdb.kdbx.jackson.JacksonGroup;
import org.linguafranca.pwdb.kdbx.jackson.JacksonIcon;
import org.linguafranca.pwdb.kdbx.jackson.JacksonSerializableDatabase;
import org.linguafranca.pwdb.kdbx.jackson.model.KeePassFile;
import org.linguafranca.pwdb.protect.ProtectedDatabase;

public class JacksonDatabase
extends ProtectedDatabase<JacksonDatabase, JacksonGroup, JacksonEntry, JacksonIcon> {
    KeePassFile keePassFile;
    StreamFormat<?> streamFormat;

    public JacksonDatabase() throws IOException {
        this(JacksonSerializableDatabase.createEmptyDatabase(), null);
    }

    public JacksonDatabase(KeePassFile file, StreamFormat<?> streamFormat) {
        try {
            this.keePassFile = file;
            this.keePassFile.root.group.database = this;
            this.streamFormat = streamFormat;
            JacksonSerializableDatabase.fixUp(this.keePassFile.root.group);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static JacksonDatabase loadXml(InputStream inputStream) throws Exception {
        KeePassFile keePassFile = new JacksonSerializableDatabase().load((InputStream)inputStream).keePassFile;
        keePassFile.root.group.uuid = UUID.randomUUID();
        return new JacksonDatabase(keePassFile, null);
    }

    public static JacksonDatabase load(Credentials credentials, InputStream inputStream) throws IOException {
        JacksonSerializableDatabase jsd = new JacksonSerializableDatabase();
        KdbxStreamFormat streamFormat = new KdbxStreamFormat();
        streamFormat.load((SerializableDatabase)jsd, credentials, inputStream);
        return new JacksonDatabase(jsd.keePassFile, (StreamFormat<?>)streamFormat);
    }

    public void save(Credentials credentials, OutputStream outputStream) throws IOException {
        if (Objects.isNull(this.streamFormat)) {
            this.streamFormat = new KdbxStreamFormat(new KdbxHeader(4));
        }
        this.save(this.streamFormat, credentials, outputStream);
    }

    public <C extends StreamConfiguration> void save(StreamFormat<C> streamFormat, Credentials credentials, OutputStream outputStream) throws IOException {
        this.keePassFile.meta.generator = "KeePassJava2-Jackson";
        JacksonSerializableDatabase jacksonSerializableDatabase = new JacksonSerializableDatabase(this.keePassFile);
        jacksonSerializableDatabase.setPropertyValueStrategy(this.getPropertyValueStrategy());
        streamFormat.save((SerializableDatabase)jacksonSerializableDatabase, credentials, outputStream);
        this.setDirty(false);
    }

    public JacksonGroup getRootGroup() {
        return this.keePassFile.root.group;
    }

    public JacksonGroup newGroup() {
        return JacksonGroup.createGroup(this);
    }

    public JacksonEntry newEntry() {
        return JacksonEntry.createEntry(this);
    }

    public JacksonIcon newIcon() {
        return new JacksonIcon();
    }

    public JacksonIcon newIcon(Integer integer) {
        JacksonIcon ic = this.newIcon();
        ic.setIndex(integer);
        return ic;
    }

    public boolean isRecycleBinEnabled() {
        return this.keePassFile.meta.recycleBinEnabled;
    }

    public void enableRecycleBin(boolean enable) {
        this.keePassFile.meta.recycleBinEnabled = enable;
    }

    public JacksonGroup getRecycleBin() {
        UUID recycleBinUuid = this.keePassFile.meta.recycleBinUUID;
        JacksonGroup g = (JacksonGroup)this.findGroup(recycleBinUuid);
        if (g == null && this.isRecycleBinEnabled()) {
            g = (JacksonGroup)this.newGroup("Recycle Bin");
            this.getRootGroup().addGroup(g);
            this.keePassFile.meta.recycleBinUUID = g.getUuid();
            this.keePassFile.meta.recycleBinChanged = new Date();
        }
        return g;
    }

    public String getName() {
        return this.keePassFile.meta.databaseName;
    }

    public void setName(String s) {
        this.keePassFile.meta.databaseName = s;
        this.keePassFile.meta.databaseNameChanged = new Date();
        this.setDirty(true);
    }

    public String getDescription() {
        return this.keePassFile.meta.databaseDescription;
    }

    public void setDescription(String s) {
        this.keePassFile.meta.databaseDescription = s;
        this.keePassFile.meta.databaseDescriptionChanged = new Date();
        this.setDirty(true);
    }

    public boolean shouldProtect(String s) {
        return this.keePassFile.meta.memoryProtection.shouldProtect(s);
    }

    public List<KeePassFile.Binary> getBinaries() {
        return this.keePassFile.meta.binaries;
    }

    public void addBinary(byte[] bytes, int index) {
        JacksonSerializableDatabase.addBinary(this.keePassFile, index, bytes);
    }

    public StreamFormat<?> getStreamFormat() {
        return this.streamFormat;
    }
}

